/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddPermissionRequest extends LambdaRequest implements
        ToCopyableBuilder<AddPermissionRequest.Builder, AddPermissionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(AddPermissionRequest::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementId").getter(getter(AddPermissionRequest::statementId)).setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementId").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(AddPermissionRequest::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Principal").getter(getter(AddPermissionRequest::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(AddPermissionRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceAccount").getter(getter(AddPermissionRequest::sourceAccount))
            .setter(setter(Builder::sourceAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccount").build()).build();

    private static final SdkField<String> EVENT_SOURCE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceToken").getter(getter(AddPermissionRequest::eventSourceToken))
            .setter(setter(Builder::eventSourceToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceToken").build()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Qualifier").getter(getter(AddPermissionRequest::qualifier)).setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(AddPermissionRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            STATEMENT_ID_FIELD, ACTION_FIELD, PRINCIPAL_FIELD, SOURCE_ARN_FIELD, SOURCE_ACCOUNT_FIELD, EVENT_SOURCE_TOKEN_FIELD,
            QUALIFIER_FIELD, REVISION_ID_FIELD));

    private final String functionName;

    private final String statementId;

    private final String action;

    private final String principal;

    private final String sourceArn;

    private final String sourceAccount;

    private final String eventSourceToken;

    private final String qualifier;

    private final String revisionId;

    private AddPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.statementId = builder.statementId;
        this.action = builder.action;
        this.principal = builder.principal;
        this.sourceArn = builder.sourceArn;
        this.sourceAccount = builder.sourceAccount;
        this.eventSourceToken = builder.eventSourceToken;
        this.qualifier = builder.qualifier;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The name of the Lambda function, version, or alias.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can append a version number or alias to any of the formats. The length constraint applies only to the full
     * ARN. If you specify only the function name, it is limited to 64 characters in length.
     * </p>
     * 
     * @return The name of the Lambda function, version, or alias.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can append a version number or alias to any of the formats. The length constraint applies only to the
     *         full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * A statement identifier that differentiates the statement from others in the same policy.
     * </p>
     * 
     * @return A statement identifier that differentiates the statement from others in the same policy.
     */
    public final String statementId() {
        return statementId;
    }

    /**
     * <p>
     * The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or
     * <code>lambda:GetFunction</code>.
     * </p>
     * 
     * @return The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or
     *         <code>lambda:GetFunction</code>.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The Amazon Web Services service or account that invokes the function. If you specify a service, use
     * <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.
     * </p>
     * 
     * @return The Amazon Web Services service or account that invokes the function. If you specify a service, use
     *         <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that
     *         service.
     */
    public final String principal() {
        return principal;
    }

    /**
     * <p>
     * For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For
     * example, an Amazon S3 bucket or Amazon SNS topic.
     * </p>
     * <p>
     * Note that Lambda configures the comparison using the <code>StringLike</code> operator.
     * </p>
     * 
     * @return For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function.
     *         For example, an Amazon S3 bucket or Amazon SNS topic.</p>
     *         <p>
     *         Note that Lambda configures the comparison using the <code>StringLike</code> operator.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to
     * ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted
     * by its owner and recreated by another account.
     * </p>
     * 
     * @return For Amazon S3, the ID of the account that owns the resource. Use this together with
     *         <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for
     *         an Amazon S3 bucket to be deleted by its owner and recreated by another account.
     */
    public final String sourceAccount() {
        return sourceAccount;
    }

    /**
     * <p>
     * For Alexa Smart Home functions, a token that must be supplied by the invoker.
     * </p>
     * 
     * @return For Alexa Smart Home functions, a token that must be supplied by the invoker.
     */
    public final String eventSourceToken() {
        return eventSourceToken;
    }

    /**
     * <p>
     * Specify a version or alias to add permissions to a published version of the function.
     * </p>
     * 
     * @return Specify a version or alias to add permissions to a published version of the function.
     */
    public final String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying a
     * policy that has changed since you last read it.
     * </p>
     * 
     * @return Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid
     *         modifying a policy that has changed since you last read it.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceToken());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(statementId(), other.statementId())
                && Objects.equals(action(), other.action()) && Objects.equals(principal(), other.principal())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(sourceAccount(), other.sourceAccount())
                && Objects.equals(eventSourceToken(), other.eventSourceToken()) && Objects.equals(qualifier(), other.qualifier())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddPermissionRequest").add("FunctionName", functionName()).add("StatementId", statementId())
                .add("Action", action()).add("Principal", principal()).add("SourceArn", sourceArn())
                .add("SourceAccount", sourceAccount()).add("EventSourceToken", eventSourceToken()).add("Qualifier", qualifier())
                .add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "StatementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "SourceAccount":
            return Optional.ofNullable(clazz.cast(sourceAccount()));
        case "EventSourceToken":
            return Optional.ofNullable(clazz.cast(eventSourceToken()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddPermissionRequest, T> g) {
        return obj -> g.apply((AddPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddPermissionRequest> {
        /**
         * <p>
         * The name of the Lambda function, version, or alias.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can append a version number or alias to any of the formats. The length constraint applies only to the
         * full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function, version, or alias.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can append a version number or alias to any of the formats. The length constraint applies only to
         *        the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * A statement identifier that differentiates the statement from others in the same policy.
         * </p>
         * 
         * @param statementId
         *        A statement identifier that differentiates the statement from others in the same policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code> or
         * <code>lambda:GetFunction</code>.
         * </p>
         * 
         * @param action
         *        The action that the principal can use on the function. For example, <code>lambda:InvokeFunction</code>
         *        or <code>lambda:GetFunction</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The Amazon Web Services service or account that invokes the function. If you specify a service, use
         * <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that
         * service.
         * </p>
         * 
         * @param principal
         *        The Amazon Web Services service or account that invokes the function. If you specify a service, use
         *        <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the function. For
         * example, an Amazon S3 bucket or Amazon SNS topic.
         * </p>
         * <p>
         * Note that Lambda configures the comparison using the <code>StringLike</code> operator.
         * </p>
         * 
         * @param sourceArn
         *        For Amazon Web Services services, the ARN of the Amazon Web Services resource that invokes the
         *        function. For example, an Amazon S3 bucket or Amazon SNS topic.</p>
         *        <p>
         *        Note that Lambda configures the comparison using the <code>StringLike</code> operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * For Amazon S3, the ID of the account that owns the resource. Use this together with <code>SourceArn</code> to
         * ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be
         * deleted by its owner and recreated by another account.
         * </p>
         * 
         * @param sourceAccount
         *        For Amazon S3, the ID of the account that owns the resource. Use this together with
         *        <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible
         *        for an Amazon S3 bucket to be deleted by its owner and recreated by another account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccount(String sourceAccount);

        /**
         * <p>
         * For Alexa Smart Home functions, a token that must be supplied by the invoker.
         * </p>
         * 
         * @param eventSourceToken
         *        For Alexa Smart Home functions, a token that must be supplied by the invoker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceToken(String eventSourceToken);

        /**
         * <p>
         * Specify a version or alias to add permissions to a published version of the function.
         * </p>
         * 
         * @param qualifier
         *        Specify a version or alias to add permissions to a published version of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid modifying
         * a policy that has changed since you last read it.
         * </p>
         * 
         * @param revisionId
         *        Only update the policy if the revision ID matches the ID that's specified. Use this option to avoid
         *        modifying a policy that has changed since you last read it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String statementId;

        private String action;

        private String principal;

        private String sourceArn;

        private String sourceAccount;

        private String eventSourceToken;

        private String qualifier;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            super(model);
            functionName(model.functionName);
            statementId(model.statementId);
            action(model.action);
            principal(model.principal);
            sourceArn(model.sourceArn);
            sourceAccount(model.sourceAccount);
            eventSourceToken(model.eventSourceToken);
            qualifier(model.qualifier);
            revisionId(model.revisionId);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        @Transient
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getStatementId() {
            return statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        @Transient
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        @Transient
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        @Transient
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSourceAccount() {
            return sourceAccount;
        }

        public final void setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @Override
        @Transient
        public final Builder sourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public final String getEventSourceToken() {
            return eventSourceToken;
        }

        public final void setEventSourceToken(String eventSourceToken) {
            this.eventSourceToken = eventSourceToken;
        }

        @Override
        @Transient
        public final Builder eventSourceToken(String eventSourceToken) {
            this.eventSourceToken = eventSourceToken;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        @Transient
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        @Transient
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
