/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ARN of the runtime and any errors that occured.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimeVersionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RuntimeVersionConfig.Builder, RuntimeVersionConfig> {
    private static final SdkField<String> RUNTIME_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeVersionArn").getter(getter(RuntimeVersionConfig::runtimeVersionArn))
            .setter(setter(Builder::runtimeVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersionArn").build()).build();

    private static final SdkField<RuntimeVersionError> ERROR_FIELD = SdkField
            .<RuntimeVersionError> builder(MarshallingType.SDK_POJO).memberName("Error")
            .getter(getter(RuntimeVersionConfig::error)).setter(setter(Builder::error)).constructor(RuntimeVersionError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_VERSION_ARN_FIELD,
            ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String runtimeVersionArn;

    private final RuntimeVersionError error;

    private RuntimeVersionConfig(BuilderImpl builder) {
        this.runtimeVersionArn = builder.runtimeVersionArn;
        this.error = builder.error;
    }

    /**
     * <p>
     * The ARN of the runtime version you want the function to use.
     * </p>
     * 
     * @return The ARN of the runtime version you want the function to use.
     */
    public final String runtimeVersionArn() {
        return runtimeVersionArn;
    }

    /**
     * <p>
     * Error response when Lambda is unable to retrieve the runtime version for a function.
     * </p>
     * 
     * @return Error response when Lambda is unable to retrieve the runtime version for a function.
     */
    public final RuntimeVersionError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runtimeVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeVersionConfig)) {
            return false;
        }
        RuntimeVersionConfig other = (RuntimeVersionConfig) obj;
        return Objects.equals(runtimeVersionArn(), other.runtimeVersionArn()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimeVersionConfig").add("RuntimeVersionArn", runtimeVersionArn()).add("Error", error())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuntimeVersionArn":
            return Optional.ofNullable(clazz.cast(runtimeVersionArn()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeVersionConfig, T> g) {
        return obj -> g.apply((RuntimeVersionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimeVersionConfig> {
        /**
         * <p>
         * The ARN of the runtime version you want the function to use.
         * </p>
         * 
         * @param runtimeVersionArn
         *        The ARN of the runtime version you want the function to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersionArn(String runtimeVersionArn);

        /**
         * <p>
         * Error response when Lambda is unable to retrieve the runtime version for a function.
         * </p>
         * 
         * @param error
         *        Error response when Lambda is unable to retrieve the runtime version for a function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(RuntimeVersionError error);

        /**
         * <p>
         * Error response when Lambda is unable to retrieve the runtime version for a function.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuntimeVersionError.Builder} avoiding the
         * need to create one manually via {@link RuntimeVersionError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuntimeVersionError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(RuntimeVersionError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link RuntimeVersionError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(RuntimeVersionError)
         */
        default Builder error(Consumer<RuntimeVersionError.Builder> error) {
            return error(RuntimeVersionError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String runtimeVersionArn;

        private RuntimeVersionError error;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeVersionConfig model) {
            runtimeVersionArn(model.runtimeVersionArn);
            error(model.error);
        }

        public final String getRuntimeVersionArn() {
            return runtimeVersionArn;
        }

        public final void setRuntimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
        }

        @Override
        public final Builder runtimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
            return this;
        }

        public final RuntimeVersionError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(RuntimeVersionError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(RuntimeVersionError error) {
            this.error = error;
            return this;
        }

        @Override
        public RuntimeVersionConfig build() {
            return new RuntimeVersionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
