/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLayerVersionResponse extends LambdaResponse implements
        ToCopyableBuilder<GetLayerVersionResponse.Builder, GetLayerVersionResponse> {
    private static final SdkField<LayerVersionContentOutput> CONTENT_FIELD = SdkField
            .<LayerVersionContentOutput> builder(MarshallingType.SDK_POJO).memberName("Content")
            .getter(getter(GetLayerVersionResponse::content)).setter(setter(Builder::content))
            .constructor(LayerVersionContentOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> LAYER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerArn").getter(getter(GetLayerVersionResponse::layerArn)).setter(setter(Builder::layerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerArn").build()).build();

    private static final SdkField<String> LAYER_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerVersionArn").getter(getter(GetLayerVersionResponse::layerVersionArn))
            .setter(setter(Builder::layerVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerVersionArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetLayerVersionResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(GetLayerVersionResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(GetLayerVersionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<List<String>> COMPATIBLE_RUNTIMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CompatibleRuntimes")
            .getter(getter(GetLayerVersionResponse::compatibleRuntimesAsStrings))
            .setter(setter(Builder::compatibleRuntimesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleRuntimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LICENSE_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseInfo").getter(getter(GetLayerVersionResponse::licenseInfo)).setter(setter(Builder::licenseInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseInfo").build()).build();

    private static final SdkField<List<String>> COMPATIBLE_ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CompatibleArchitectures")
            .getter(getter(GetLayerVersionResponse::compatibleArchitecturesAsStrings))
            .setter(setter(Builder::compatibleArchitecturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleArchitectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            LAYER_ARN_FIELD, LAYER_VERSION_ARN_FIELD, DESCRIPTION_FIELD, CREATED_DATE_FIELD, VERSION_FIELD,
            COMPATIBLE_RUNTIMES_FIELD, LICENSE_INFO_FIELD, COMPATIBLE_ARCHITECTURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Content", CONTENT_FIELD);
                    put("LayerArn", LAYER_ARN_FIELD);
                    put("LayerVersionArn", LAYER_VERSION_ARN_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("CreatedDate", CREATED_DATE_FIELD);
                    put("Version", VERSION_FIELD);
                    put("CompatibleRuntimes", COMPATIBLE_RUNTIMES_FIELD);
                    put("LicenseInfo", LICENSE_INFO_FIELD);
                    put("CompatibleArchitectures", COMPATIBLE_ARCHITECTURES_FIELD);
                }
            });

    private final LayerVersionContentOutput content;

    private final String layerArn;

    private final String layerVersionArn;

    private final String description;

    private final String createdDate;

    private final Long version;

    private final List<String> compatibleRuntimes;

    private final String licenseInfo;

    private final List<String> compatibleArchitectures;

    private GetLayerVersionResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.layerArn = builder.layerArn;
        this.layerVersionArn = builder.layerVersionArn;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.compatibleRuntimes = builder.compatibleRuntimes;
        this.licenseInfo = builder.licenseInfo;
        this.compatibleArchitectures = builder.compatibleArchitectures;
    }

    /**
     * <p>
     * Details about the layer version.
     * </p>
     * 
     * @return Details about the layer version.
     */
    public final LayerVersionContentOutput content() {
        return content;
    }

    /**
     * <p>
     * The ARN of the layer.
     * </p>
     * 
     * @return The ARN of the layer.
     */
    public final String layerArn() {
        return layerArn;
    }

    /**
     * <p>
     * The ARN of the layer version.
     * </p>
     * 
     * @return The ARN of the layer version.
     */
    public final String layerVersionArn() {
        return layerVersionArn;
    }

    /**
     * <p>
     * The description of the version.
     * </p>
     * 
     * @return The description of the version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a>
     * (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     *         format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final String createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The layer's compatible runtimes.
     * </p>
     * <p>
     * The following list includes deprecated runtimes. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime use
     * after deprecation</a>.
     * </p>
     * <p>
     * For a list of all currently supported runtimes, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
     * runtimes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleRuntimes} method.
     * </p>
     * 
     * @return The layer's compatible runtimes.</p>
     *         <p>
     *         The following list includes deprecated runtimes. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
     *         >Runtime use after deprecation</a>.
     *         </p>
     *         <p>
     *         For a list of all currently supported runtimes, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
     *         runtimes</a>.
     */
    public final List<Runtime> compatibleRuntimes() {
        return CompatibleRuntimesCopier.copyStringToEnum(compatibleRuntimes);
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleRuntimes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompatibleRuntimes() {
        return compatibleRuntimes != null && !(compatibleRuntimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The layer's compatible runtimes.
     * </p>
     * <p>
     * The following list includes deprecated runtimes. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime use
     * after deprecation</a>.
     * </p>
     * <p>
     * For a list of all currently supported runtimes, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
     * runtimes</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleRuntimes} method.
     * </p>
     * 
     * @return The layer's compatible runtimes.</p>
     *         <p>
     *         The following list includes deprecated runtimes. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
     *         >Runtime use after deprecation</a>.
     *         </p>
     *         <p>
     *         For a list of all currently supported runtimes, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
     *         runtimes</a>.
     */
    public final List<String> compatibleRuntimesAsStrings() {
        return compatibleRuntimes;
    }

    /**
     * <p>
     * The layer's software license.
     * </p>
     * 
     * @return The layer's software license.
     */
    public final String licenseInfo() {
        return licenseInfo;
    }

    /**
     * <p>
     * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     * architectures</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleArchitectures} method.
     * </p>
     * 
     * @return A list of compatible <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     *         architectures</a>.
     */
    public final List<Architecture> compatibleArchitectures() {
        return CompatibleArchitecturesCopier.copyStringToEnum(compatibleArchitectures);
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleArchitectures property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCompatibleArchitectures() {
        return compatibleArchitectures != null && !(compatibleArchitectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     * architectures</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleArchitectures} method.
     * </p>
     * 
     * @return A list of compatible <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     *         architectures</a>.
     */
    public final List<String> compatibleArchitecturesAsStrings() {
        return compatibleArchitectures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(layerArn());
        hashCode = 31 * hashCode + Objects.hashCode(layerVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompatibleRuntimes() ? compatibleRuntimesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(licenseInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompatibleArchitectures() ? compatibleArchitecturesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLayerVersionResponse)) {
            return false;
        }
        GetLayerVersionResponse other = (GetLayerVersionResponse) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(layerArn(), other.layerArn())
                && Objects.equals(layerVersionArn(), other.layerVersionArn())
                && Objects.equals(description(), other.description()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(version(), other.version()) && hasCompatibleRuntimes() == other.hasCompatibleRuntimes()
                && Objects.equals(compatibleRuntimesAsStrings(), other.compatibleRuntimesAsStrings())
                && Objects.equals(licenseInfo(), other.licenseInfo())
                && hasCompatibleArchitectures() == other.hasCompatibleArchitectures()
                && Objects.equals(compatibleArchitecturesAsStrings(), other.compatibleArchitecturesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLayerVersionResponse").add("Content", content()).add("LayerArn", layerArn())
                .add("LayerVersionArn", layerVersionArn()).add("Description", description()).add("CreatedDate", createdDate())
                .add("Version", version())
                .add("CompatibleRuntimes", hasCompatibleRuntimes() ? compatibleRuntimesAsStrings() : null)
                .add("LicenseInfo", licenseInfo())
                .add("CompatibleArchitectures", hasCompatibleArchitectures() ? compatibleArchitecturesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "LayerArn":
            return Optional.ofNullable(clazz.cast(layerArn()));
        case "LayerVersionArn":
            return Optional.ofNullable(clazz.cast(layerVersionArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "CompatibleRuntimes":
            return Optional.ofNullable(clazz.cast(compatibleRuntimesAsStrings()));
        case "LicenseInfo":
            return Optional.ofNullable(clazz.cast(licenseInfo()));
        case "CompatibleArchitectures":
            return Optional.ofNullable(clazz.cast(compatibleArchitecturesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLayerVersionResponse, T> g) {
        return obj -> g.apply((GetLayerVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLayerVersionResponse> {
        /**
         * <p>
         * Details about the layer version.
         * </p>
         * 
         * @param content
         *        Details about the layer version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(LayerVersionContentOutput content);

        /**
         * <p>
         * Details about the layer version.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayerVersionContentOutput.Builder}
         * avoiding the need to create one manually via {@link LayerVersionContentOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayerVersionContentOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #content(LayerVersionContentOutput)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link LayerVersionContentOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(LayerVersionContentOutput)
         */
        default Builder content(Consumer<LayerVersionContentOutput.Builder> content) {
            return content(LayerVersionContentOutput.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The ARN of the layer.
         * </p>
         * 
         * @param layerArn
         *        The ARN of the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerArn(String layerArn);

        /**
         * <p>
         * The ARN of the layer version.
         * </p>
         * 
         * @param layerVersionArn
         *        The ARN of the layer version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerVersionArn(String layerVersionArn);

        /**
         * <p>
         * The description of the version.
         * </p>
         * 
         * @param description
         *        The description of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param createdDate
         *        The date that the layer version was created, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         *        format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);

        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param version
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The layer's compatible runtimes.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime
         * use after deprecation</a>.
         * </p>
         * <p>
         * For a list of all currently supported runtimes, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         * runtimes</a>.
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
         *        >Runtime use after deprecation</a>.
         *        </p>
         *        <p>
         *        For a list of all currently supported runtimes, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         *        runtimes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimesWithStrings(Collection<String> compatibleRuntimes);

        /**
         * <p>
         * The layer's compatible runtimes.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime
         * use after deprecation</a>.
         * </p>
         * <p>
         * For a list of all currently supported runtimes, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         * runtimes</a>.
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
         *        >Runtime use after deprecation</a>.
         *        </p>
         *        <p>
         *        For a list of all currently supported runtimes, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         *        runtimes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimesWithStrings(String... compatibleRuntimes);

        /**
         * <p>
         * The layer's compatible runtimes.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime
         * use after deprecation</a>.
         * </p>
         * <p>
         * For a list of all currently supported runtimes, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         * runtimes</a>.
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
         *        >Runtime use after deprecation</a>.
         *        </p>
         *        <p>
         *        For a list of all currently supported runtimes, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         *        runtimes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(Collection<Runtime> compatibleRuntimes);

        /**
         * <p>
         * The layer's compatible runtimes.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels">Runtime
         * use after deprecation</a>.
         * </p>
         * <p>
         * For a list of all currently supported runtimes, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         * runtimes</a>.
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels"
         *        >Runtime use after deprecation</a>.
         *        </p>
         *        <p>
         *        For a list of all currently supported runtimes, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported">Supported
         *        runtimes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(Runtime... compatibleRuntimes);

        /**
         * <p>
         * The layer's software license.
         * </p>
         * 
         * @param licenseInfo
         *        The layer's software license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseInfo(String licenseInfo);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         * set architectures</a>.
         * </p>
         * 
         * @param compatibleArchitectures
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         *        architectures</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleArchitecturesWithStrings(Collection<String> compatibleArchitectures);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         * set architectures</a>.
         * </p>
         * 
         * @param compatibleArchitectures
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         *        architectures</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleArchitecturesWithStrings(String... compatibleArchitectures);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         * set architectures</a>.
         * </p>
         * 
         * @param compatibleArchitectures
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         *        architectures</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleArchitectures(Collection<Architecture> compatibleArchitectures);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         * set architectures</a>.
         * </p>
         * 
         * @param compatibleArchitectures
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         *        architectures</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleArchitectures(Architecture... compatibleArchitectures);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private LayerVersionContentOutput content;

        private String layerArn;

        private String layerVersionArn;

        private String description;

        private String createdDate;

        private Long version;

        private List<String> compatibleRuntimes = DefaultSdkAutoConstructList.getInstance();

        private String licenseInfo;

        private List<String> compatibleArchitectures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLayerVersionResponse model) {
            super(model);
            content(model.content);
            layerArn(model.layerArn);
            layerVersionArn(model.layerVersionArn);
            description(model.description);
            createdDate(model.createdDate);
            version(model.version);
            compatibleRuntimesWithStrings(model.compatibleRuntimes);
            licenseInfo(model.licenseInfo);
            compatibleArchitecturesWithStrings(model.compatibleArchitectures);
        }

        public final LayerVersionContentOutput.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(LayerVersionContentOutput.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(LayerVersionContentOutput content) {
            this.content = content;
            return this;
        }

        public final String getLayerArn() {
            return layerArn;
        }

        public final void setLayerArn(String layerArn) {
            this.layerArn = layerArn;
        }

        @Override
        public final Builder layerArn(String layerArn) {
            this.layerArn = layerArn;
            return this;
        }

        public final String getLayerVersionArn() {
            return layerVersionArn;
        }

        public final void setLayerVersionArn(String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
        }

        @Override
        public final Builder layerVersionArn(String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getCompatibleRuntimes() {
            if (compatibleRuntimes instanceof SdkAutoConstructList) {
                return null;
            }
            return compatibleRuntimes;
        }

        public final void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
        }

        @Override
        public final Builder compatibleRuntimesWithStrings(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimesWithStrings(String... compatibleRuntimes) {
            compatibleRuntimesWithStrings(Arrays.asList(compatibleRuntimes));
            return this;
        }

        @Override
        public final Builder compatibleRuntimes(Collection<Runtime> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copyEnumToString(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimes(Runtime... compatibleRuntimes) {
            compatibleRuntimes(Arrays.asList(compatibleRuntimes));
            return this;
        }

        public final String getLicenseInfo() {
            return licenseInfo;
        }

        public final void setLicenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
        }

        @Override
        public final Builder licenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
            return this;
        }

        public final Collection<String> getCompatibleArchitectures() {
            if (compatibleArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return compatibleArchitectures;
        }

        public final void setCompatibleArchitectures(Collection<String> compatibleArchitectures) {
            this.compatibleArchitectures = CompatibleArchitecturesCopier.copy(compatibleArchitectures);
        }

        @Override
        public final Builder compatibleArchitecturesWithStrings(Collection<String> compatibleArchitectures) {
            this.compatibleArchitectures = CompatibleArchitecturesCopier.copy(compatibleArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleArchitecturesWithStrings(String... compatibleArchitectures) {
            compatibleArchitecturesWithStrings(Arrays.asList(compatibleArchitectures));
            return this;
        }

        @Override
        public final Builder compatibleArchitectures(Collection<Architecture> compatibleArchitectures) {
            this.compatibleArchitectures = CompatibleArchitecturesCopier.copyEnumToString(compatibleArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleArchitectures(Architecture... compatibleArchitectures) {
            compatibleArchitectures(Arrays.asList(compatibleArchitectures));
            return this;
        }

        @Override
        public GetLayerVersionResponse build() {
            return new GetLayerVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
