/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishLayerVersionRequest extends LambdaRequest implements
        ToCopyableBuilder<PublishLayerVersionRequest.Builder, PublishLayerVersionRequest> {
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerName").getter(getter(PublishLayerVersionRequest::layerName)).setter(setter(Builder::layerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayerName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PublishLayerVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<LayerVersionContentInput> CONTENT_FIELD = SdkField
            .<LayerVersionContentInput> builder(MarshallingType.SDK_POJO).memberName("Content")
            .getter(getter(PublishLayerVersionRequest::content)).setter(setter(Builder::content))
            .constructor(LayerVersionContentInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<List<String>> COMPATIBLE_RUNTIMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CompatibleRuntimes")
            .getter(getter(PublishLayerVersionRequest::compatibleRuntimesAsStrings))
            .setter(setter(Builder::compatibleRuntimesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleRuntimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LICENSE_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseInfo").getter(getter(PublishLayerVersionRequest::licenseInfo))
            .setter(setter(Builder::licenseInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseInfo").build()).build();

    private static final SdkField<List<String>> COMPATIBLE_ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CompatibleArchitectures")
            .getter(getter(PublishLayerVersionRequest::compatibleArchitecturesAsStrings))
            .setter(setter(Builder::compatibleArchitecturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleArchitectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_NAME_FIELD,
            DESCRIPTION_FIELD, CONTENT_FIELD, COMPATIBLE_RUNTIMES_FIELD, LICENSE_INFO_FIELD, COMPATIBLE_ARCHITECTURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LayerName", LAYER_NAME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("Content", CONTENT_FIELD);
                    put("CompatibleRuntimes", COMPATIBLE_RUNTIMES_FIELD);
                    put("LicenseInfo", LICENSE_INFO_FIELD);
                    put("CompatibleArchitectures", COMPATIBLE_ARCHITECTURES_FIELD);
                }
            });

    private final String layerName;

    private final String description;

    private final LayerVersionContentInput content;

    private final List<String> compatibleRuntimes;

    private final String licenseInfo;

    private final List<String> compatibleArchitectures;

    private PublishLayerVersionRequest(BuilderImpl builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.description = builder.description;
        this.content = builder.content;
        this.compatibleRuntimes = builder.compatibleRuntimes;
        this.licenseInfo = builder.licenseInfo;
        this.compatibleArchitectures = builder.compatibleArchitectures;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the layer.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the layer.
     */
    public final String layerName() {
        return layerName;
    }

    /**
     * <p>
     * The description of the version.
     * </p>
     * 
     * @return The description of the version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The function layer archive.
     * </p>
     * 
     * @return The function layer archive.
     */
    public final LayerVersionContentInput content() {
        return content;
    }

    /**
     * <p>
     * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
     * runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.
     * </p>
     * <p>
     * The following list includes deprecated runtimes. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
     * deprecation policy</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleRuntimes} method.
     * </p>
     * 
     * @return A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
     *         runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.</p>
     *         <p>
     *         The following list includes deprecated runtimes. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
     *         deprecation policy</a>.
     */
    public final List<Runtime> compatibleRuntimes() {
        return CompatibleRuntimesCopier.copyStringToEnum(compatibleRuntimes);
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleRuntimes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompatibleRuntimes() {
        return compatibleRuntimes != null && !(compatibleRuntimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
     * runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.
     * </p>
     * <p>
     * The following list includes deprecated runtimes. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
     * deprecation policy</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleRuntimes} method.
     * </p>
     * 
     * @return A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
     *         runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.</p>
     *         <p>
     *         The following list includes deprecated runtimes. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
     *         deprecation policy</a>.
     */
    public final List<String> compatibleRuntimesAsStrings() {
        return compatibleRuntimes;
    }

    /**
     * <p>
     * The layer's software license. It can be any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The full text of the license.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The layer's software license. It can be any of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The URL of a license hosted on the internet. For example,
     *         <code>https://opensource.org/licenses/MIT</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The full text of the license.
     *         </p>
     *         </li>
     */
    public final String licenseInfo() {
        return licenseInfo;
    }

    /**
     * <p>
     * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     * architectures</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleArchitectures} method.
     * </p>
     * 
     * @return A list of compatible <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     *         architectures</a>.
     */
    public final List<Architecture> compatibleArchitectures() {
        return CompatibleArchitecturesCopier.copyStringToEnum(compatibleArchitectures);
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleArchitectures property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCompatibleArchitectures() {
        return compatibleArchitectures != null && !(compatibleArchitectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     * architectures</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleArchitectures} method.
     * </p>
     * 
     * @return A list of compatible <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
     *         architectures</a>.
     */
    public final List<String> compatibleArchitecturesAsStrings() {
        return compatibleArchitectures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(layerName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompatibleRuntimes() ? compatibleRuntimesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(licenseInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompatibleArchitectures() ? compatibleArchitecturesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishLayerVersionRequest)) {
            return false;
        }
        PublishLayerVersionRequest other = (PublishLayerVersionRequest) obj;
        return Objects.equals(layerName(), other.layerName()) && Objects.equals(description(), other.description())
                && Objects.equals(content(), other.content()) && hasCompatibleRuntimes() == other.hasCompatibleRuntimes()
                && Objects.equals(compatibleRuntimesAsStrings(), other.compatibleRuntimesAsStrings())
                && Objects.equals(licenseInfo(), other.licenseInfo())
                && hasCompatibleArchitectures() == other.hasCompatibleArchitectures()
                && Objects.equals(compatibleArchitecturesAsStrings(), other.compatibleArchitecturesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishLayerVersionRequest").add("LayerName", layerName()).add("Description", description())
                .add("Content", content())
                .add("CompatibleRuntimes", hasCompatibleRuntimes() ? compatibleRuntimesAsStrings() : null)
                .add("LicenseInfo", licenseInfo())
                .add("CompatibleArchitectures", hasCompatibleArchitectures() ? compatibleArchitecturesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerName":
            return Optional.ofNullable(clazz.cast(layerName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "CompatibleRuntimes":
            return Optional.ofNullable(clazz.cast(compatibleRuntimesAsStrings()));
        case "LicenseInfo":
            return Optional.ofNullable(clazz.cast(licenseInfo()));
        case "CompatibleArchitectures":
            return Optional.ofNullable(clazz.cast(compatibleArchitecturesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PublishLayerVersionRequest, T> g) {
        return obj -> g.apply((PublishLayerVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, PublishLayerVersionRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the layer.
         * </p>
         * 
         * @param layerName
         *        The name or Amazon Resource Name (ARN) of the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerName(String layerName);

        /**
         * <p>
         * The description of the version.
         * </p>
         * 
         * @param description
         *        The description of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The function layer archive.
         * </p>
         * 
         * @param content
         *        The function layer archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(LayerVersionContentInput content);

        /**
         * <p>
         * The function layer archive.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayerVersionContentInput.Builder}
         * avoiding the need to create one manually via {@link LayerVersionContentInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayerVersionContentInput.Builder#build()} is called immediately
         * and its result is passed to {@link #content(LayerVersionContentInput)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link LayerVersionContentInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(LayerVersionContentInput)
         */
        default Builder content(Consumer<LayerVersionContentInput.Builder> content) {
            return content(LayerVersionContentInput.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
         * runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
         * deprecation policy</a>.
         * </p>
         * 
         * @param compatibleRuntimes
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used
         *        for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy"
         *        >Runtime deprecation policy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimesWithStrings(Collection<String> compatibleRuntimes);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
         * runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
         * deprecation policy</a>.
         * </p>
         * 
         * @param compatibleRuntimes
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used
         *        for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy"
         *        >Runtime deprecation policy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimesWithStrings(String... compatibleRuntimes);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
         * runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
         * deprecation policy</a>.
         * </p>
         * 
         * @param compatibleRuntimes
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used
         *        for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy"
         *        >Runtime deprecation policy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(Collection<Runtime> compatibleRuntimes);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function
         * runtimes</a>. Used for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.
         * </p>
         * <p>
         * The following list includes deprecated runtimes. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy">Runtime
         * deprecation policy</a>.
         * </p>
         * 
         * @param compatibleRuntimes
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">function runtimes</a>. Used
         *        for filtering with <a>ListLayers</a> and <a>ListLayerVersions</a>.</p>
         *        <p>
         *        The following list includes deprecated runtimes. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-support-policy"
         *        >Runtime deprecation policy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(Runtime... compatibleRuntimes);

        /**
         * <p>
         * The layer's software license. It can be any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The full text of the license.
         * </p>
         * </li>
         * </ul>
         * 
         * @param licenseInfo
         *        The layer's software license. It can be any of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        An <a href="https://spdx.org/licenses/">SPDX license identifier</a>. For example, <code>MIT</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The URL of a license hosted on the internet. For example,
         *        <code>https://opensource.org/licenses/MIT</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The full text of the license.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseInfo(String licenseInfo);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         * set architectures</a>.
         * </p>
         * 
         * @param compatibleArchitectures
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         *        architectures</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleArchitecturesWithStrings(Collection<String> compatibleArchitectures);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         * set architectures</a>.
         * </p>
         * 
         * @param compatibleArchitectures
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         *        architectures</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleArchitecturesWithStrings(String... compatibleArchitectures);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         * set architectures</a>.
         * </p>
         * 
         * @param compatibleArchitectures
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         *        architectures</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleArchitectures(Collection<Architecture> compatibleArchitectures);

        /**
         * <p>
         * A list of compatible <a href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction
         * set architectures</a>.
         * </p>
         * 
         * @param compatibleArchitectures
         *        A list of compatible <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set
         *        architectures</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleArchitectures(Architecture... compatibleArchitectures);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String layerName;

        private String description;

        private LayerVersionContentInput content;

        private List<String> compatibleRuntimes = DefaultSdkAutoConstructList.getInstance();

        private String licenseInfo;

        private List<String> compatibleArchitectures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublishLayerVersionRequest model) {
            super(model);
            layerName(model.layerName);
            description(model.description);
            content(model.content);
            compatibleRuntimesWithStrings(model.compatibleRuntimes);
            licenseInfo(model.licenseInfo);
            compatibleArchitecturesWithStrings(model.compatibleArchitectures);
        }

        public final String getLayerName() {
            return layerName;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final LayerVersionContentInput.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(LayerVersionContentInput.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(LayerVersionContentInput content) {
            this.content = content;
            return this;
        }

        public final Collection<String> getCompatibleRuntimes() {
            if (compatibleRuntimes instanceof SdkAutoConstructList) {
                return null;
            }
            return compatibleRuntimes;
        }

        public final void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
        }

        @Override
        public final Builder compatibleRuntimesWithStrings(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimesWithStrings(String... compatibleRuntimes) {
            compatibleRuntimesWithStrings(Arrays.asList(compatibleRuntimes));
            return this;
        }

        @Override
        public final Builder compatibleRuntimes(Collection<Runtime> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copyEnumToString(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimes(Runtime... compatibleRuntimes) {
            compatibleRuntimes(Arrays.asList(compatibleRuntimes));
            return this;
        }

        public final String getLicenseInfo() {
            return licenseInfo;
        }

        public final void setLicenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
        }

        @Override
        public final Builder licenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
            return this;
        }

        public final Collection<String> getCompatibleArchitectures() {
            if (compatibleArchitectures instanceof SdkAutoConstructList) {
                return null;
            }
            return compatibleArchitectures;
        }

        public final void setCompatibleArchitectures(Collection<String> compatibleArchitectures) {
            this.compatibleArchitectures = CompatibleArchitecturesCopier.copy(compatibleArchitectures);
        }

        @Override
        public final Builder compatibleArchitecturesWithStrings(Collection<String> compatibleArchitectures) {
            this.compatibleArchitectures = CompatibleArchitecturesCopier.copy(compatibleArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleArchitecturesWithStrings(String... compatibleArchitectures) {
            compatibleArchitecturesWithStrings(Arrays.asList(compatibleArchitectures));
            return this;
        }

        @Override
        public final Builder compatibleArchitectures(Collection<Architecture> compatibleArchitectures) {
            this.compatibleArchitectures = CompatibleArchitecturesCopier.copyEnumToString(compatibleArchitectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleArchitectures(Architecture... compatibleArchitectures) {
            compatibleArchitectures(Arrays.asList(compatibleArchitectures));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishLayerVersionRequest build() {
            return new PublishLayerVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
