/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFunctionRecursionConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<PutFunctionRecursionConfigResponse.Builder, PutFunctionRecursionConfigResponse> {
    private static final SdkField<String> RECURSIVE_LOOP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecursiveLoop").getter(getter(PutFunctionRecursionConfigResponse::recursiveLoopAsString))
            .setter(setter(Builder::recursiveLoop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecursiveLoop").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECURSIVE_LOOP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("RecursiveLoop", RECURSIVE_LOOP_FIELD);
                }
            });

    private final String recursiveLoop;

    private PutFunctionRecursionConfigResponse(BuilderImpl builder) {
        super(builder);
        this.recursiveLoop = builder.recursiveLoop;
    }

    /**
     * <p>
     * The status of your function's recursive loop detection configuration.
     * </p>
     * <p>
     * When this value is set to <code>Allow</code>and Lambda detects your function being invoked as part of a recursive
     * loop, it doesn't take any action.
     * </p>
     * <p>
     * When this value is set to <code>Terminate</code> and Lambda detects your function being invoked as part of a
     * recursive loop, it stops your function being invoked and notifies you.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recursiveLoop}
     * will return {@link RecursiveLoop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recursiveLoopAsString}.
     * </p>
     * 
     * @return The status of your function's recursive loop detection configuration.</p>
     *         <p>
     *         When this value is set to <code>Allow</code>and Lambda detects your function being invoked as part of a
     *         recursive loop, it doesn't take any action.
     *         </p>
     *         <p>
     *         When this value is set to <code>Terminate</code> and Lambda detects your function being invoked as part
     *         of a recursive loop, it stops your function being invoked and notifies you.
     * @see RecursiveLoop
     */
    public final RecursiveLoop recursiveLoop() {
        return RecursiveLoop.fromValue(recursiveLoop);
    }

    /**
     * <p>
     * The status of your function's recursive loop detection configuration.
     * </p>
     * <p>
     * When this value is set to <code>Allow</code>and Lambda detects your function being invoked as part of a recursive
     * loop, it doesn't take any action.
     * </p>
     * <p>
     * When this value is set to <code>Terminate</code> and Lambda detects your function being invoked as part of a
     * recursive loop, it stops your function being invoked and notifies you.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recursiveLoop}
     * will return {@link RecursiveLoop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recursiveLoopAsString}.
     * </p>
     * 
     * @return The status of your function's recursive loop detection configuration.</p>
     *         <p>
     *         When this value is set to <code>Allow</code>and Lambda detects your function being invoked as part of a
     *         recursive loop, it doesn't take any action.
     *         </p>
     *         <p>
     *         When this value is set to <code>Terminate</code> and Lambda detects your function being invoked as part
     *         of a recursive loop, it stops your function being invoked and notifies you.
     * @see RecursiveLoop
     */
    public final String recursiveLoopAsString() {
        return recursiveLoop;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recursiveLoopAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionRecursionConfigResponse)) {
            return false;
        }
        PutFunctionRecursionConfigResponse other = (PutFunctionRecursionConfigResponse) obj;
        return Objects.equals(recursiveLoopAsString(), other.recursiveLoopAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFunctionRecursionConfigResponse").add("RecursiveLoop", recursiveLoopAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecursiveLoop":
            return Optional.ofNullable(clazz.cast(recursiveLoopAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionRecursionConfigResponse, T> g) {
        return obj -> g.apply((PutFunctionRecursionConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutFunctionRecursionConfigResponse> {
        /**
         * <p>
         * The status of your function's recursive loop detection configuration.
         * </p>
         * <p>
         * When this value is set to <code>Allow</code>and Lambda detects your function being invoked as part of a
         * recursive loop, it doesn't take any action.
         * </p>
         * <p>
         * When this value is set to <code>Terminate</code> and Lambda detects your function being invoked as part of a
         * recursive loop, it stops your function being invoked and notifies you.
         * </p>
         * 
         * @param recursiveLoop
         *        The status of your function's recursive loop detection configuration.</p>
         *        <p>
         *        When this value is set to <code>Allow</code>and Lambda detects your function being invoked as part of
         *        a recursive loop, it doesn't take any action.
         *        </p>
         *        <p>
         *        When this value is set to <code>Terminate</code> and Lambda detects your function being invoked as
         *        part of a recursive loop, it stops your function being invoked and notifies you.
         * @see RecursiveLoop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecursiveLoop
         */
        Builder recursiveLoop(String recursiveLoop);

        /**
         * <p>
         * The status of your function's recursive loop detection configuration.
         * </p>
         * <p>
         * When this value is set to <code>Allow</code>and Lambda detects your function being invoked as part of a
         * recursive loop, it doesn't take any action.
         * </p>
         * <p>
         * When this value is set to <code>Terminate</code> and Lambda detects your function being invoked as part of a
         * recursive loop, it stops your function being invoked and notifies you.
         * </p>
         * 
         * @param recursiveLoop
         *        The status of your function's recursive loop detection configuration.</p>
         *        <p>
         *        When this value is set to <code>Allow</code>and Lambda detects your function being invoked as part of
         *        a recursive loop, it doesn't take any action.
         *        </p>
         *        <p>
         *        When this value is set to <code>Terminate</code> and Lambda detects your function being invoked as
         *        part of a recursive loop, it stops your function being invoked and notifies you.
         * @see RecursiveLoop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecursiveLoop
         */
        Builder recursiveLoop(RecursiveLoop recursiveLoop);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String recursiveLoop;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionRecursionConfigResponse model) {
            super(model);
            recursiveLoop(model.recursiveLoop);
        }

        public final String getRecursiveLoop() {
            return recursiveLoop;
        }

        public final void setRecursiveLoop(String recursiveLoop) {
            this.recursiveLoop = recursiveLoop;
        }

        @Override
        public final Builder recursiveLoop(String recursiveLoop) {
            this.recursiveLoop = recursiveLoop;
            return this;
        }

        @Override
        public final Builder recursiveLoop(RecursiveLoop recursiveLoop) {
            this.recursiveLoop(recursiveLoop == null ? null : recursiveLoop.toString());
            return this;
        }

        @Override
        public PutFunctionRecursionConfigResponse build() {
            return new PutFunctionRecursionConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
