/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeWithResponseStreamResponse extends LambdaResponse implements
        ToCopyableBuilder<InvokeWithResponseStreamResponse.Builder, InvokeWithResponseStreamResponse> {
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(InvokeWithResponseStreamResponse::statusCode))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()).build();

    private static final SdkField<String> EXECUTED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutedVersion").getter(getter(InvokeWithResponseStreamResponse::executedVersion))
            .setter(setter(Builder::executedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Executed-Version").build())
            .build();

    private static final SdkField<String> RESPONSE_STREAM_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResponseStreamContentType").getter(getter(InvokeWithResponseStreamResponse::responseStreamContentType))
            .setter(setter(Builder::responseStreamContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            EXECUTED_VERSION_FIELD, RESPONSE_STREAM_CONTENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StatusCode", STATUS_CODE_FIELD);
                    put("X-Amz-Executed-Version", EXECUTED_VERSION_FIELD);
                    put("Content-Type", RESPONSE_STREAM_CONTENT_TYPE_FIELD);
                }
            });

    private final Integer statusCode;

    private final String executedVersion;

    private final String responseStreamContentType;

    private InvokeWithResponseStreamResponse(BuilderImpl builder) {
        super(builder);
        this.statusCode = builder.statusCode;
        this.executedVersion = builder.executedVersion;
        this.responseStreamContentType = builder.responseStreamContentType;
    }

    /**
     * <p>
     * For a successful request, the HTTP status code is in the 200 range. For the <code>RequestResponse</code>
     * invocation type, this status code is 200. For the <code>DryRun</code> invocation type, this status code is 204.
     * </p>
     * 
     * @return For a successful request, the HTTP status code is in the 200 range. For the <code>RequestResponse</code>
     *         invocation type, this status code is 200. For the <code>DryRun</code> invocation type, this status code
     *         is 204.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * The version of the function that executed. When you invoke a function with an alias, this indicates which version
     * the alias resolved to.
     * </p>
     * 
     * @return The version of the function that executed. When you invoke a function with an alias, this indicates which
     *         version the alias resolved to.
     */
    public final String executedVersion() {
        return executedVersion;
    }

    /**
     * <p>
     * The type of data the stream is returning.
     * </p>
     * 
     * @return The type of data the stream is returning.
     */
    public final String responseStreamContentType() {
        return responseStreamContentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(executedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(responseStreamContentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeWithResponseStreamResponse)) {
            return false;
        }
        InvokeWithResponseStreamResponse other = (InvokeWithResponseStreamResponse) obj;
        return Objects.equals(statusCode(), other.statusCode()) && Objects.equals(executedVersion(), other.executedVersion())
                && Objects.equals(responseStreamContentType(), other.responseStreamContentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeWithResponseStreamResponse").add("StatusCode", statusCode())
                .add("ExecutedVersion", executedVersion()).add("ResponseStreamContentType", responseStreamContentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "ExecutedVersion":
            return Optional.ofNullable(clazz.cast(executedVersion()));
        case "ResponseStreamContentType":
            return Optional.ofNullable(clazz.cast(responseStreamContentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvokeWithResponseStreamResponse, T> g) {
        return obj -> g.apply((InvokeWithResponseStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, InvokeWithResponseStreamResponse> {
        /**
         * <p>
         * For a successful request, the HTTP status code is in the 200 range. For the <code>RequestResponse</code>
         * invocation type, this status code is 200. For the <code>DryRun</code> invocation type, this status code is
         * 204.
         * </p>
         * 
         * @param statusCode
         *        For a successful request, the HTTP status code is in the 200 range. For the
         *        <code>RequestResponse</code> invocation type, this status code is 200. For the <code>DryRun</code>
         *        invocation type, this status code is 204.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * The version of the function that executed. When you invoke a function with an alias, this indicates which
         * version the alias resolved to.
         * </p>
         * 
         * @param executedVersion
         *        The version of the function that executed. When you invoke a function with an alias, this indicates
         *        which version the alias resolved to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executedVersion(String executedVersion);

        /**
         * <p>
         * The type of data the stream is returning.
         * </p>
         * 
         * @param responseStreamContentType
         *        The type of data the stream is returning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseStreamContentType(String responseStreamContentType);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private Integer statusCode;

        private String executedVersion;

        private String responseStreamContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeWithResponseStreamResponse model) {
            super(model);
            statusCode(model.statusCode);
            executedVersion(model.executedVersion);
            responseStreamContentType(model.responseStreamContentType);
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getExecutedVersion() {
            return executedVersion;
        }

        public final void setExecutedVersion(String executedVersion) {
            this.executedVersion = executedVersion;
        }

        @Override
        public final Builder executedVersion(String executedVersion) {
            this.executedVersion = executedVersion;
            return this;
        }

        public final String getResponseStreamContentType() {
            return responseStreamContentType;
        }

        public final void setResponseStreamContentType(String responseStreamContentType) {
            this.responseStreamContentType = responseStreamContentType;
        }

        @Override
        public final Builder responseStreamContentType(String responseStreamContentType) {
            this.responseStreamContentType = responseStreamContentType;
            return this;
        }

        @Override
        public InvokeWithResponseStreamResponse build() {
            return new InvokeWithResponseStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
