/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.AddPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddPermissionResponse;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.GetPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigResponse;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamRequest;
import software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamResponseHandler;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayersRequest;
import software.amazon.awssdk.services.lambda.model.ListLayersResponse;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigResponse;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.RemovePermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemovePermissionResponse;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateAliasRequest;
import software.amazon.awssdk.services.lambda.model.UpdateAliasResponse;
import software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.paginators.ListAliasesPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListLayersPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionPublisher;
import software.amazon.awssdk.services.lambda.waiters.LambdaAsyncWaiter;

/**
 * Service client for accessing AWS Lambda asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * <fullname>Lambda</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * Lambda is a compute service that lets you run code without provisioning or managing servers. Lambda runs your code on
 * a high-availability compute infrastructure and performs all of the administration of the compute resources, including
 * server and operating system maintenance, capacity provisioning and automatic scaling, code monitoring and logging.
 * With Lambda, you can run code for virtually any type of application or backend service. For more information about
 * the Lambda service, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/welcome.html">What is Lambda</a> in the
 * <b>Lambda Developer Guide</b>.
 * </p>
 * <p>
 * The <i>Lambda API Reference</i> provides information about each of the API methods, including details about the
 * parameters in each API request and response.
 * </p>
 * <p/>
 * <p>
 * You can use Software Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line
 * tools to access the API. For installation instructions, see <a href="http://aws.amazon.com/tools/">Tools for Amazon
 * Web Services</a>.
 * </p>
 * <p>
 * For a list of Region-specific endpoints that Lambda supports, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/lambda-service.html">Lambda endpoints and quotas </a> in the
 * <i>Amazon Web Services General Reference.</i>.
 * </p>
 * <p>
 * When making the API calls, you will need to authenticate your request by providing a signature. Lambda supports
 * signature version 4. For more information, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 signing process</a>
 * in the <i>Amazon Web Services General Reference.</i>.
 * </p>
 * <p>
 * <b>CA certificates</b>
 * </p>
 * <p>
 * Because Amazon Web Services SDKs use the CA certificates from your computer, changes to the certificates on the
 * Amazon Web Services servers can cause connection failures when you attempt to use an SDK. You can prevent these
 * failures by keeping your computer's CA certificates and operating system up-to-date. If you encounter this issue in a
 * corporate environment and do not manage your own computer, you might need to ask an administrator to assist with the
 * update process. The following list shows minimum operating system and Java versions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Microsoft Windows versions that have updates from January 2005 or later installed contain at least one of the
 * required CAs in their trust list.
 * </p>
 * </li>
 * <li>
 * <p>
 * Mac OS X 10.4 with Java for Mac OS X 10.4 Release 5 (February 2007), Mac OS X 10.5 (October 2007), and later versions
 * contain at least one of the required CAs in their trust list.
 * </p>
 * </li>
 * <li>
 * <p>
 * Red Hat Enterprise Linux 5 (March 2007), 6, and 7 and CentOS 5, 6, and 7 all contain at least one of the required CAs
 * in their default trusted CA list.
 * </p>
 * </li>
 * <li>
 * <p>
 * Java 1.4.2_12 (May 2006), 5 Update 2 (March 2005), and all later versions, including Java 6 (December 2006), 7, and
 * 8, contain at least one of the required CAs in their default trusted CA list.
 * </p>
 * </li>
 * </ul>
 * <p>
 * When accessing the Lambda management console or Lambda API endpoints, whether through browsers or programmatically,
 * you will need to ensure your client machines support any of the following CAs:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Amazon Root CA 1
 * </p>
 * </li>
 * <li>
 * <p>
 * Starfield Services Root Certificate Authority - G2
 * </p>
 * </li>
 * <li>
 * <p>
 * Starfield Class 2 Certification Authority
 * </p>
 * </li>
 * </ul>
 * <p>
 * Root certificates from the first two authorities are available from <a
 * href="https://www.amazontrust.com/repository/">Amazon trust services</a>, but keeping your computer up-to-date is the
 * more straightforward solution. To learn more about ACM-provided certificates, see <a
 * href="http://aws.amazon.com/certificate-manager/faqs/#certificates">Amazon Web Services Certificate Manager FAQs.</a>
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface LambdaAsyncClient extends AwsClient {
    String SERVICE_NAME = "lambda";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "lambda";

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Use this action
     * to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in
     * an organization, or all Amazon Web Services accounts.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     * @return A Java Future containing the result of the AddLayerVersionPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>PolicyLengthExceededException The permissions policy for the resource is too large. For more
     *         information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddLayerVersionPermissionResponse> addLayerVersionPermission(
            AddLayerVersionPermissionRequest addLayerVersionPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Use this action
     * to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in
     * an organization, or all Amazon Web Services accounts.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddLayerVersionPermissionRequest.Builder} avoiding
     * the need to create one manually via {@link AddLayerVersionPermissionRequest#builder()}
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddLayerVersionPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>PolicyLengthExceededException The permissions policy for the resource is too large. For more
     *         information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddLayerVersionPermissionResponse> addLayerVersionPermission(
            Consumer<AddLayerVersionPermissionRequest.Builder> addLayerVersionPermissionRequest) {
        return addLayerVersionPermission(AddLayerVersionPermissionRequest.builder()
                .applyMutation(addLayerVersionPermissionRequest).build());
    }

    /**
     * <p>
     * Grants a <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"
     * >principal</a> permission to use a function. You can apply the policy at the function level, or specify a
     * qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full
     * Amazon Resource Name (ARN) of that version or alias to invoke the function. Note: Lambda does not support adding
     * policies to version &#36LATEST.
     * </p>
     * <p>
     * To grant permission to another account, specify the account ID as the <code>Principal</code>. To grant permission
     * to an organization defined in Organizations, specify the organization ID as the <code>PrincipalOrgID</code>. For
     * Amazon Web Services services, the principal is a domain-style identifier that the service defines, such as
     * <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code>. For Amazon Web Services services, you can also
     * specify the ARN of the associated resource as the <code>SourceArn</code>. If you grant permission to a service
     * principal without specifying the source, other accounts could potentially configure resources in their account to
     * invoke your Lambda function.
     * </p>
     * <p>
     * This operation adds a statement to a resource-based permissions policy for the function. For more information
     * about function policies, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Using resource-based
     * policies for Lambda</a>.
     * </p>
     *
     * @param addPermissionRequest
     * @return A Java Future containing the result of the AddPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>PolicyLengthExceededException The permissions policy for the resource is too large. For more
     *         information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPermissionResponse> addPermission(AddPermissionRequest addPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants a <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying"
     * >principal</a> permission to use a function. You can apply the policy at the function level, or specify a
     * qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full
     * Amazon Resource Name (ARN) of that version or alias to invoke the function. Note: Lambda does not support adding
     * policies to version &#36LATEST.
     * </p>
     * <p>
     * To grant permission to another account, specify the account ID as the <code>Principal</code>. To grant permission
     * to an organization defined in Organizations, specify the organization ID as the <code>PrincipalOrgID</code>. For
     * Amazon Web Services services, the principal is a domain-style identifier that the service defines, such as
     * <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code>. For Amazon Web Services services, you can also
     * specify the ARN of the associated resource as the <code>SourceArn</code>. If you grant permission to a service
     * principal without specifying the source, other accounts could potentially configure resources in their account to
     * invoke your Lambda function.
     * </p>
     * <p>
     * This operation adds a statement to a resource-based permissions policy for the function. For more information
     * about function policies, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Using resource-based
     * policies for Lambda</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link AddPermissionRequest#builder()}
     * </p>
     *
     * @param addPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.AddPermissionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>PolicyLengthExceededException The permissions policy for the resource is too large. For more
     *         information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPermissionResponse> addPermission(Consumer<AddPermissionRequest.Builder> addPermissionRequest) {
        return addPermission(AddPermissionRequest.builder().applyMutation(addPermissionRequest).build());
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a> for a
     * Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke
     * a different version.
     * </p>
     * <p>
     * You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code>
     * parameter to specify a second version and the percentage of invocation requests that it receives.
     * </p>
     *
     * @param createAliasRequest
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a> for a
     * Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke
     * a different version.
     * </p>
     * <p>
     * You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code>
     * parameter to specify a second version and the percentage of invocation requests that it receives.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAliasRequest#builder()}
     * </p>
     *
     * @param createAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest) {
        return createAlias(CreateAliasRequest.builder().applyMutation(createAliasRequest).build());
    }

    /**
     * <p>
     * Creates a code signing configuration. A <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">code signing configuration</a>
     * defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if
     * deployment validation checks fail).
     * </p>
     *
     * @param createCodeSigningConfigRequest
     * @return A Java Future containing the result of the CreateCodeSigningConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCodeSigningConfigResponse> createCodeSigningConfig(
            CreateCodeSigningConfigRequest createCodeSigningConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a code signing configuration. A <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">code signing configuration</a>
     * defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if
     * deployment validation checks fail).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCodeSigningConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param createCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCodeSigningConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCodeSigningConfigResponse> createCodeSigningConfig(
            Consumer<CreateCodeSigningConfigRequest.Builder> createCodeSigningConfigRequest) {
        return createCodeSigningConfig(CreateCodeSigningConfigRequest.builder().applyMutation(createCodeSigningConfigRequest)
                .build());
    }

    /**
     * <p>
     * Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and
     * invokes the function.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for DynamoDB and Kinesis event sources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For stream sources (DynamoDB, Kinesis, Amazon MSK, and self-managed Apache Kafka), the following option is also
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OnFailure</code> – Send discarded records to an Amazon SQS queue, Amazon SNS topic, or Amazon S3 bucket.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-async-retain-records.html#invocation-async-destinations"
     * >Adding a destination</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon
     * DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createEventSourceMappingRequest
     * @return A Java Future containing the result of the CreateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSourceMappingResponse> createEventSourceMapping(
            CreateEventSourceMappingRequest createEventSourceMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and
     * invokes the function.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for DynamoDB and Kinesis event sources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For stream sources (DynamoDB, Kinesis, Amazon MSK, and self-managed Apache Kafka), the following option is also
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OnFailure</code> – Send discarded records to an Amazon SQS queue, Amazon SNS topic, or Amazon S3 bucket.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-async-retain-records.html#invocation-async-destinations"
     * >Adding a destination</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon
     * DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param createEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSourceMappingResponse> createEventSourceMapping(
            Consumer<CreateEventSourceMappingRequest.Builder> createEventSourceMappingRequest) {
        return createEventSourceMapping(CreateEventSourceMappingRequest.builder().applyMutation(createEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Lambda function. To create a function, you need a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html">deployment package</a> and an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">
     * execution role</a>. The deployment package is a .zip file archive or container image that contains your function
     * code. The execution role grants the function permission to use Amazon Web Services services, such as Amazon
     * CloudWatch Logs for log streaming and X-Ray for request tracing.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a>, then you set the
     * package type to <code>Image</code>. For a container image, the code property must include the URI of a container
     * image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>, then you set the package type to <code>Zip</code>. For a .zip file archive, the code property
     * specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in
     * the deployment package must be compatible with the target instruction set architecture of the function (
     * <code>x86-64</code> or <code>arm64</code>). If you do not specify the architecture, then the default value is
     * <code>x86-64</code>.
     * </p>
     * <p>
     * When you create a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify
     * the function. The <code>State</code>, <code>StateReason</code>, and <code>StateReasonCode</code> fields in the
     * response from <a>GetFunctionConfiguration</a> indicate when the function is ready to invoke. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function
     * states</a>.
     * </p>
     * <p>
     * A function has an unpublished version, and can have published versions and aliases. The unpublished version
     * changes when you update your function's code and configuration. A published version is a snapshot of your
     * function code and configuration that can't be changed. An alias is a named resource that maps to a version, and
     * can be changed to map to a different version. Use the <code>Publish</code> parameter to create version
     * <code>1</code> of your function from its initial configuration.
     * </p>
     * <p>
     * The other parameters let you configure version-specific and function-level settings. You can modify
     * version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both
     * the unpublished and published versions of the function, and include tags (<a>TagResource</a>) and per-function
     * concurrency limits (<a>PutFunctionConcurrency</a>).
     * </p>
     * <p>
     * You can use code signing if your deployment package is a .zip file archive. To enable code signing for this
     * function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with
     * <a>UpdateFunctionCode</a>, Lambda checks that the code package has a valid signature from a trusted publisher.
     * The code-signing configuration includes set of signing profiles, which define the trusted publishers for this
     * function.
     * </p>
     * <p>
     * If another Amazon Web Services account or an Amazon Web Services service invokes your function, use
     * <a>AddPermission</a> to grant permission by creating a resource-based Identity and Access Management (IAM)
     * policy. You can grant permissions at the function level, on a version, or on an alias.
     * </p>
     * <p>
     * To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other
     * Amazon Web Services services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a
     * function trigger in the other service. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html">Invoking Lambda functions</a>.
     * </p>
     *
     * @param createFunctionRequest
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>InvalidCodeSignatureException The code signature failed the integrity check. If the integrity check
     *         fails, then Lambda blocks deployment, even if the code signing policy is set to WARN.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeVerificationFailedException The code signature failed one or more of the validation checks for
     *         signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the
     *         deployment.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>CodeStorageExceededException Your Amazon Web Services account has exceeded its maximum total code
     *         size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFunctionResponse> createFunction(CreateFunctionRequest createFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Lambda function. To create a function, you need a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html">deployment package</a> and an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">
     * execution role</a>. The deployment package is a .zip file archive or container image that contains your function
     * code. The execution role grants the function permission to use Amazon Web Services services, such as Amazon
     * CloudWatch Logs for log streaming and X-Ray for request tracing.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a>, then you set the
     * package type to <code>Image</code>. For a container image, the code property must include the URI of a container
     * image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>, then you set the package type to <code>Zip</code>. For a .zip file archive, the code property
     * specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in
     * the deployment package must be compatible with the target instruction set architecture of the function (
     * <code>x86-64</code> or <code>arm64</code>). If you do not specify the architecture, then the default value is
     * <code>x86-64</code>.
     * </p>
     * <p>
     * When you create a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify
     * the function. The <code>State</code>, <code>StateReason</code>, and <code>StateReasonCode</code> fields in the
     * response from <a>GetFunctionConfiguration</a> indicate when the function is ready to invoke. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function
     * states</a>.
     * </p>
     * <p>
     * A function has an unpublished version, and can have published versions and aliases. The unpublished version
     * changes when you update your function's code and configuration. A published version is a snapshot of your
     * function code and configuration that can't be changed. An alias is a named resource that maps to a version, and
     * can be changed to map to a different version. Use the <code>Publish</code> parameter to create version
     * <code>1</code> of your function from its initial configuration.
     * </p>
     * <p>
     * The other parameters let you configure version-specific and function-level settings. You can modify
     * version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both
     * the unpublished and published versions of the function, and include tags (<a>TagResource</a>) and per-function
     * concurrency limits (<a>PutFunctionConcurrency</a>).
     * </p>
     * <p>
     * You can use code signing if your deployment package is a .zip file archive. To enable code signing for this
     * function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with
     * <a>UpdateFunctionCode</a>, Lambda checks that the code package has a valid signature from a trusted publisher.
     * The code-signing configuration includes set of signing profiles, which define the trusted publishers for this
     * function.
     * </p>
     * <p>
     * If another Amazon Web Services account or an Amazon Web Services service invokes your function, use
     * <a>AddPermission</a> to grant permission by creating a resource-based Identity and Access Management (IAM)
     * policy. You can grant permissions at the function level, on a version, or on an alias.
     * </p>
     * <p>
     * To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other
     * Amazon Web Services services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a
     * function trigger in the other service. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html">Invoking Lambda functions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFunctionRequest#builder()}
     * </p>
     *
     * @param createFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>InvalidCodeSignatureException The code signature failed the integrity check. If the integrity check
     *         fails, then Lambda blocks deployment, even if the code signing policy is set to WARN.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeVerificationFailedException The code signature failed one or more of the validation checks for
     *         signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the
     *         deployment.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>CodeStorageExceededException Your Amazon Web Services account has exceeded its maximum total code
     *         size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFunctionResponse> createFunction(Consumer<CreateFunctionRequest.Builder> createFunctionRequest) {
        return createFunction(CreateFunctionRequest.builder().applyMutation(createFunctionRequest).build());
    }

    /**
     * <p>
     * Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S)
     * endpoint that you can use to invoke your function.
     * </p>
     *
     * @param createFunctionUrlConfigRequest
     * @return A Java Future containing the result of the CreateFunctionUrlConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFunctionUrlConfigResponse> createFunctionUrlConfig(
            CreateFunctionUrlConfigRequest createFunctionUrlConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S)
     * endpoint that you can use to invoke your function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionUrlConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFunctionUrlConfigRequest#builder()}
     * </p>
     *
     * @param createFunctionUrlConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFunctionUrlConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFunctionUrlConfigResponse> createFunctionUrlConfig(
            Consumer<CreateFunctionUrlConfigRequest.Builder> createFunctionUrlConfigRequest) {
        return createFunctionUrlConfig(CreateFunctionUrlConfigRequest.builder().applyMutation(createFunctionUrlConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     *
     * @param deleteAliasRequest
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAliasRequest#builder()}
     * </p>
     *
     * @param deleteAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAliasResponse> deleteAlias(Consumer<DeleteAliasRequest.Builder> deleteAliasRequest) {
        return deleteAlias(DeleteAliasRequest.builder().applyMutation(deleteAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the code signing configuration. You can delete the code signing configuration only if no function is
     * using it.
     * </p>
     *
     * @param deleteCodeSigningConfigRequest
     * @return A Java Future containing the result of the DeleteCodeSigningConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCodeSigningConfigResponse> deleteCodeSigningConfig(
            DeleteCodeSigningConfigRequest deleteCodeSigningConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the code signing configuration. You can delete the code signing configuration only if no function is
     * using it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCodeSigningConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param deleteCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCodeSigningConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCodeSigningConfigResponse> deleteCodeSigningConfig(
            Consumer<DeleteCodeSigningConfigRequest.Builder> deleteCodeSigningConfigRequest) {
        return deleteCodeSigningConfig(DeleteCodeSigningConfigRequest.builder().applyMutation(deleteCodeSigningConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
     * mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.
     * </p>
     * <p>
     * When you delete an event source mapping, it enters a <code>Deleting</code> state and might not be completely
     * deleted for several seconds.
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     * @return A Java Future containing the result of the DeleteEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         tried to update an event source mapping in the CREATING state, or you tried to delete an event source
     *         mapping currently UPDATING.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSourceMappingResponse> deleteEventSourceMapping(
            DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
     * mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.
     * </p>
     * <p>
     * When you delete an event source mapping, it enters a <code>Deleting</code> state and might not be completely
     * deleted for several seconds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         tried to update an event source mapping in the CREATING state, or you tried to delete an event source
     *         mapping currently UPDATING.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSourceMappingResponse> deleteEventSourceMapping(
            Consumer<DeleteEventSourceMappingRequest.Builder> deleteEventSourceMappingRequest) {
        return deleteEventSourceMapping(DeleteEventSourceMappingRequest.builder().applyMutation(deleteEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted. This doesn't require the user to have explicit permissions for
     * <a>DeleteAlias</a>.
     * </p>
     * <note>
     * <p>
     * A deleted Lambda function cannot be recovered. Ensure that you specify the correct function name and version
     * before deleting.
     * </p>
     * </note>
     * <p>
     * To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For Amazon
     * Web Services services and resources that invoke your function directly, delete the trigger in the service where
     * you originally configured it.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted. This doesn't require the user to have explicit permissions for
     * <a>DeleteAlias</a>.
     * </p>
     * <note>
     * <p>
     * A deleted Lambda function cannot be recovered. Ensure that you specify the correct function name and version
     * before deleting.
     * </p>
     * </note>
     * <p>
     * To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For Amazon
     * Web Services services and resources that invoke your function directly, delete the trigger in the service where
     * you originally configured it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFunctionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFunctionResponse> deleteFunction(Consumer<DeleteFunctionRequest.Builder> deleteFunctionRequest) {
        return deleteFunction(DeleteFunctionRequest.builder().applyMutation(deleteFunctionRequest).build());
    }

    /**
     * <p>
     * Removes the code signing configuration from the function.
     * </p>
     *
     * @param deleteFunctionCodeSigningConfigRequest
     * @return A Java Future containing the result of the DeleteFunctionCodeSigningConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionCodeSigningConfigResponse> deleteFunctionCodeSigningConfig(
            DeleteFunctionCodeSigningConfigRequest deleteFunctionCodeSigningConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the code signing configuration from the function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFunctionCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param deleteFunctionCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteFunctionCodeSigningConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionCodeSigningConfigResponse> deleteFunctionCodeSigningConfig(
            Consumer<DeleteFunctionCodeSigningConfigRequest.Builder> deleteFunctionCodeSigningConfigRequest) {
        return deleteFunctionCodeSigningConfig(DeleteFunctionCodeSigningConfigRequest.builder()
                .applyMutation(deleteFunctionCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * Removes a concurrent execution limit from a function.
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     * @return A Java Future containing the result of the DeleteFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionConcurrencyResponse> deleteFunctionConcurrency(
            DeleteFunctionConcurrencyRequest deleteFunctionConcurrencyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a concurrent execution limit from a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionConcurrencyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionConcurrencyResponse> deleteFunctionConcurrency(
            Consumer<DeleteFunctionConcurrencyRequest.Builder> deleteFunctionConcurrencyRequest) {
        return deleteFunctionConcurrency(DeleteFunctionConcurrencyRequest.builder()
                .applyMutation(deleteFunctionConcurrencyRequest).build());
    }

    /**
     * <p>
     * Deletes the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param deleteFunctionEventInvokeConfigRequest
     * @return A Java Future containing the result of the DeleteFunctionEventInvokeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionEventInvokeConfigResponse> deleteFunctionEventInvokeConfig(
            DeleteFunctionEventInvokeConfigRequest deleteFunctionEventInvokeConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionEventInvokeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFunctionEventInvokeConfigRequest#builder()}
     * </p>
     *
     * @param deleteFunctionEventInvokeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteFunctionEventInvokeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionEventInvokeConfigResponse> deleteFunctionEventInvokeConfig(
            Consumer<DeleteFunctionEventInvokeConfigRequest.Builder> deleteFunctionEventInvokeConfigRequest) {
        return deleteFunctionEventInvokeConfig(DeleteFunctionEventInvokeConfigRequest.builder()
                .applyMutation(deleteFunctionEventInvokeConfigRequest).build());
    }

    /**
     * <p>
     * Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL
     * results in a different URL address.
     * </p>
     *
     * @param deleteFunctionUrlConfigRequest
     * @return A Java Future containing the result of the DeleteFunctionUrlConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionUrlConfigResponse> deleteFunctionUrlConfig(
            DeleteFunctionUrlConfigRequest deleteFunctionUrlConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL
     * results in a different URL address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionUrlConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFunctionUrlConfigRequest#builder()}
     * </p>
     *
     * @param deleteFunctionUrlConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFunctionUrlConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionUrlConfigResponse> deleteFunctionUrlConfig(
            Consumer<DeleteFunctionUrlConfigRequest.Builder> deleteFunctionUrlConfigRequest) {
        return deleteFunctionUrlConfig(DeleteFunctionUrlConfigRequest.builder().applyMutation(deleteFunctionUrlConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of
     * the version remains in Lambda until no functions refer to it.
     * </p>
     *
     * @param deleteLayerVersionRequest
     * @return A Java Future containing the result of the DeleteLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLayerVersionResponse> deleteLayerVersion(DeleteLayerVersionRequest deleteLayerVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of
     * the version remains in Lambda until no functions refer to it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLayerVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLayerVersionRequest#builder()}
     * </p>
     *
     * @param deleteLayerVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLayerVersionResponse> deleteLayerVersion(
            Consumer<DeleteLayerVersionRequest.Builder> deleteLayerVersionRequest) {
        return deleteLayerVersion(DeleteLayerVersionRequest.builder().applyMutation(deleteLayerVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the provisioned concurrency configuration for a function.
     * </p>
     *
     * @param deleteProvisionedConcurrencyConfigRequest
     * @return A Java Future containing the result of the DeleteProvisionedConcurrencyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisionedConcurrencyConfigResponse> deleteProvisionedConcurrencyConfig(
            DeleteProvisionedConcurrencyConfigRequest deleteProvisionedConcurrencyConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the provisioned concurrency configuration for a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisionedConcurrencyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteProvisionedConcurrencyConfigRequest#builder()}
     * </p>
     *
     * @param deleteProvisionedConcurrencyConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteProvisionedConcurrencyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProvisionedConcurrencyConfigResponse> deleteProvisionedConcurrencyConfig(
            Consumer<DeleteProvisionedConcurrencyConfigRequest.Builder> deleteProvisionedConcurrencyConfigRequest) {
        return deleteProvisionedConcurrencyConfig(DeleteProvisionedConcurrencyConfigRequest.builder()
                .applyMutation(deleteProvisionedConcurrencyConfigRequest).build());
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services
     * Region.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services
     * Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(
            Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest) {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services
     * Region.
     * </p>
     *
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings() {
        return getAccountSettings(GetAccountSettingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns details about a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     *
     * @param getAliasRequest
     * @return A Java Future containing the result of the GetAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAliasResponse> getAlias(GetAliasRequest getAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAliasRequest.Builder} avoiding the need to
     * create one manually via {@link GetAliasRequest#builder()}
     * </p>
     *
     * @param getAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAliasResponse> getAlias(Consumer<GetAliasRequest.Builder> getAliasRequest) {
        return getAlias(GetAliasRequest.builder().applyMutation(getAliasRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified code signing configuration.
     * </p>
     *
     * @param getCodeSigningConfigRequest
     * @return A Java Future containing the result of the GetCodeSigningConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetCodeSigningConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCodeSigningConfigResponse> getCodeSigningConfig(
            GetCodeSigningConfigRequest getCodeSigningConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified code signing configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeSigningConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param getCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCodeSigningConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetCodeSigningConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCodeSigningConfigResponse> getCodeSigningConfig(
            Consumer<GetCodeSigningConfigRequest.Builder> getCodeSigningConfigRequest) {
        return getCodeSigningConfig(GetCodeSigningConfigRequest.builder().applyMutation(getCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of
     * <a>ListEventSourceMappings</a>.
     * </p>
     *
     * @param getEventSourceMappingRequest
     * @return A Java Future containing the result of the GetEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventSourceMappingResponse> getEventSourceMapping(
            GetEventSourceMappingRequest getEventSourceMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of
     * <a>ListEventSourceMappings</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventSourceMappingRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param getEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventSourceMappingResponse> getEventSourceMapping(
            Consumer<GetEventSourceMappingRequest.Builder> getEventSourceMappingRequest) {
        return getEventSourceMapping(GetEventSourceMappingRequest.builder().applyMutation(getEventSourceMappingRequest).build());
    }

    /**
     * <p>
     * Returns information about the function or function version, with a link to download the deployment package that's
     * valid for 10 minutes. If you specify a function version, only details that are specific to that version are
     * returned.
     * </p>
     *
     * @param getFunctionRequest
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFunctionResponse> getFunction(GetFunctionRequest getFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the function or function version, with a link to download the deployment package that's
     * valid for 10 minutes. If you specify a function version, only details that are specific to that version are
     * returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link GetFunctionRequest#builder()}
     * </p>
     *
     * @param getFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFunctionResponse> getFunction(Consumer<GetFunctionRequest.Builder> getFunctionRequest) {
        return getFunction(GetFunctionRequest.builder().applyMutation(getFunctionRequest).build());
    }

    /**
     * <p>
     * Returns the code signing configuration for the specified function.
     * </p>
     *
     * @param getFunctionCodeSigningConfigRequest
     * @return A Java Future containing the result of the GetFunctionCodeSigningConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionCodeSigningConfigResponse> getFunctionCodeSigningConfig(
            GetFunctionCodeSigningConfigRequest getFunctionCodeSigningConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the code signing configuration for the specified function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetFunctionCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param getFunctionCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetFunctionCodeSigningConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionCodeSigningConfigResponse> getFunctionCodeSigningConfig(
            Consumer<GetFunctionCodeSigningConfigRequest.Builder> getFunctionCodeSigningConfigRequest) {
        return getFunctionCodeSigningConfig(GetFunctionCodeSigningConfigRequest.builder()
                .applyMutation(getFunctionCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a
     * function, use <a>PutFunctionConcurrency</a>.
     * </p>
     *
     * @param getFunctionConcurrencyRequest
     * @return A Java Future containing the result of the GetFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFunctionConcurrencyResponse> getFunctionConcurrency(
            GetFunctionConcurrencyRequest getFunctionConcurrencyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a
     * function, use <a>PutFunctionConcurrency</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionConcurrencyRequest.Builder} avoiding the
     * need to create one manually via {@link GetFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param getFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFunctionConcurrencyResponse> getFunctionConcurrency(
            Consumer<GetFunctionConcurrencyRequest.Builder> getFunctionConcurrencyRequest) {
        return getFunctionConcurrency(GetFunctionConcurrencyRequest.builder().applyMutation(getFunctionConcurrencyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the version-specific settings of a Lambda function or version. The output includes only options that can
     * vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To get all of a function's details, including function-level settings, use <a>GetFunction</a>.
     * </p>
     *
     * @param getFunctionConfigurationRequest
     * @return A Java Future containing the result of the GetFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionConfigurationResponse> getFunctionConfiguration(
            GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the version-specific settings of a Lambda function or version. The output includes only options that can
     * vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To get all of a function's details, including function-level settings, use <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetFunctionConfigurationRequest#builder()}
     * </p>
     *
     * @param getFunctionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionConfigurationResponse> getFunctionConfiguration(
            Consumer<GetFunctionConfigurationRequest.Builder> getFunctionConfigurationRequest) {
        return getFunctionConfiguration(GetFunctionConfigurationRequest.builder().applyMutation(getFunctionConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param getFunctionEventInvokeConfigRequest
     * @return A Java Future containing the result of the GetFunctionEventInvokeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionEventInvokeConfigResponse> getFunctionEventInvokeConfig(
            GetFunctionEventInvokeConfigRequest getFunctionEventInvokeConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionEventInvokeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetFunctionEventInvokeConfigRequest#builder()}
     * </p>
     *
     * @param getFunctionEventInvokeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetFunctionEventInvokeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionEventInvokeConfigResponse> getFunctionEventInvokeConfig(
            Consumer<GetFunctionEventInvokeConfigRequest.Builder> getFunctionEventInvokeConfigRequest) {
        return getFunctionEventInvokeConfig(GetFunctionEventInvokeConfigRequest.builder()
                .applyMutation(getFunctionEventInvokeConfigRequest).build());
    }

    /**
     * <p>
     * Returns your function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-recursion.html">recursive loop detection</a>
     * configuration.
     * </p>
     *
     * @param getFunctionRecursionConfigRequest
     * @return A Java Future containing the result of the GetFunctionRecursionConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionRecursionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionRecursionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionRecursionConfigResponse> getFunctionRecursionConfig(
            GetFunctionRecursionConfigRequest getFunctionRecursionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns your function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-recursion.html">recursive loop detection</a>
     * configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionRecursionConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetFunctionRecursionConfigRequest#builder()}
     * </p>
     *
     * @param getFunctionRecursionConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFunctionRecursionConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionRecursionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionRecursionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionRecursionConfigResponse> getFunctionRecursionConfig(
            Consumer<GetFunctionRecursionConfigRequest.Builder> getFunctionRecursionConfigRequest) {
        return getFunctionRecursionConfig(GetFunctionRecursionConfigRequest.builder()
                .applyMutation(getFunctionRecursionConfigRequest).build());
    }

    /**
     * <p>
     * Returns details about a Lambda function URL.
     * </p>
     *
     * @param getFunctionUrlConfigRequest
     * @return A Java Future containing the result of the GetFunctionUrlConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionUrlConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFunctionUrlConfigResponse> getFunctionUrlConfig(
            GetFunctionUrlConfigRequest getFunctionUrlConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a Lambda function URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionUrlConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetFunctionUrlConfigRequest#builder()}
     * </p>
     *
     * @param getFunctionUrlConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetFunctionUrlConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFunctionUrlConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionUrlConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetFunctionUrlConfigResponse> getFunctionUrlConfig(
            Consumer<GetFunctionUrlConfigRequest.Builder> getFunctionUrlConfigRequest) {
        return getFunctionUrlConfig(GetFunctionUrlConfigRequest.builder().applyMutation(getFunctionUrlConfigRequest).build());
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionRequest
     * @return A Java Future containing the result of the GetLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLayerVersionResponse> getLayerVersion(GetLayerVersionRequest getLayerVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetLayerVersionRequest#builder()}
     * </p>
     *
     * @param getLayerVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLayerVersionResponse> getLayerVersion(
            Consumer<GetLayerVersionRequest.Builder> getLayerVersionRequest) {
        return getLayerVersion(GetLayerVersionRequest.builder().applyMutation(getLayerVersionRequest).build());
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionByArnRequest
     * @return A Java Future containing the result of the GetLayerVersionByArn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersionByArn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionByArn" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLayerVersionByArnResponse> getLayerVersionByArn(
            GetLayerVersionByArnRequest getLayerVersionByArnRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionByArnRequest.Builder} avoiding the
     * need to create one manually via {@link GetLayerVersionByArnRequest#builder()}
     * </p>
     *
     * @param getLayerVersionByArnRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLayerVersionByArn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersionByArn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionByArn" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLayerVersionByArnResponse> getLayerVersionByArn(
            Consumer<GetLayerVersionByArnRequest.Builder> getLayerVersionByArnRequest) {
        return getLayerVersionByArn(GetLayerVersionByArnRequest.builder().applyMutation(getLayerVersionByArnRequest).build());
    }

    /**
     * <p>
     * Returns the permission policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     * @return A Java Future containing the result of the GetLayerVersionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLayerVersionPolicyResponse> getLayerVersionPolicy(
            GetLayerVersionPolicyRequest getLayerVersionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the permission policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetLayerVersionPolicyRequest#builder()}
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLayerVersionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLayerVersionPolicyResponse> getLayerVersionPolicy(
            Consumer<GetLayerVersionPolicyRequest.Builder> getLayerVersionPolicyRequest) {
        return getLayerVersionPolicy(GetLayerVersionPolicyRequest.builder().applyMutation(getLayerVersionPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM
     * policy</a> for a function, version, or alias.
     * </p>
     *
     * @param getPolicyRequest
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM
     * policy</a> for a function, version, or alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves the provisioned concurrency configuration for a function's alias or version.
     * </p>
     *
     * @param getProvisionedConcurrencyConfigRequest
     * @return A Java Future containing the result of the GetProvisionedConcurrencyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ProvisionedConcurrencyConfigNotFoundException The specified configuration does not exist.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProvisionedConcurrencyConfigResponse> getProvisionedConcurrencyConfig(
            GetProvisionedConcurrencyConfigRequest getProvisionedConcurrencyConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the provisioned concurrency configuration for a function's alias or version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProvisionedConcurrencyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetProvisionedConcurrencyConfigRequest#builder()}
     * </p>
     *
     * @param getProvisionedConcurrencyConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetProvisionedConcurrencyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ProvisionedConcurrencyConfigNotFoundException The specified configuration does not exist.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProvisionedConcurrencyConfigResponse> getProvisionedConcurrencyConfig(
            Consumer<GetProvisionedConcurrencyConfigRequest.Builder> getProvisionedConcurrencyConfigRequest) {
        return getProvisionedConcurrencyConfig(GetProvisionedConcurrencyConfigRequest.builder()
                .applyMutation(getProvisionedConcurrencyConfigRequest).build());
    }

    /**
     * <p>
     * Retrieves the runtime management configuration for a function's version. If the runtime update mode is
     * <b>Manual</b>, this includes the ARN of the runtime version and the runtime update mode. If the runtime update
     * mode is <b>Auto</b> or <b>Function update</b>, this includes the runtime update mode and <code>null</code> is
     * returned for the ARN. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.
     * </p>
     *
     * @param getRuntimeManagementConfigRequest
     * @return A Java Future containing the result of the GetRuntimeManagementConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetRuntimeManagementConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetRuntimeManagementConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRuntimeManagementConfigResponse> getRuntimeManagementConfig(
            GetRuntimeManagementConfigRequest getRuntimeManagementConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the runtime management configuration for a function's version. If the runtime update mode is
     * <b>Manual</b>, this includes the ARN of the runtime version and the runtime update mode. If the runtime update
     * mode is <b>Auto</b> or <b>Function update</b>, this includes the runtime update mode and <code>null</code> is
     * returned for the ARN. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuntimeManagementConfigRequest.Builder} avoiding
     * the need to create one manually via {@link GetRuntimeManagementConfigRequest#builder()}
     * </p>
     *
     * @param getRuntimeManagementConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.GetRuntimeManagementConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRuntimeManagementConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetRuntimeManagementConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetRuntimeManagementConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRuntimeManagementConfigResponse> getRuntimeManagementConfig(
            Consumer<GetRuntimeManagementConfigRequest.Builder> getRuntimeManagementConfigRequest) {
        return getRuntimeManagementConfig(GetRuntimeManagementConfigRequest.builder()
                .applyMutation(getRuntimeManagementConfigRequest).build());
    }

    /**
     * <p>
     * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or
     * asynchronously. By default, Lambda invokes your function synchronously (i.e. the<code>InvocationType</code> is
     * <code>RequestResponse</code>). To invoke a function asynchronously, set <code>InvocationType</code> to
     * <code>Event</code>. Lambda passes the <code>ClientContext</code> object to your function for synchronous
     * invocations only.
     * </p>
     * <p>
     * For synchronous invocations, the maximum payload size is 6 MB. For asynchronous invocations, the maximum payload
     * size is 1 MB.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html">synchronous invocation</a>,
     * details about the function response, including errors, are included in the response body and headers. For either
     * invocation type, you can find more information in the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">trace</a>.
     * </p>
     * <p>
     * When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client,
     * event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error,
     * Lambda executes the function up to two more times. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-retries.html">Error handling and automatic retries
     * in Lambda</a>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a>,
     * Lambda adds events to a queue before sending them to your function. If your function does not have enough
     * capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event
     * multiple times, even if no error occurs. To retain events that were not processed, configure your function with a
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq">dead-letter
     * queue</a>.
     * </p>
     * <p>
     * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your function from executing, such as permissions errors, <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">quota</a> errors, or issues with
     * your function's code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if
     * running the function would cause you to exceed a concurrency limit at either the account level (
     * <code>ConcurrentInvocationLimitExceeded</code>) or function level (
     * <code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).
     * </p>
     * <p>
     * For functions with a long timeout, your client might disconnect during synchronous invocation while it waits for
     * a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections
     * with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action. For
     * details on how to set up permissions for cross-account invocations, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke"
     * >Granting function access to other accounts</a>.
     * </p>
     *
     * @param invokeRequest
     * @return A Java Future containing the result of the Invoke operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotReadyException The function is inactive and its VPC connection is no longer available.
     *         Wait for the VPC connection to reestablish and try again.</li>
     *         <li>InvalidSecurityGroupIdException The security group ID provided in the Lambda function VPC
     *         configuration is not valid.</li>
     *         <li>SnapStartTimeoutException Lambda couldn't restore the snapshot within the timeout limit.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>Ec2ThrottledException Amazon EC2 throttled Lambda during Lambda function initialization using the
     *         execution role provided for the function.</li>
     *         <li>EfsMountConnectivityException The Lambda function couldn't make a network connection to the
     *         configured file system.</li>
     *         <li>SubnetIpAddressLimitReachedException Lambda couldn't set up VPC access for the Lambda function
     *         because one or more configured subnets has no available IP addresses.</li>
     *         <li>KmsAccessDeniedException Lambda couldn't decrypt the environment variables because KMS access was
     *         denied. Check the Lambda function's KMS permissions.</li>
     *         <li>RequestTooLargeException The request payload exceeded the <code>Invoke</code> request body JSON input
     *         quota. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>KmsDisabledException Lambda couldn't decrypt the environment variables because the KMS key used is
     *         disabled. Check the Lambda function's KMS key settings.</li>
     *         <li>UnsupportedMediaTypeException The content type of the <code>Invoke</code> request body is not JSON.</li>
     *         <li>SerializedRequestEntityTooLargeException The processed request payload exceeded the
     *         <code>Invoke</code> request body size limit for asynchronous invocations. While the event payload may be
     *         under 1 MB, the size after internal serialization exceeds the maximum allowed size for asynchronous
     *         invocations.</li>
     *         <li>InvalidRuntimeException The runtime or runtime version specified is not supported.</li>
     *         <li>Ec2UnexpectedException Lambda received an unexpected Amazon EC2 client exception while setting up for
     *         the Lambda function.</li>
     *         <li>InvalidSubnetIdException The subnet ID provided in the Lambda function VPC configuration is not
     *         valid.</li>
     *         <li>KmsNotFoundException Lambda couldn't decrypt the environment variables because the KMS key was not
     *         found. Check the function's KMS key settings.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>Ec2AccessDeniedException Need additional permissions to configure VPC settings.</li>
     *         <li>EfsioException An error occurred when reading from or writing to a connected file system.</li>
     *         <li>KmsInvalidStateException Lambda couldn't decrypt the environment variables because the state of the
     *         KMS key used is not valid for Decrypt. Check the function's KMS key settings.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>EniLimitReachedException Lambda couldn't create an elastic network interface in the VPC, specified as
     *         part of Lambda function configuration, because the limit for network interfaces has been reached. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>SnapStartNotReadyException Lambda is initializing your function. You can invoke the function when the
     *         <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">function state</a> becomes
     *         <code>Active</code>.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SnapStartException The <code>afterRestore()</code> <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-runtime-hooks.html">runtime hook</a>
     *         encountered an error. For more information, check the Amazon CloudWatch logs.</li>
     *         <li>RecursiveInvocationException Lambda has detected your function being invoked in a recursive loop with
     *         other Amazon Web Services resources and stopped your function's invocation.</li>
     *         <li>EfsMountTimeoutException The Lambda function made a network connection to the configured file system,
     *         but the mount operation timed out.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InvalidRequestContentException The request body could not be parsed as JSON, or a request header is
     *         invalid. For example, the 'x-amzn-RequestId' header is not a valid UUID string.</li>
     *         <li>InvalidZipFileException Lambda could not unzip the deployment package.</li>
     *         <li>EfsMountFailureException The Lambda function couldn't mount the configured file system due to a
     *         permission or configuration issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.Invoke
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InvokeResponse> invoke(InvokeRequest invokeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or
     * asynchronously. By default, Lambda invokes your function synchronously (i.e. the<code>InvocationType</code> is
     * <code>RequestResponse</code>). To invoke a function asynchronously, set <code>InvocationType</code> to
     * <code>Event</code>. Lambda passes the <code>ClientContext</code> object to your function for synchronous
     * invocations only.
     * </p>
     * <p>
     * For synchronous invocations, the maximum payload size is 6 MB. For asynchronous invocations, the maximum payload
     * size is 1 MB.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html">synchronous invocation</a>,
     * details about the function response, including errors, are included in the response body and headers. For either
     * invocation type, you can find more information in the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">trace</a>.
     * </p>
     * <p>
     * When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client,
     * event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error,
     * Lambda executes the function up to two more times. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-retries.html">Error handling and automatic retries
     * in Lambda</a>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a>,
     * Lambda adds events to a queue before sending them to your function. If your function does not have enough
     * capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event
     * multiple times, even if no error occurs. To retain events that were not processed, configure your function with a
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq">dead-letter
     * queue</a>.
     * </p>
     * <p>
     * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your function from executing, such as permissions errors, <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">quota</a> errors, or issues with
     * your function's code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if
     * running the function would cause you to exceed a concurrency limit at either the account level (
     * <code>ConcurrentInvocationLimitExceeded</code>) or function level (
     * <code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).
     * </p>
     * <p>
     * For functions with a long timeout, your client might disconnect during synchronous invocation while it waits for
     * a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections
     * with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action. For
     * details on how to set up permissions for cross-account invocations, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke"
     * >Granting function access to other accounts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeRequest.Builder} avoiding the need to create
     * one manually via {@link InvokeRequest#builder()}
     * </p>
     *
     * @param invokeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.InvokeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Invoke operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotReadyException The function is inactive and its VPC connection is no longer available.
     *         Wait for the VPC connection to reestablish and try again.</li>
     *         <li>InvalidSecurityGroupIdException The security group ID provided in the Lambda function VPC
     *         configuration is not valid.</li>
     *         <li>SnapStartTimeoutException Lambda couldn't restore the snapshot within the timeout limit.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>Ec2ThrottledException Amazon EC2 throttled Lambda during Lambda function initialization using the
     *         execution role provided for the function.</li>
     *         <li>EfsMountConnectivityException The Lambda function couldn't make a network connection to the
     *         configured file system.</li>
     *         <li>SubnetIpAddressLimitReachedException Lambda couldn't set up VPC access for the Lambda function
     *         because one or more configured subnets has no available IP addresses.</li>
     *         <li>KmsAccessDeniedException Lambda couldn't decrypt the environment variables because KMS access was
     *         denied. Check the Lambda function's KMS permissions.</li>
     *         <li>RequestTooLargeException The request payload exceeded the <code>Invoke</code> request body JSON input
     *         quota. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>KmsDisabledException Lambda couldn't decrypt the environment variables because the KMS key used is
     *         disabled. Check the Lambda function's KMS key settings.</li>
     *         <li>UnsupportedMediaTypeException The content type of the <code>Invoke</code> request body is not JSON.</li>
     *         <li>SerializedRequestEntityTooLargeException The processed request payload exceeded the
     *         <code>Invoke</code> request body size limit for asynchronous invocations. While the event payload may be
     *         under 1 MB, the size after internal serialization exceeds the maximum allowed size for asynchronous
     *         invocations.</li>
     *         <li>InvalidRuntimeException The runtime or runtime version specified is not supported.</li>
     *         <li>Ec2UnexpectedException Lambda received an unexpected Amazon EC2 client exception while setting up for
     *         the Lambda function.</li>
     *         <li>InvalidSubnetIdException The subnet ID provided in the Lambda function VPC configuration is not
     *         valid.</li>
     *         <li>KmsNotFoundException Lambda couldn't decrypt the environment variables because the KMS key was not
     *         found. Check the function's KMS key settings.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>Ec2AccessDeniedException Need additional permissions to configure VPC settings.</li>
     *         <li>EfsioException An error occurred when reading from or writing to a connected file system.</li>
     *         <li>KmsInvalidStateException Lambda couldn't decrypt the environment variables because the state of the
     *         KMS key used is not valid for Decrypt. Check the function's KMS key settings.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>EniLimitReachedException Lambda couldn't create an elastic network interface in the VPC, specified as
     *         part of Lambda function configuration, because the limit for network interfaces has been reached. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>SnapStartNotReadyException Lambda is initializing your function. You can invoke the function when the
     *         <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">function state</a> becomes
     *         <code>Active</code>.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SnapStartException The <code>afterRestore()</code> <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-runtime-hooks.html">runtime hook</a>
     *         encountered an error. For more information, check the Amazon CloudWatch logs.</li>
     *         <li>RecursiveInvocationException Lambda has detected your function being invoked in a recursive loop with
     *         other Amazon Web Services resources and stopped your function's invocation.</li>
     *         <li>EfsMountTimeoutException The Lambda function made a network connection to the configured file system,
     *         but the mount operation timed out.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InvalidRequestContentException The request body could not be parsed as JSON, or a request header is
     *         invalid. For example, the 'x-amzn-RequestId' header is not a valid UUID string.</li>
     *         <li>InvalidZipFileException Lambda could not unzip the deployment package.</li>
     *         <li>EfsMountFailureException The Lambda function couldn't mount the configured file system due to a
     *         permission or configuration issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.Invoke
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InvokeResponse> invoke(Consumer<InvokeRequest.Builder> invokeRequest) {
        return invoke(InvokeRequest.builder().applyMutation(invokeRequest).build());
    }

    /**
     * <p>
     * Configure your Lambda functions to stream response payloads back to clients. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html">Configuring a Lambda
     * function to stream responses</a>.
     * </p>
     * <p>
     * This operation requires permission for the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action. For
     * details on how to set up permissions for cross-account invocations, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke"
     * >Granting function access to other accounts</a>.
     * </p>
     *
     * @param invokeWithResponseStreamRequest
     * @return A Java Future containing the result of the InvokeWithResponseStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotReadyException The function is inactive and its VPC connection is no longer available.
     *         Wait for the VPC connection to reestablish and try again.</li>
     *         <li>InvalidSecurityGroupIdException The security group ID provided in the Lambda function VPC
     *         configuration is not valid.</li>
     *         <li>SnapStartTimeoutException Lambda couldn't restore the snapshot within the timeout limit.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>Ec2ThrottledException Amazon EC2 throttled Lambda during Lambda function initialization using the
     *         execution role provided for the function.</li>
     *         <li>EfsMountConnectivityException The Lambda function couldn't make a network connection to the
     *         configured file system.</li>
     *         <li>SubnetIpAddressLimitReachedException Lambda couldn't set up VPC access for the Lambda function
     *         because one or more configured subnets has no available IP addresses.</li>
     *         <li>KmsAccessDeniedException Lambda couldn't decrypt the environment variables because KMS access was
     *         denied. Check the Lambda function's KMS permissions.</li>
     *         <li>RequestTooLargeException The request payload exceeded the <code>Invoke</code> request body JSON input
     *         quota. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>KmsDisabledException Lambda couldn't decrypt the environment variables because the KMS key used is
     *         disabled. Check the Lambda function's KMS key settings.</li>
     *         <li>UnsupportedMediaTypeException The content type of the <code>Invoke</code> request body is not JSON.</li>
     *         <li>SerializedRequestEntityTooLargeException The processed request payload exceeded the
     *         <code>Invoke</code> request body size limit for asynchronous invocations. While the event payload may be
     *         under 1 MB, the size after internal serialization exceeds the maximum allowed size for asynchronous
     *         invocations.</li>
     *         <li>InvalidRuntimeException The runtime or runtime version specified is not supported.</li>
     *         <li>Ec2UnexpectedException Lambda received an unexpected Amazon EC2 client exception while setting up for
     *         the Lambda function.</li>
     *         <li>InvalidSubnetIdException The subnet ID provided in the Lambda function VPC configuration is not
     *         valid.</li>
     *         <li>KmsNotFoundException Lambda couldn't decrypt the environment variables because the KMS key was not
     *         found. Check the function's KMS key settings.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>Ec2AccessDeniedException Need additional permissions to configure VPC settings.</li>
     *         <li>EfsioException An error occurred when reading from or writing to a connected file system.</li>
     *         <li>KmsInvalidStateException Lambda couldn't decrypt the environment variables because the state of the
     *         KMS key used is not valid for Decrypt. Check the function's KMS key settings.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>EniLimitReachedException Lambda couldn't create an elastic network interface in the VPC, specified as
     *         part of Lambda function configuration, because the limit for network interfaces has been reached. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>SnapStartNotReadyException Lambda is initializing your function. You can invoke the function when the
     *         <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">function state</a> becomes
     *         <code>Active</code>.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SnapStartException The <code>afterRestore()</code> <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-runtime-hooks.html">runtime hook</a>
     *         encountered an error. For more information, check the Amazon CloudWatch logs.</li>
     *         <li>RecursiveInvocationException Lambda has detected your function being invoked in a recursive loop with
     *         other Amazon Web Services resources and stopped your function's invocation.</li>
     *         <li>EfsMountTimeoutException The Lambda function made a network connection to the configured file system,
     *         but the mount operation timed out.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InvalidRequestContentException The request body could not be parsed as JSON, or a request header is
     *         invalid. For example, the 'x-amzn-RequestId' header is not a valid UUID string.</li>
     *         <li>InvalidZipFileException Lambda could not unzip the deployment package.</li>
     *         <li>EfsMountFailureException The Lambda function couldn't mount the configured file system due to a
     *         permission or configuration issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.InvokeWithResponseStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvokeWithResponseStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeWithResponseStream(InvokeWithResponseStreamRequest invokeWithResponseStreamRequest,
            InvokeWithResponseStreamResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configure your Lambda functions to stream response payloads back to clients. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-response-streaming.html">Configuring a Lambda
     * function to stream responses</a>.
     * </p>
     * <p>
     * This operation requires permission for the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action. For
     * details on how to set up permissions for cross-account invocations, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke"
     * >Granting function access to other accounts</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeWithResponseStreamRequest.Builder} avoiding
     * the need to create one manually via {@link InvokeWithResponseStreamRequest#builder()}
     * </p>
     *
     * @param invokeWithResponseStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeWithResponseStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotReadyException The function is inactive and its VPC connection is no longer available.
     *         Wait for the VPC connection to reestablish and try again.</li>
     *         <li>InvalidSecurityGroupIdException The security group ID provided in the Lambda function VPC
     *         configuration is not valid.</li>
     *         <li>SnapStartTimeoutException Lambda couldn't restore the snapshot within the timeout limit.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>Ec2ThrottledException Amazon EC2 throttled Lambda during Lambda function initialization using the
     *         execution role provided for the function.</li>
     *         <li>EfsMountConnectivityException The Lambda function couldn't make a network connection to the
     *         configured file system.</li>
     *         <li>SubnetIpAddressLimitReachedException Lambda couldn't set up VPC access for the Lambda function
     *         because one or more configured subnets has no available IP addresses.</li>
     *         <li>KmsAccessDeniedException Lambda couldn't decrypt the environment variables because KMS access was
     *         denied. Check the Lambda function's KMS permissions.</li>
     *         <li>RequestTooLargeException The request payload exceeded the <code>Invoke</code> request body JSON input
     *         quota. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>KmsDisabledException Lambda couldn't decrypt the environment variables because the KMS key used is
     *         disabled. Check the Lambda function's KMS key settings.</li>
     *         <li>UnsupportedMediaTypeException The content type of the <code>Invoke</code> request body is not JSON.</li>
     *         <li>SerializedRequestEntityTooLargeException The processed request payload exceeded the
     *         <code>Invoke</code> request body size limit for asynchronous invocations. While the event payload may be
     *         under 1 MB, the size after internal serialization exceeds the maximum allowed size for asynchronous
     *         invocations.</li>
     *         <li>InvalidRuntimeException The runtime or runtime version specified is not supported.</li>
     *         <li>Ec2UnexpectedException Lambda received an unexpected Amazon EC2 client exception while setting up for
     *         the Lambda function.</li>
     *         <li>InvalidSubnetIdException The subnet ID provided in the Lambda function VPC configuration is not
     *         valid.</li>
     *         <li>KmsNotFoundException Lambda couldn't decrypt the environment variables because the KMS key was not
     *         found. Check the function's KMS key settings.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>Ec2AccessDeniedException Need additional permissions to configure VPC settings.</li>
     *         <li>EfsioException An error occurred when reading from or writing to a connected file system.</li>
     *         <li>KmsInvalidStateException Lambda couldn't decrypt the environment variables because the state of the
     *         KMS key used is not valid for Decrypt. Check the function's KMS key settings.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>EniLimitReachedException Lambda couldn't create an elastic network interface in the VPC, specified as
     *         part of Lambda function configuration, because the limit for network interfaces has been reached. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>SnapStartNotReadyException Lambda is initializing your function. You can invoke the function when the
     *         <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">function state</a> becomes
     *         <code>Active</code>.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SnapStartException The <code>afterRestore()</code> <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/snapstart-runtime-hooks.html">runtime hook</a>
     *         encountered an error. For more information, check the Amazon CloudWatch logs.</li>
     *         <li>RecursiveInvocationException Lambda has detected your function being invoked in a recursive loop with
     *         other Amazon Web Services resources and stopped your function's invocation.</li>
     *         <li>EfsMountTimeoutException The Lambda function made a network connection to the configured file system,
     *         but the mount operation timed out.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>InvalidRequestContentException The request body could not be parsed as JSON, or a request header is
     *         invalid. For example, the 'x-amzn-RequestId' header is not a valid UUID string.</li>
     *         <li>InvalidZipFileException Lambda could not unzip the deployment package.</li>
     *         <li>EfsMountFailureException The Lambda function couldn't mount the configured file system due to a
     *         permission or configuration issue.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.InvokeWithResponseStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/InvokeWithResponseStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<Void> invokeWithResponseStream(
            Consumer<InvokeWithResponseStreamRequest.Builder> invokeWithResponseStreamRequest,
            InvokeWithResponseStreamResponseHandler asyncResponseHandler) {
        return invokeWithResponseStream(InvokeWithResponseStreamRequest.builder().applyMutation(invokeWithResponseStreamRequest)
                .build(), asyncResponseHandler);
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">aliases</a>
     * for a Lambda function.
     * </p>
     *
     * @param listAliasesRequest
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">aliases</a>
     * for a Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListAliasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAliasesResponse> listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest) {
        return listAliases(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesPublisher listAliasesPaginator(ListAliasesRequest listAliasesRequest) {
        return new ListAliasesPublisher(this, listAliasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListAliasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesPublisher listAliasesPaginator(Consumer<ListAliasesRequest.Builder> listAliasesRequest) {
        return listAliasesPaginator(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code
     * signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the
     * <code>MaxItems</code> parameter to return fewer configurations per call.
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     * @return A Java Future containing the result of the ListCodeSigningConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCodeSigningConfigsResponse> listCodeSigningConfigs(
            ListCodeSigningConfigsRequest listCodeSigningConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code
     * signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the
     * <code>MaxItems</code> parameter to return fewer configurations per call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeSigningConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCodeSigningConfigsRequest#builder()}
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCodeSigningConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCodeSigningConfigsResponse> listCodeSigningConfigs(
            Consumer<ListCodeSigningConfigsRequest.Builder> listCodeSigningConfigsRequest) {
        return listCodeSigningConfigs(ListCodeSigningConfigsRequest.builder().applyMutation(listCodeSigningConfigsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsPublisher publisher = client.listCodeSigningConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsPublisher publisher = client.listCodeSigningConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCodeSigningConfigsPublisher listCodeSigningConfigsPaginator(
            ListCodeSigningConfigsRequest listCodeSigningConfigsRequest) {
        return new ListCodeSigningConfigsPublisher(this, listCodeSigningConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsPublisher publisher = client.listCodeSigningConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsPublisher publisher = client.listCodeSigningConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCodeSigningConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCodeSigningConfigsRequest#builder()}
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCodeSigningConfigsPublisher listCodeSigningConfigsPaginator(
            Consumer<ListCodeSigningConfigsRequest.Builder> listCodeSigningConfigsRequest) {
        return listCodeSigningConfigsPaginator(ListCodeSigningConfigsRequest.builder()
                .applyMutation(listCodeSigningConfigsRequest).build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A Java Future containing the result of the ListEventSourceMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventSourceMappingsResponse> listEventSourceMappings(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourceMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventSourceMappingsRequest#builder()}
     * </p>
     *
     * @param listEventSourceMappingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventSourceMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventSourceMappingsResponse> listEventSourceMappings(
            Consumer<ListEventSourceMappingsRequest.Builder> listEventSourceMappingsRequest) {
        return listEventSourceMappings(ListEventSourceMappingsRequest.builder().applyMutation(listEventSourceMappingsRequest)
                .build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     *
     * @return A Java Future containing the result of the ListEventSourceMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventSourceMappingsResponse> listEventSourceMappings() {
        return listEventSourceMappings(ListEventSourceMappingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSourceMappingsPublisher listEventSourceMappingsPaginator() {
        return listEventSourceMappingsPaginator(ListEventSourceMappingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSourceMappingsPublisher listEventSourceMappingsPaginator(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) {
        return new ListEventSourceMappingsPublisher(this, listEventSourceMappingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourceMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventSourceMappingsRequest#builder()}
     * </p>
     *
     * @param listEventSourceMappingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSourceMappingsPublisher listEventSourceMappingsPaginator(
            Consumer<ListEventSourceMappingsRequest.Builder> listEventSourceMappingsRequest) {
        return listEventSourceMappingsPaginator(ListEventSourceMappingsRequest.builder()
                .applyMutation(listEventSourceMappingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     * @return A Java Future containing the result of the ListFunctionEventInvokeConfigs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFunctionEventInvokeConfigsResponse> listFunctionEventInvokeConfigs(
            ListFunctionEventInvokeConfigsRequest listFunctionEventInvokeConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionEventInvokeConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionEventInvokeConfigsRequest#builder()}
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFunctionEventInvokeConfigs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFunctionEventInvokeConfigsResponse> listFunctionEventInvokeConfigs(
            Consumer<ListFunctionEventInvokeConfigsRequest.Builder> listFunctionEventInvokeConfigsRequest) {
        return listFunctionEventInvokeConfigs(ListFunctionEventInvokeConfigsRequest.builder()
                .applyMutation(listFunctionEventInvokeConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsPublisher publisher = client.listFunctionEventInvokeConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsPublisher publisher = client.listFunctionEventInvokeConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionEventInvokeConfigsPublisher listFunctionEventInvokeConfigsPaginator(
            ListFunctionEventInvokeConfigsRequest listFunctionEventInvokeConfigsRequest) {
        return new ListFunctionEventInvokeConfigsPublisher(this, listFunctionEventInvokeConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsPublisher publisher = client.listFunctionEventInvokeConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsPublisher publisher = client.listFunctionEventInvokeConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionEventInvokeConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionEventInvokeConfigsRequest#builder()}
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionEventInvokeConfigsPublisher listFunctionEventInvokeConfigsPaginator(
            Consumer<ListFunctionEventInvokeConfigsRequest.Builder> listFunctionEventInvokeConfigsRequest) {
        return listFunctionEventInvokeConfigsPaginator(ListFunctionEventInvokeConfigsRequest.builder()
                .applyMutation(listFunctionEventInvokeConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Lambda function URLs for the specified function.
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     * @return A Java Future containing the result of the ListFunctionUrlConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFunctionUrlConfigsResponse> listFunctionUrlConfigs(
            ListFunctionUrlConfigsRequest listFunctionUrlConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Lambda function URLs for the specified function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionUrlConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFunctionUrlConfigsRequest#builder()}
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListFunctionUrlConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFunctionUrlConfigsResponse> listFunctionUrlConfigs(
            Consumer<ListFunctionUrlConfigsRequest.Builder> listFunctionUrlConfigsRequest) {
        return listFunctionUrlConfigs(ListFunctionUrlConfigsRequest.builder().applyMutation(listFunctionUrlConfigsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsPublisher publisher = client.listFunctionUrlConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsPublisher publisher = client.listFunctionUrlConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFunctionUrlConfigsPublisher listFunctionUrlConfigsPaginator(
            ListFunctionUrlConfigsRequest listFunctionUrlConfigsRequest) {
        return new ListFunctionUrlConfigsPublisher(this, listFunctionUrlConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsPublisher publisher = client.listFunctionUrlConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsPublisher publisher = client.listFunctionUrlConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionUrlConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFunctionUrlConfigsRequest#builder()}
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFunctionUrlConfigsPublisher listFunctionUrlConfigsPaginator(
            Consumer<ListFunctionUrlConfigsRequest.Builder> listFunctionUrlConfigsRequest) {
        return listFunctionUrlConfigsPaginator(ListFunctionUrlConfigsRequest.builder()
                .applyMutation(listFunctionUrlConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note>
     *
     * @param listFunctionsRequest
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions(ListFunctionsRequest listFunctionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest) {
        return listFunctions(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions() {
        return listFunctions(ListFunctionsRequest.builder().build());
    }

    /**
     * <p>
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a
     * code signing configuration, to verify that no functions are using it.
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     * @return A Java Future containing the result of the ListFunctionsByCodeSigningConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFunctionsByCodeSigningConfigResponse> listFunctionsByCodeSigningConfig(
            ListFunctionsByCodeSigningConfigRequest listFunctionsByCodeSigningConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a
     * code signing configuration, to verify that no functions are using it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsByCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionsByCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFunctionsByCodeSigningConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFunctionsByCodeSigningConfigResponse> listFunctionsByCodeSigningConfig(
            Consumer<ListFunctionsByCodeSigningConfigRequest.Builder> listFunctionsByCodeSigningConfigRequest) {
        return listFunctionsByCodeSigningConfig(ListFunctionsByCodeSigningConfigRequest.builder()
                .applyMutation(listFunctionsByCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigPublisher publisher = client.listFunctionsByCodeSigningConfigPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigPublisher publisher = client.listFunctionsByCodeSigningConfigPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionsByCodeSigningConfigPublisher listFunctionsByCodeSigningConfigPaginator(
            ListFunctionsByCodeSigningConfigRequest listFunctionsByCodeSigningConfigRequest) {
        return new ListFunctionsByCodeSigningConfigPublisher(this, listFunctionsByCodeSigningConfigRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigPublisher publisher = client.listFunctionsByCodeSigningConfigPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigPublisher publisher = client.listFunctionsByCodeSigningConfigPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsByCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link ListFunctionsByCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFunctionsByCodeSigningConfigPublisher listFunctionsByCodeSigningConfigPaginator(
            Consumer<ListFunctionsByCodeSigningConfigRequest.Builder> listFunctionsByCodeSigningConfigRequest) {
        return listFunctionsByCodeSigningConfigPaginator(ListFunctionsByCodeSigningConfigRequest.builder()
                .applyMutation(listFunctionsByCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsPublisher listFunctionsPaginator() {
        return listFunctionsPaginator(ListFunctionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @param listFunctionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsPublisher listFunctionsPaginator(ListFunctionsRequest listFunctionsRequest) {
        return new ListFunctionsPublisher(this, listFunctionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListFunctionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsPublisher listFunctionsPaginator(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest) {
        return listFunctionsPaginator(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include
     * only layer versions that are compatible with that architecture.
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return A Java Future containing the result of the ListLayerVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayerVersionsResponse> listLayerVersions(ListLayerVersionsRequest listLayerVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include
     * only layer versions that are compatible with that architecture.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayerVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLayerVersionsRequest#builder()}
     * </p>
     *
     * @param listLayerVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLayerVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayerVersionsResponse> listLayerVersions(
            Consumer<ListLayerVersionsRequest.Builder> listLayerVersionsRequest) {
        return listLayerVersions(ListLayerVersionsRequest.builder().applyMutation(listLayerVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsPublisher publisher = client.listLayerVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsPublisher publisher = client.listLayerVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayerVersionsPublisher listLayerVersionsPaginator(ListLayerVersionsRequest listLayerVersionsRequest) {
        return new ListLayerVersionsPublisher(this, listLayerVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsPublisher publisher = client.listLayerVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsPublisher publisher = client.listLayerVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayerVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLayerVersionsRequest#builder()}
     * </p>
     *
     * @param listLayerVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayerVersionsPublisher listLayerVersionsPaginator(
            Consumer<ListLayerVersionsRequest.Builder> listLayerVersionsRequest) {
        return listLayerVersionsPaginator(ListLayerVersionsRequest.builder().applyMutation(listLayerVersionsRequest).build());
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     *
     * @param listLayersRequest
     * @return A Java Future containing the result of the ListLayers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayersResponse> listLayers(ListLayersRequest listLayersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayersRequest.Builder} avoiding the need to
     * create one manually via {@link ListLayersRequest#builder()}
     * </p>
     *
     * @param listLayersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListLayersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLayers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayersResponse> listLayers(Consumer<ListLayersRequest.Builder> listLayersRequest) {
        return listLayers(ListLayersRequest.builder().applyMutation(listLayersRequest).build());
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListLayers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayersResponse> listLayers() {
        return listLayers(ListLayersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersPublisher publisher = client.listLayersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersPublisher publisher = client.listLayersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListLayersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListLayersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersPublisher listLayersPaginator() {
        return listLayersPaginator(ListLayersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersPublisher publisher = client.listLayersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersPublisher publisher = client.listLayersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListLayersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListLayersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)} operation.</b>
     * </p>
     *
     * @param listLayersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersPublisher listLayersPaginator(ListLayersRequest listLayersRequest) {
        return new ListLayersPublisher(this, listLayersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersPublisher publisher = client.listLayersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersPublisher publisher = client.listLayersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListLayersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListLayersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayersRequest.Builder} avoiding the need to
     * create one manually via {@link ListLayersRequest#builder()}
     * </p>
     *
     * @param listLayersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListLayersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersPublisher listLayersPaginator(Consumer<ListLayersRequest.Builder> listLayersRequest) {
        return listLayersPaginator(ListLayersRequest.builder().applyMutation(listLayersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     * @return A Java Future containing the result of the ListProvisionedConcurrencyConfigs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisionedConcurrencyConfigsResponse> listProvisionedConcurrencyConfigs(
            ListProvisionedConcurrencyConfigsRequest listProvisionedConcurrencyConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisionedConcurrencyConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProvisionedConcurrencyConfigsRequest#builder()}
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListProvisionedConcurrencyConfigs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProvisionedConcurrencyConfigsResponse> listProvisionedConcurrencyConfigs(
            Consumer<ListProvisionedConcurrencyConfigsRequest.Builder> listProvisionedConcurrencyConfigsRequest) {
        return listProvisionedConcurrencyConfigs(ListProvisionedConcurrencyConfigsRequest.builder()
                .applyMutation(listProvisionedConcurrencyConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsPublisher publisher = client.listProvisionedConcurrencyConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsPublisher publisher = client.listProvisionedConcurrencyConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedConcurrencyConfigsPublisher listProvisionedConcurrencyConfigsPaginator(
            ListProvisionedConcurrencyConfigsRequest listProvisionedConcurrencyConfigsRequest) {
        return new ListProvisionedConcurrencyConfigsPublisher(this, listProvisionedConcurrencyConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsPublisher publisher = client.listProvisionedConcurrencyConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsPublisher publisher = client.listProvisionedConcurrencyConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProvisionedConcurrencyConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListProvisionedConcurrencyConfigsRequest#builder()}
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProvisionedConcurrencyConfigsPublisher listProvisionedConcurrencyConfigsPaginator(
            Consumer<ListProvisionedConcurrencyConfigsRequest.Builder> listProvisionedConcurrencyConfigsRequest) {
        return listProvisionedConcurrencyConfigsPaginator(ListProvisionedConcurrencyConfigsRequest.builder()
                .applyMutation(listProvisionedConcurrencyConfigsRequest).build());
    }

    /**
     * <p>
     * Returns a function, event source mapping, or code signing configuration's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also view function tags with
     * <a>GetFunction</a>.
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a function, event source mapping, or code signing configuration's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also view function tags with
     * <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return A Java Future containing the result of the ListVersionsByFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVersionsByFunctionResponse> listVersionsByFunction(
            ListVersionsByFunctionRequest listVersionsByFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsByFunctionRequest.Builder} avoiding the
     * need to create one manually via {@link ListVersionsByFunctionRequest#builder()}
     * </p>
     *
     * @param listVersionsByFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVersionsByFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVersionsByFunctionResponse> listVersionsByFunction(
            Consumer<ListVersionsByFunctionRequest.Builder> listVersionsByFunctionRequest) {
        return listVersionsByFunction(ListVersionsByFunctionRequest.builder().applyMutation(listVersionsByFunctionRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionPublisher publisher = client.listVersionsByFunctionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionPublisher publisher = client.listVersionsByFunctionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVersionsByFunctionPublisher listVersionsByFunctionPaginator(
            ListVersionsByFunctionRequest listVersionsByFunctionRequest) {
        return new ListVersionsByFunctionPublisher(this, listVersionsByFunctionRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionPublisher publisher = client.listVersionsByFunctionPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionPublisher publisher = client.listVersionsByFunctionPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsByFunctionRequest.Builder} avoiding the
     * need to create one manually via {@link ListVersionsByFunctionRequest#builder()}
     * </p>
     *
     * @param listVersionsByFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVersionsByFunctionPublisher listVersionsByFunctionPaginator(
            Consumer<ListVersionsByFunctionRequest.Builder> listVersionsByFunctionRequest) {
        return listVersionsByFunctionPaginator(ListVersionsByFunctionRequest.builder()
                .applyMutation(listVersionsByFunctionRequest).build());
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a> from
     * a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same layer name, a new version is
     * created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     *
     * @param publishLayerVersionRequest
     * @return A Java Future containing the result of the PublishLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeStorageExceededException Your Amazon Web Services account has exceeded its maximum total code
     *         size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PublishLayerVersionResponse> publishLayerVersion(
            PublishLayerVersionRequest publishLayerVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a> from
     * a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same layer name, a new version is
     * created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishLayerVersionRequest.Builder} avoiding the
     * need to create one manually via {@link PublishLayerVersionRequest#builder()}
     * </p>
     *
     * @param publishLayerVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PublishLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeStorageExceededException Your Amazon Web Services account has exceeded its maximum total code
     *         size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PublishLayerVersionResponse> publishLayerVersion(
            Consumer<PublishLayerVersionRequest.Builder> publishLayerVersionRequest) {
        return publishLayerVersion(PublishLayerVersionRequest.builder().applyMutation(publishLayerVersionRequest).build());
    }

    /**
     * <p>
     * Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
     * current code and configuration of a function. Use versions to create a snapshot of your function code and
     * configuration that doesn't change.
     * </p>
     * <p>
     * Lambda doesn't publish a version if the function's configuration and code haven't changed since the last version.
     * Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function before publishing a
     * version.
     * </p>
     * <p>
     * Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.
     * </p>
     *
     * @param publishVersionRequest
     * @return A Java Future containing the result of the PublishVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeStorageExceededException Your Amazon Web Services account has exceeded its maximum total code
     *         size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishVersionResponse> publishVersion(PublishVersionRequest publishVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
     * current code and configuration of a function. Use versions to create a snapshot of your function code and
     * configuration that doesn't change.
     * </p>
     * <p>
     * Lambda doesn't publish a version if the function's configuration and code haven't changed since the last version.
     * Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function before publishing a
     * version.
     * </p>
     * <p>
     * Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishVersionRequest.Builder} avoiding the need to
     * create one manually via {@link PublishVersionRequest#builder()}
     * </p>
     *
     * @param publishVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PublishVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PublishVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeStorageExceededException Your Amazon Web Services account has exceeded its maximum total code
     *         size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishVersionResponse> publishVersion(Consumer<PublishVersionRequest.Builder> publishVersionRequest) {
        return publishVersion(PublishVersionRequest.builder().applyMutation(publishVersionRequest).build());
    }

    /**
     * <p>
     * Update the code signing configuration for the function. Changes to the code signing configuration take effect the
     * next time a user tries to deploy a code package to the function.
     * </p>
     *
     * @param putFunctionCodeSigningConfigRequest
     * @return A Java Future containing the result of the PutFunctionCodeSigningConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutFunctionCodeSigningConfigResponse> putFunctionCodeSigningConfig(
            PutFunctionCodeSigningConfigRequest putFunctionCodeSigningConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the code signing configuration for the function. Changes to the code signing configuration take effect the
     * next time a user tries to deploy a code package to the function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFunctionCodeSigningConfigRequest.Builder}
     * avoiding the need to create one manually via {@link PutFunctionCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param putFunctionCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutFunctionCodeSigningConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutFunctionCodeSigningConfigResponse> putFunctionCodeSigningConfig(
            Consumer<PutFunctionCodeSigningConfigRequest.Builder> putFunctionCodeSigningConfigRequest) {
        return putFunctionCodeSigningConfig(PutFunctionCodeSigningConfigRequest.builder()
                .applyMutation(putFunctionCodeSigningConfigRequest).build());
    }

    /**
     * <p>
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
     * level.
     * </p>
     * <p>
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished
     * version. Reserving concurrency both ensures that your function has capacity to process the specified number of
     * events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current
     * setting for a function.
     * </p>
     * <p>
     * Use <a>GetAccountSettings</a> to see your Regional concurrency limit. You can reserve concurrency for as many
     * functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that
     * aren't configured with a per-function limit. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-scaling.html">Lambda function scaling</a>.
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     * @return A Java Future containing the result of the PutFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutFunctionConcurrencyResponse> putFunctionConcurrency(
            PutFunctionConcurrencyRequest putFunctionConcurrencyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
     * level.
     * </p>
     * <p>
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished
     * version. Reserving concurrency both ensures that your function has capacity to process the specified number of
     * events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current
     * setting for a function.
     * </p>
     * <p>
     * Use <a>GetAccountSettings</a> to see your Regional concurrency limit. You can reserve concurrency for as many
     * functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that
     * aren't configured with a per-function limit. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-scaling.html">Lambda function scaling</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFunctionConcurrencyRequest.Builder} avoiding the
     * need to create one manually via {@link PutFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutFunctionConcurrencyResponse> putFunctionConcurrency(
            Consumer<PutFunctionConcurrencyRequest.Builder> putFunctionConcurrencyRequest) {
        return putFunctionConcurrency(PutFunctionConcurrencyRequest.builder().applyMutation(putFunctionConcurrencyRequest)
                .build());
    }

    /**
     * <p>
     * Configures options for <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous
     * invocation</a> on a function, version, or alias. If a configuration already exists for a function, version, or
     * alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without
     * affecting existing settings for other options, use <a>UpdateFunctionEventInvokeConfig</a>.
     * </p>
     * <p>
     * By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events
     * in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous
     * invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with
     * <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To send an invocation record to a queue, topic, S3 bucket, function, or event bus, specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations"
     * >destination</a>. You can configure separate destinations for successful invocations (on-success) and events that
     * fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a
     * dead-letter queue.
     * </p>
     * <note>
     * <p>
     * S3 buckets are supported only for on-failure destinations. To retain records of successful invocations, use
     * another destination type.
     * </p>
     * </note>
     *
     * @param putFunctionEventInvokeConfigRequest
     * @return A Java Future containing the result of the PutFunctionEventInvokeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutFunctionEventInvokeConfigResponse> putFunctionEventInvokeConfig(
            PutFunctionEventInvokeConfigRequest putFunctionEventInvokeConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures options for <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous
     * invocation</a> on a function, version, or alias. If a configuration already exists for a function, version, or
     * alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without
     * affecting existing settings for other options, use <a>UpdateFunctionEventInvokeConfig</a>.
     * </p>
     * <p>
     * By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events
     * in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous
     * invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with
     * <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To send an invocation record to a queue, topic, S3 bucket, function, or event bus, specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations"
     * >destination</a>. You can configure separate destinations for successful invocations (on-success) and events that
     * fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a
     * dead-letter queue.
     * </p>
     * <note>
     * <p>
     * S3 buckets are supported only for on-failure destinations. To retain records of successful invocations, use
     * another destination type.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFunctionEventInvokeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link PutFunctionEventInvokeConfigRequest#builder()}
     * </p>
     *
     * @param putFunctionEventInvokeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutFunctionEventInvokeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutFunctionEventInvokeConfigResponse> putFunctionEventInvokeConfig(
            Consumer<PutFunctionEventInvokeConfigRequest.Builder> putFunctionEventInvokeConfigRequest) {
        return putFunctionEventInvokeConfig(PutFunctionEventInvokeConfigRequest.builder()
                .applyMutation(putFunctionEventInvokeConfigRequest).build());
    }

    /**
     * <p>
     * Sets your function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-recursion.html">recursive
     * loop detection</a> configuration.
     * </p>
     * <p>
     * When you configure a Lambda function to output to the same service or resource that invokes the function, it's
     * possible to create an infinite recursive loop. For example, a Lambda function might write a message to an Amazon
     * Simple Queue Service (Amazon SQS) queue, which then invokes the same function. This invocation causes the
     * function to write another message to the queue, which in turn invokes the function again.
     * </p>
     * <p>
     * Lambda can detect certain types of recursive loops shortly after they occur. When Lambda detects a recursive loop
     * and your function's recursive loop detection configuration is set to <code>Terminate</code>, it stops your
     * function being invoked and notifies you.
     * </p>
     *
     * @param putFunctionRecursionConfigRequest
     * @return A Java Future containing the result of the PutFunctionRecursionConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionRecursionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionRecursionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutFunctionRecursionConfigResponse> putFunctionRecursionConfig(
            PutFunctionRecursionConfigRequest putFunctionRecursionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets your function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-recursion.html">recursive
     * loop detection</a> configuration.
     * </p>
     * <p>
     * When you configure a Lambda function to output to the same service or resource that invokes the function, it's
     * possible to create an infinite recursive loop. For example, a Lambda function might write a message to an Amazon
     * Simple Queue Service (Amazon SQS) queue, which then invokes the same function. This invocation causes the
     * function to write another message to the queue, which in turn invokes the function again.
     * </p>
     * <p>
     * Lambda can detect certain types of recursive loops shortly after they occur. When Lambda detects a recursive loop
     * and your function's recursive loop detection configuration is set to <code>Terminate</code>, it stops your
     * function being invoked and notifies you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFunctionRecursionConfigRequest.Builder} avoiding
     * the need to create one manually via {@link PutFunctionRecursionConfigRequest#builder()}
     * </p>
     *
     * @param putFunctionRecursionConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutFunctionRecursionConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionRecursionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionRecursionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutFunctionRecursionConfigResponse> putFunctionRecursionConfig(
            Consumer<PutFunctionRecursionConfigRequest.Builder> putFunctionRecursionConfigRequest) {
        return putFunctionRecursionConfig(PutFunctionRecursionConfigRequest.builder()
                .applyMutation(putFunctionRecursionConfigRequest).build());
    }

    /**
     * <p>
     * Adds a provisioned concurrency configuration to a function's alias or version.
     * </p>
     *
     * @param putProvisionedConcurrencyConfigRequest
     * @return A Java Future containing the result of the PutProvisionedConcurrencyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutProvisionedConcurrencyConfigResponse> putProvisionedConcurrencyConfig(
            PutProvisionedConcurrencyConfigRequest putProvisionedConcurrencyConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a provisioned concurrency configuration to a function's alias or version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProvisionedConcurrencyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link PutProvisionedConcurrencyConfigRequest#builder()}
     * </p>
     *
     * @param putProvisionedConcurrencyConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutProvisionedConcurrencyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutProvisionedConcurrencyConfigResponse> putProvisionedConcurrencyConfig(
            Consumer<PutProvisionedConcurrencyConfigRequest.Builder> putProvisionedConcurrencyConfigRequest) {
        return putProvisionedConcurrencyConfig(PutProvisionedConcurrencyConfigRequest.builder()
                .applyMutation(putProvisionedConcurrencyConfigRequest).build());
    }

    /**
     * <p>
     * Sets the runtime management configuration for a function's version. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.
     * </p>
     *
     * @param putRuntimeManagementConfigRequest
     * @return A Java Future containing the result of the PutRuntimeManagementConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutRuntimeManagementConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutRuntimeManagementConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRuntimeManagementConfigResponse> putRuntimeManagementConfig(
            PutRuntimeManagementConfigRequest putRuntimeManagementConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the runtime management configuration for a function's version. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html">Runtime updates</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRuntimeManagementConfigRequest.Builder} avoiding
     * the need to create one manually via {@link PutRuntimeManagementConfigRequest#builder()}
     * </p>
     *
     * @param putRuntimeManagementConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.PutRuntimeManagementConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutRuntimeManagementConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutRuntimeManagementConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutRuntimeManagementConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRuntimeManagementConfigResponse> putRuntimeManagementConfig(
            Consumer<PutRuntimeManagementConfigRequest.Builder> putRuntimeManagementConfigRequest) {
        return putRuntimeManagementConfig(PutRuntimeManagementConfigRequest.builder()
                .applyMutation(putRuntimeManagementConfigRequest).build());
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     * @return A Java Future containing the result of the RemoveLayerVersionPermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemoveLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveLayerVersionPermissionResponse> removeLayerVersionPermission(
            RemoveLayerVersionPermissionRequest removeLayerVersionPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveLayerVersionPermissionRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveLayerVersionPermissionRequest#builder()}
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RemoveLayerVersionPermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemoveLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveLayerVersionPermissionResponse> removeLayerVersionPermission(
            Consumer<RemoveLayerVersionPermissionRequest.Builder> removeLayerVersionPermissionRequest) {
        return removeLayerVersionPermission(RemoveLayerVersionPermissionRequest.builder()
                .applyMutation(removeLayerVersionPermissionRequest).build());
    }

    /**
     * <p>
     * Revokes function-use permission from an Amazon Web Services service or another Amazon Web Services account. You
     * can get the ID of the statement from the output of <a>GetPolicy</a>.
     * </p>
     *
     * @param removePermissionRequest
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes function-use permission from an Amazon Web Services service or another Amazon Web Services account. You
     * can get the ID of the statement from the output of <a>GetPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemovePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePermissionRequest#builder()}
     * </p>
     *
     * @param removePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.RemovePermissionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(
            Consumer<RemovePermissionRequest.Builder> removePermissionRequest) {
        return removePermission(RemovePermissionRequest.builder().applyMutation(removePermissionRequest).build());
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function, event source
     * mapping, or code signing configuration.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function, event source
     * mapping, or code signing configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function, event
     * source mapping, or code signing configuration.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function, event
     * source mapping, or code signing configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     *
     * @param updateAliasRequest
     * @return A Java Future containing the result of the UpdateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAliasResponse> updateAlias(UpdateAliasRequest updateAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html">alias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAliasRequest#builder()}
     * </p>
     *
     * @param updateAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAliasResponse> updateAlias(Consumer<UpdateAliasRequest.Builder> updateAliasRequest) {
        return updateAlias(UpdateAliasRequest.builder().applyMutation(updateAliasRequest).build());
    }

    /**
     * <p>
     * Update the code signing configuration. Changes to the code signing configuration take effect the next time a user
     * tries to deploy a code package to the function.
     * </p>
     *
     * @param updateCodeSigningConfigRequest
     * @return A Java Future containing the result of the UpdateCodeSigningConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCodeSigningConfigResponse> updateCodeSigningConfig(
            UpdateCodeSigningConfigRequest updateCodeSigningConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the code signing configuration. Changes to the code signing configuration take effect the next time a user
     * tries to deploy a code package to the function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCodeSigningConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateCodeSigningConfigRequest#builder()}
     * </p>
     *
     * @param updateCodeSigningConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateCodeSigningConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCodeSigningConfigResponse> updateCodeSigningConfig(
            Consumer<UpdateCodeSigningConfigRequest.Builder> updateCodeSigningConfigRequest) {
        return updateCodeSigningConfig(UpdateCodeSigningConfigRequest.builder().applyMutation(updateCodeSigningConfigRequest)
                .build());
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume
     * later from the same location.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for DynamoDB and Kinesis event sources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For stream sources (DynamoDB, Kinesis, Amazon MSK, and self-managed Apache Kafka), the following option is also
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OnFailure</code> – Send discarded records to an Amazon SQS queue, Amazon SNS topic, or Amazon S3 bucket.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-async-retain-records.html#invocation-async-destinations"
     * >Adding a destination</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon
     * DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateEventSourceMappingRequest
     * @return A Java Future containing the result of the UpdateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         tried to update an event source mapping in the CREATING state, or you tried to delete an event source
     *         mapping currently UPDATING.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventSourceMappingResponse> updateEventSourceMapping(
            UpdateEventSourceMappingRequest updateEventSourceMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume
     * later from the same location.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html"> Amazon DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for DynamoDB and Kinesis event sources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For stream sources (DynamoDB, Kinesis, Amazon MSK, and self-managed Apache Kafka), the following option is also
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OnFailure</code> – Send discarded records to an Amazon SQS queue, Amazon SNS topic, or Amazon S3 bucket.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-async-retain-records.html#invocation-async-destinations"
     * >Adding a destination</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-documentdb.html#docdb-configuration"> Amazon
     * DocumentDB</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param updateEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         tried to update an event source mapping in the CREATING state, or you tried to delete an event source
     *         mapping currently UPDATING.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventSourceMappingResponse> updateEventSourceMapping(
            Consumer<UpdateEventSourceMappingRequest.Builder> updateEventSourceMappingRequest) {
        return updateEventSourceMapping(UpdateEventSourceMappingRequest.builder().applyMutation(updateEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by
     * a trusted publisher. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">Configuring code signing for
     * Lambda</a>.
     * </p>
     * <p>
     * If the function's package type is <code>Image</code>, then you must specify the code package in
     * <code>ImageUri</code> as the URI of a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR
     * registry.
     * </p>
     * <p>
     * If the function's package type is <code>Zip</code>, then you must specify the deployment package as a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>. Enter the Amazon S3 bucket and key of the code .zip file location. You can also provide the
     * function code inline using the <code>ZipFile</code> field.
     * </p>
     * <p>
     * The code in the deployment package must be compatible with the target instruction set architecture of the
     * function (<code>x86-64</code> or <code>arm64</code>).
     * </p>
     * <p>
     * The function's code is locked when you publish a version. You can't modify the code of a published version, only
     * the unpublished version.
     * </p>
     * <note>
     * <p>
     * For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if
     * you update the image tag to a new image, Lambda does not automatically update the function.
     * </p>
     * </note>
     *
     * @param updateFunctionCodeRequest
     * @return A Java Future containing the result of the UpdateFunctionCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>InvalidCodeSignatureException The code signature failed the integrity check. If the integrity check
     *         fails, then Lambda blocks deployment, even if the code signing policy is set to WARN.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeVerificationFailedException The code signature failed one or more of the validation checks for
     *         signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the
     *         deployment.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>CodeStorageExceededException Your Amazon Web Services account has exceeded its maximum total code
     *         size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFunctionCodeResponse> updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by
     * a trusted publisher. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">Configuring code signing for
     * Lambda</a>.
     * </p>
     * <p>
     * If the function's package type is <code>Image</code>, then you must specify the code package in
     * <code>ImageUri</code> as the URI of a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR
     * registry.
     * </p>
     * <p>
     * If the function's package type is <code>Zip</code>, then you must specify the deployment package as a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>. Enter the Amazon S3 bucket and key of the code .zip file location. You can also provide the
     * function code inline using the <code>ZipFile</code> field.
     * </p>
     * <p>
     * The code in the deployment package must be compatible with the target instruction set architecture of the
     * function (<code>x86-64</code> or <code>arm64</code>).
     * </p>
     * <p>
     * The function's code is locked when you publish a version. You can't modify the code of a published version, only
     * the unpublished version.
     * </p>
     * <note>
     * <p>
     * For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if
     * you update the image tag to a new image, Lambda does not automatically update the function.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionCodeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFunctionCodeRequest#builder()}
     * </p>
     *
     * @param updateFunctionCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFunctionCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>InvalidCodeSignatureException The code signature failed the integrity check. If the integrity check
     *         fails, then Lambda blocks deployment, even if the code signing policy is set to WARN.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeVerificationFailedException The code signature failed one or more of the validation checks for
     *         signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the
     *         deployment.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>CodeStorageExceededException Your Amazon Web Services account has exceeded its maximum total code
     *         size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFunctionCodeResponse> updateFunctionCode(
            Consumer<UpdateFunctionCodeRequest.Builder> updateFunctionCodeRequest) {
        return updateFunctionCode(UpdateFunctionCodeRequest.builder().applyMutation(updateFunctionCodeRequest).build());
    }

    /**
     * <p>
     * Modify the version-specific settings of a Lambda function.
     * </p>
     * <p>
     * When you update a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but
     * you can still invoke it. The <code>LastUpdateStatus</code>, <code>LastUpdateStatusReason</code>, and
     * <code>LastUpdateStatusReasonCode</code> fields in the response from <a>GetFunctionConfiguration</a> indicate when
     * the update is complete and the function is processing events with the new configuration. For more information,
     * see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function states</a>.
     * </p>
     * <p>
     * These settings can vary between versions of a function and are locked when you publish a version. You can't
     * modify the configuration of a published version, only the unpublished version.
     * </p>
     * <p>
     * To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an Amazon
     * Web Services account or Amazon Web Services service, use <a>AddPermission</a>.
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     * @return A Java Future containing the result of the UpdateFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>InvalidCodeSignatureException The code signature failed the integrity check. If the integrity check
     *         fails, then Lambda blocks deployment, even if the code signing policy is set to WARN.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeVerificationFailedException The code signature failed one or more of the validation checks for
     *         signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the
     *         deployment.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionConfigurationResponse> updateFunctionConfiguration(
            UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modify the version-specific settings of a Lambda function.
     * </p>
     * <p>
     * When you update a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but
     * you can still invoke it. The <code>LastUpdateStatus</code>, <code>LastUpdateStatusReason</code>, and
     * <code>LastUpdateStatusReasonCode</code> fields in the response from <a>GetFunctionConfiguration</a> indicate when
     * the update is complete and the function is processing events with the new configuration. For more information,
     * see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function states</a>.
     * </p>
     * <p>
     * These settings can vary between versions of a function and are locked when you publish a version. You can't
     * modify the configuration of a published version, only the unpublished version.
     * </p>
     * <p>
     * To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an Amazon
     * Web Services account or Amazon Web Services service, use <a>AddPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFunctionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>InvalidCodeSignatureException The code signature failed the integrity check. If the integrity check
     *         fails, then Lambda blocks deployment, even if the code signing policy is set to WARN.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>CodeVerificationFailedException The code signature failed one or more of the validation checks for
     *         signature mismatch or expiry, and the code signing policy is set to ENFORCE. Lambda blocks the
     *         deployment.</li>
     *         <li>CodeSigningConfigNotFoundException The specified code signing configuration does not exist.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>For AddPermission and RemovePermission API operations:</b> Call <code>GetPolicy</code> to retrieve the
     *         latest RevisionId for your resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>For all other API operations:</b> Call <code>GetFunction</code> or <code>GetAlias</code> to retrieve
     *         the latest RevisionId for your resource.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionConfigurationResponse> updateFunctionConfiguration(
            Consumer<UpdateFunctionConfigurationRequest.Builder> updateFunctionConfigurationRequest) {
        return updateFunctionConfiguration(UpdateFunctionConfigurationRequest.builder()
                .applyMutation(updateFunctionConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param updateFunctionEventInvokeConfigRequest
     * @return A Java Future containing the result of the UpdateFunctionEventInvokeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionEventInvokeConfigResponse> updateFunctionEventInvokeConfig(
            UpdateFunctionEventInvokeConfigRequest updateFunctionEventInvokeConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionEventInvokeConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFunctionEventInvokeConfigRequest#builder()}
     * </p>
     *
     * @param updateFunctionEventInvokeConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateFunctionEventInvokeConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionEventInvokeConfigResponse> updateFunctionEventInvokeConfig(
            Consumer<UpdateFunctionEventInvokeConfigRequest.Builder> updateFunctionEventInvokeConfigRequest) {
        return updateFunctionEventInvokeConfig(UpdateFunctionEventInvokeConfigRequest.builder()
                .applyMutation(updateFunctionEventInvokeConfigRequest).build());
    }

    /**
     * <p>
     * Updates the configuration for a Lambda function URL.
     * </p>
     *
     * @param updateFunctionUrlConfigRequest
     * @return A Java Future containing the result of the UpdateFunctionUrlConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionUrlConfigResponse> updateFunctionUrlConfig(
            UpdateFunctionUrlConfigRequest updateFunctionUrlConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for a Lambda function URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionUrlConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateFunctionUrlConfigRequest#builder()}
     * </p>
     *
     * @param updateFunctionUrlConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFunctionUrlConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One of the parameters in the request is not valid.</li>
     *         <li>ResourceConflictException The resource already exists, or another operation is in progress.</li>
     *         <li>ServiceException The Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.</li>
     *         <li>ResourceNotFoundException The resource specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionUrlConfigResponse> updateFunctionUrlConfig(
            Consumer<UpdateFunctionUrlConfigRequest.Builder> updateFunctionUrlConfigRequest) {
        return updateFunctionUrlConfig(UpdateFunctionUrlConfigRequest.builder().applyMutation(updateFunctionUrlConfigRequest)
                .build());
    }

    /**
     * Create an instance of {@link LambdaAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link LambdaAsyncWaiter}
     */
    default LambdaAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default LambdaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link LambdaAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LambdaAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LambdaAsyncClient}.
     */
    static LambdaAsyncClientBuilder builder() {
        return new DefaultLambdaAsyncClientBuilder();
    }
}
