/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventSourceMappingRequest extends LambdaRequest implements
        ToCopyableBuilder<UpdateEventSourceMappingRequest.Builder, UpdateEventSourceMappingRequest> {
    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UUID")
            .getter(getter(UpdateEventSourceMappingRequest::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UUID").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(UpdateEventSourceMappingRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(UpdateEventSourceMappingRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(UpdateEventSourceMappingRequest::batchSize))
            .setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<FilterCriteria> builder(MarshallingType.SDK_POJO).memberName("FilterCriteria")
            .getter(getter(UpdateEventSourceMappingRequest::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(FilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBatchingWindowInSeconds")
            .getter(getter(UpdateEventSourceMappingRequest::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("DestinationConfig")
            .getter(getter(UpdateEventSourceMappingRequest::destinationConfig)).setter(setter(Builder::destinationConfig))
            .constructor(DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()).build();

    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds")
            .getter(getter(UpdateEventSourceMappingRequest::maximumRecordAgeInSeconds))
            .setter(setter(Builder::maximumRecordAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build())
            .build();

    private static final SdkField<Boolean> BISECT_BATCH_ON_FUNCTION_ERROR_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BisectBatchOnFunctionError")
            .getter(getter(UpdateEventSourceMappingRequest::bisectBatchOnFunctionError))
            .setter(setter(Builder::bisectBatchOnFunctionError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BisectBatchOnFunctionError").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumRetryAttempts").getter(getter(UpdateEventSourceMappingRequest::maximumRetryAttempts))
            .setter(setter(Builder::maximumRetryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build())
            .build();

    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParallelizationFactor").getter(getter(UpdateEventSourceMappingRequest::parallelizationFactor))
            .setter(setter(Builder::parallelizationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build())
            .build();

    private static final SdkField<List<SourceAccessConfiguration>> SOURCE_ACCESS_CONFIGURATIONS_FIELD = SdkField
            .<List<SourceAccessConfiguration>> builder(MarshallingType.LIST)
            .memberName("SourceAccessConfigurations")
            .getter(getter(UpdateEventSourceMappingRequest::sourceAccessConfigurations))
            .setter(setter(Builder::sourceAccessConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccessConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceAccessConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceAccessConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TUMBLING_WINDOW_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TumblingWindowInSeconds").getter(getter(UpdateEventSourceMappingRequest::tumblingWindowInSeconds))
            .setter(setter(Builder::tumblingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TumblingWindowInSeconds").build())
            .build();

    private static final SdkField<List<String>> FUNCTION_RESPONSE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FunctionResponseTypes")
            .getter(getter(UpdateEventSourceMappingRequest::functionResponseTypesAsStrings))
            .setter(setter(Builder::functionResponseTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionResponseTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ScalingConfig> SCALING_CONFIG_FIELD = SdkField
            .<ScalingConfig> builder(MarshallingType.SDK_POJO).memberName("ScalingConfig")
            .getter(getter(UpdateEventSourceMappingRequest::scalingConfig)).setter(setter(Builder::scalingConfig))
            .constructor(ScalingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfig").build()).build();

    private static final SdkField<AmazonManagedKafkaEventSourceConfig> AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD = SdkField
            .<AmazonManagedKafkaEventSourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("AmazonManagedKafkaEventSourceConfig")
            .getter(getter(UpdateEventSourceMappingRequest::amazonManagedKafkaEventSourceConfig))
            .setter(setter(Builder::amazonManagedKafkaEventSourceConfig))
            .constructor(AmazonManagedKafkaEventSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AmazonManagedKafkaEventSourceConfig").build()).build();

    private static final SdkField<SelfManagedKafkaEventSourceConfig> SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD = SdkField
            .<SelfManagedKafkaEventSourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("SelfManagedKafkaEventSourceConfig")
            .getter(getter(UpdateEventSourceMappingRequest::selfManagedKafkaEventSourceConfig))
            .setter(setter(Builder::selfManagedKafkaEventSourceConfig))
            .constructor(SelfManagedKafkaEventSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedKafkaEventSourceConfig")
                    .build()).build();

    private static final SdkField<DocumentDBEventSourceConfig> DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD = SdkField
            .<DocumentDBEventSourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DocumentDBEventSourceConfig")
            .getter(getter(UpdateEventSourceMappingRequest::documentDBEventSourceConfig))
            .setter(setter(Builder::documentDBEventSourceConfig))
            .constructor(DocumentDBEventSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDBEventSourceConfig")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyArn").getter(getter(UpdateEventSourceMappingRequest::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()).build();

    private static final SdkField<EventSourceMappingMetricsConfig> METRICS_CONFIG_FIELD = SdkField
            .<EventSourceMappingMetricsConfig> builder(MarshallingType.SDK_POJO).memberName("MetricsConfig")
            .getter(getter(UpdateEventSourceMappingRequest::metricsConfig)).setter(setter(Builder::metricsConfig))
            .constructor(EventSourceMappingMetricsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsConfig").build()).build();

    private static final SdkField<ProvisionedPollerConfig> PROVISIONED_POLLER_CONFIG_FIELD = SdkField
            .<ProvisionedPollerConfig> builder(MarshallingType.SDK_POJO).memberName("ProvisionedPollerConfig")
            .getter(getter(UpdateEventSourceMappingRequest::provisionedPollerConfig))
            .setter(setter(Builder::provisionedPollerConfig)).constructor(ProvisionedPollerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedPollerConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD,
            FUNCTION_NAME_FIELD, ENABLED_FIELD, BATCH_SIZE_FIELD, FILTER_CRITERIA_FIELD,
            MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, DESTINATION_CONFIG_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD,
            BISECT_BATCH_ON_FUNCTION_ERROR_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, PARALLELIZATION_FACTOR_FIELD,
            SOURCE_ACCESS_CONFIGURATIONS_FIELD, TUMBLING_WINDOW_IN_SECONDS_FIELD, FUNCTION_RESPONSE_TYPES_FIELD,
            SCALING_CONFIG_FIELD, AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD, SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD,
            DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD, KMS_KEY_ARN_FIELD, METRICS_CONFIG_FIELD, PROVISIONED_POLLER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String uuid;

    private final String functionName;

    private final Boolean enabled;

    private final Integer batchSize;

    private final FilterCriteria filterCriteria;

    private final Integer maximumBatchingWindowInSeconds;

    private final DestinationConfig destinationConfig;

    private final Integer maximumRecordAgeInSeconds;

    private final Boolean bisectBatchOnFunctionError;

    private final Integer maximumRetryAttempts;

    private final Integer parallelizationFactor;

    private final List<SourceAccessConfiguration> sourceAccessConfigurations;

    private final Integer tumblingWindowInSeconds;

    private final List<String> functionResponseTypes;

    private final ScalingConfig scalingConfig;

    private final AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig;

    private final SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig;

    private final DocumentDBEventSourceConfig documentDBEventSourceConfig;

    private final String kmsKeyArn;

    private final EventSourceMappingMetricsConfig metricsConfig;

    private final ProvisionedPollerConfig provisionedPollerConfig;

    private UpdateEventSourceMappingRequest(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.functionName = builder.functionName;
        this.enabled = builder.enabled;
        this.batchSize = builder.batchSize;
        this.filterCriteria = builder.filterCriteria;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.destinationConfig = builder.destinationConfig;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.parallelizationFactor = builder.parallelizationFactor;
        this.sourceAccessConfigurations = builder.sourceAccessConfigurations;
        this.tumblingWindowInSeconds = builder.tumblingWindowInSeconds;
        this.functionResponseTypes = builder.functionResponseTypes;
        this.scalingConfig = builder.scalingConfig;
        this.amazonManagedKafkaEventSourceConfig = builder.amazonManagedKafkaEventSourceConfig;
        this.selfManagedKafkaEventSourceConfig = builder.selfManagedKafkaEventSourceConfig;
        this.documentDBEventSourceConfig = builder.documentDBEventSourceConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.metricsConfig = builder.metricsConfig;
        this.provisionedPollerConfig = builder.provisionedPollerConfig;
    }

    /**
     * <p>
     * The identifier of the event source mapping.
     * </p>
     * 
     * @return The identifier of the event source mapping.
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The name or ARN of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> – <code>MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Version or Alias ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> – <code>123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name or ARN of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> – <code>MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Version or Alias ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> – <code>123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it's limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
     * </p>
     * <p>
     * Default: True
     * </p>
     * 
     * @return When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
     *         <p>
     *         Default: True
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your
     * function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit
     * for synchronous invocation (6 MB).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon Kinesis</b> – Default 100. Max 10,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon DynamoDB Streams</b> – Default 100. Max 10,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon Simple Queue Service</b> – Default 10. For standard queues the max is 10,000. For FIFO queues the max
     * is 10.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon Managed Streaming for Apache Kafka</b> – Default 100. Max 10,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Self-managed Apache Kafka</b> – Default 100. Max 10,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> – Default 100. Max 10,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>DocumentDB</b> – Default 100. Max 10,000.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your
     *         function. Lambda passes all of the records in the batch to the function in a single call, up to the
     *         payload limit for synchronous invocation (6 MB).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Amazon Kinesis</b> – Default 100. Max 10,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon DynamoDB Streams</b> – Default 100. Max 10,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon Simple Queue Service</b> – Default 10. For standard queues the max is 10,000. For FIFO queues
     *         the max is 10.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon Managed Streaming for Apache Kafka</b> – Default 100. Max 10,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Self-managed Apache Kafka</b> – Default 100. Max 10,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> – Default 100. Max 10,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DocumentDB</b> – Default 100. Max 10,000.
     *         </p>
     *         </li>
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * An object that defines the filter criteria that determine whether Lambda should process an event. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda
     * event filtering</a>.
     * </p>
     * 
     * @return An object that defines the filter criteria that determine whether Lambda should process an event. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event
     *         filtering</a>.
     */
    public final FilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function. You
     * can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to 300 seconds in
     * increments of seconds.
     * </p>
     * <p>
     * For Kinesis, DynamoDB, and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon MSK,
     * Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is 500 ms. Note
     * that because you can only change <code>MaximumBatchingWindowInSeconds</code> in increments of seconds, you cannot
     * revert back to the 500 ms default batching window after you have changed it. To restore the default batching
     * window, you must create a new event source mapping.
     * </p>
     * <p>
     * Related setting: For Kinesis, DynamoDB, and Amazon SQS event sources, when you set <code>BatchSize</code> to a
     * value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.
     * </p>
     * 
     * @return The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the
     *         function. You can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to
     *         300 seconds in increments of seconds.</p>
     *         <p>
     *         For Kinesis, DynamoDB, and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon
     *         MSK, Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is
     *         500 ms. Note that because you can only change <code>MaximumBatchingWindowInSeconds</code> in increments
     *         of seconds, you cannot revert back to the 500 ms default batching window after you have changed it. To
     *         restore the default batching window, you must create a new event source mapping.
     *         </p>
     *         <p>
     *         Related setting: For Kinesis, DynamoDB, and Amazon SQS event sources, when you set <code>BatchSize</code>
     *         to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.
     */
    public final Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A configuration object that specifies the
     * destination of an event after Lambda processes it.
     * </p>
     * 
     * @return (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A configuration object that
     *         specifies the destination of an event after Lambda processes it.
     */
    public final DestinationConfig destinationConfig() {
        return destinationConfig;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is infinite
     * (-1).
     * </p>
     * 
     * @return (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is
     *         infinite (-1).
     */
    public final Integer maximumRecordAgeInSeconds() {
        return maximumRecordAgeInSeconds;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry.
     * </p>
     * 
     * @return (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry.
     */
    public final Boolean bisectBatchOnFunctionError() {
        return bisectBatchOnFunctionError;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * 
     * @return (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default
     *         value is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     */
    public final Integer maximumRetryAttempts() {
        return maximumRetryAttempts;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) The number of batches to process from each shard concurrently.
     * </p>
     * 
     * @return (Kinesis and DynamoDB Streams only) The number of batches to process from each shard concurrently.
     */
    public final Integer parallelizationFactor() {
        return parallelizationFactor;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAccessConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceAccessConfigurations() {
        return sourceAccessConfigurations != null && !(sourceAccessConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of authentication protocols or VPC components required to secure your event source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAccessConfigurations} method.
     * </p>
     * 
     * @return An array of authentication protocols or VPC components required to secure your event source.
     */
    public final List<SourceAccessConfiguration> sourceAccessConfigurations() {
        return sourceAccessConfigurations;
    }

    /**
     * <p>
     * (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis
     * Streams event sources. A value of 0 seconds indicates no tumbling window.
     * </p>
     * 
     * @return (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and
     *         Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.
     */
    public final Integer tumblingWindowInSeconds() {
        return tumblingWindowInSeconds;
    }

    /**
     * <p>
     * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
     * mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionResponseTypes} method.
     * </p>
     * 
     * @return (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
     *         source mapping.
     */
    public final List<FunctionResponseType> functionResponseTypes() {
        return FunctionResponseTypeListCopier.copyStringToEnum(functionResponseTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionResponseTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFunctionResponseTypes() {
        return functionResponseTypes != null && !(functionResponseTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
     * mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionResponseTypes} method.
     * </p>
     * 
     * @return (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
     *         source mapping.
     */
    public final List<String> functionResponseTypesAsStrings() {
        return functionResponseTypes;
    }

    /**
     * <p>
     * (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring maximum
     * concurrency for Amazon SQS event sources</a>.
     * </p>
     * 
     * @return (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring
     *         maximum concurrency for Amazon SQS event sources</a>.
     */
    public final ScalingConfig scalingConfig() {
        return scalingConfig;
    }

    /**
     * Returns the value of the AmazonManagedKafkaEventSourceConfig property for this object.
     * 
     * @return The value of the AmazonManagedKafkaEventSourceConfig property for this object.
     */
    public final AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig() {
        return amazonManagedKafkaEventSourceConfig;
    }

    /**
     * Returns the value of the SelfManagedKafkaEventSourceConfig property for this object.
     * 
     * @return The value of the SelfManagedKafkaEventSourceConfig property for this object.
     */
    public final SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig() {
        return selfManagedKafkaEventSourceConfig;
    }

    /**
     * <p>
     * Specific configuration settings for a DocumentDB event source.
     * </p>
     * 
     * @return Specific configuration settings for a DocumentDB event source.
     */
    public final DocumentDBEventSourceConfig documentDBEventSourceConfig() {
        return documentDBEventSourceConfig;
    }

    /**
     * <p>
     * The ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics">filter
     * criteria</a>. By default, Lambda does not encrypt your filter criteria object. Specify this property to encrypt
     * data using your own customer managed key.
     * </p>
     * 
     * @return The ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your
     *         function's <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics"
     *         >filter criteria</a>. By default, Lambda does not encrypt your filter criteria object. Specify this
     *         property to encrypt data using your own customer managed key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The metrics configuration for your event source. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
     * >Event source mapping metrics</a>.
     * </p>
     * 
     * @return The metrics configuration for your event source. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
     *         >Event source mapping metrics</a>.
     */
    public final EventSourceMappingMetricsConfig metricsConfig() {
        return metricsConfig;
    }

    /**
     * <p>
     * (Amazon SQS, Amazon MSK, and self-managed Apache Kafka only) The provisioned mode configuration for the event
     * source. For more information, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
     * >provisioned mode</a>.
     * </p>
     * 
     * @return (Amazon SQS, Amazon MSK, and self-managed Apache Kafka only) The provisioned mode configuration for the
     *         event source. For more information, see <a href=
     *         "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
     *         >provisioned mode</a>.
     */
    public final ProvisionedPollerConfig provisionedPollerConfig() {
        return provisionedPollerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(bisectBatchOnFunctionError());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(parallelizationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAccessConfigurations() ? sourceAccessConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tumblingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionResponseTypes() ? functionResponseTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(amazonManagedKafkaEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedKafkaEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(documentDBEventSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedPollerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventSourceMappingRequest)) {
            return false;
        }
        UpdateEventSourceMappingRequest other = (UpdateEventSourceMappingRequest) obj;
        return Objects.equals(uuid(), other.uuid()) && Objects.equals(functionName(), other.functionName())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(batchSize(), other.batchSize())
                && Objects.equals(filterCriteria(), other.filterCriteria())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds())
                && Objects.equals(destinationConfig(), other.destinationConfig())
                && Objects.equals(maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds())
                && Objects.equals(bisectBatchOnFunctionError(), other.bisectBatchOnFunctionError())
                && Objects.equals(maximumRetryAttempts(), other.maximumRetryAttempts())
                && Objects.equals(parallelizationFactor(), other.parallelizationFactor())
                && hasSourceAccessConfigurations() == other.hasSourceAccessConfigurations()
                && Objects.equals(sourceAccessConfigurations(), other.sourceAccessConfigurations())
                && Objects.equals(tumblingWindowInSeconds(), other.tumblingWindowInSeconds())
                && hasFunctionResponseTypes() == other.hasFunctionResponseTypes()
                && Objects.equals(functionResponseTypesAsStrings(), other.functionResponseTypesAsStrings())
                && Objects.equals(scalingConfig(), other.scalingConfig())
                && Objects.equals(amazonManagedKafkaEventSourceConfig(), other.amazonManagedKafkaEventSourceConfig())
                && Objects.equals(selfManagedKafkaEventSourceConfig(), other.selfManagedKafkaEventSourceConfig())
                && Objects.equals(documentDBEventSourceConfig(), other.documentDBEventSourceConfig())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(metricsConfig(), other.metricsConfig())
                && Objects.equals(provisionedPollerConfig(), other.provisionedPollerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEventSourceMappingRequest").add("UUID", uuid()).add("FunctionName", functionName())
                .add("Enabled", enabled()).add("BatchSize", batchSize()).add("FilterCriteria", filterCriteria())
                .add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds())
                .add("DestinationConfig", destinationConfig()).add("MaximumRecordAgeInSeconds", maximumRecordAgeInSeconds())
                .add("BisectBatchOnFunctionError", bisectBatchOnFunctionError())
                .add("MaximumRetryAttempts", maximumRetryAttempts()).add("ParallelizationFactor", parallelizationFactor())
                .add("SourceAccessConfigurations", hasSourceAccessConfigurations() ? sourceAccessConfigurations() : null)
                .add("TumblingWindowInSeconds", tumblingWindowInSeconds())
                .add("FunctionResponseTypes", hasFunctionResponseTypes() ? functionResponseTypesAsStrings() : null)
                .add("ScalingConfig", scalingConfig())
                .add("AmazonManagedKafkaEventSourceConfig", amazonManagedKafkaEventSourceConfig())
                .add("SelfManagedKafkaEventSourceConfig", selfManagedKafkaEventSourceConfig())
                .add("DocumentDBEventSourceConfig", documentDBEventSourceConfig()).add("KMSKeyArn", kmsKeyArn())
                .add("MetricsConfig", metricsConfig()).add("ProvisionedPollerConfig", provisionedPollerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UUID":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "FilterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        case "DestinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        case "MaximumRecordAgeInSeconds":
            return Optional.ofNullable(clazz.cast(maximumRecordAgeInSeconds()));
        case "BisectBatchOnFunctionError":
            return Optional.ofNullable(clazz.cast(bisectBatchOnFunctionError()));
        case "MaximumRetryAttempts":
            return Optional.ofNullable(clazz.cast(maximumRetryAttempts()));
        case "ParallelizationFactor":
            return Optional.ofNullable(clazz.cast(parallelizationFactor()));
        case "SourceAccessConfigurations":
            return Optional.ofNullable(clazz.cast(sourceAccessConfigurations()));
        case "TumblingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(tumblingWindowInSeconds()));
        case "FunctionResponseTypes":
            return Optional.ofNullable(clazz.cast(functionResponseTypesAsStrings()));
        case "ScalingConfig":
            return Optional.ofNullable(clazz.cast(scalingConfig()));
        case "AmazonManagedKafkaEventSourceConfig":
            return Optional.ofNullable(clazz.cast(amazonManagedKafkaEventSourceConfig()));
        case "SelfManagedKafkaEventSourceConfig":
            return Optional.ofNullable(clazz.cast(selfManagedKafkaEventSourceConfig()));
        case "DocumentDBEventSourceConfig":
            return Optional.ofNullable(clazz.cast(documentDBEventSourceConfig()));
        case "KMSKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "MetricsConfig":
            return Optional.ofNullable(clazz.cast(metricsConfig()));
        case "ProvisionedPollerConfig":
            return Optional.ofNullable(clazz.cast(provisionedPollerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UUID", UUID_FIELD);
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("BatchSize", BATCH_SIZE_FIELD);
        map.put("FilterCriteria", FILTER_CRITERIA_FIELD);
        map.put("MaximumBatchingWindowInSeconds", MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD);
        map.put("DestinationConfig", DESTINATION_CONFIG_FIELD);
        map.put("MaximumRecordAgeInSeconds", MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD);
        map.put("BisectBatchOnFunctionError", BISECT_BATCH_ON_FUNCTION_ERROR_FIELD);
        map.put("MaximumRetryAttempts", MAXIMUM_RETRY_ATTEMPTS_FIELD);
        map.put("ParallelizationFactor", PARALLELIZATION_FACTOR_FIELD);
        map.put("SourceAccessConfigurations", SOURCE_ACCESS_CONFIGURATIONS_FIELD);
        map.put("TumblingWindowInSeconds", TUMBLING_WINDOW_IN_SECONDS_FIELD);
        map.put("FunctionResponseTypes", FUNCTION_RESPONSE_TYPES_FIELD);
        map.put("ScalingConfig", SCALING_CONFIG_FIELD);
        map.put("AmazonManagedKafkaEventSourceConfig", AMAZON_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD);
        map.put("SelfManagedKafkaEventSourceConfig", SELF_MANAGED_KAFKA_EVENT_SOURCE_CONFIG_FIELD);
        map.put("DocumentDBEventSourceConfig", DOCUMENT_DB_EVENT_SOURCE_CONFIG_FIELD);
        map.put("KMSKeyArn", KMS_KEY_ARN_FIELD);
        map.put("MetricsConfig", METRICS_CONFIG_FIELD);
        map.put("ProvisionedPollerConfig", PROVISIONED_POLLER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventSourceMappingRequest, T> g) {
        return obj -> g.apply((UpdateEventSourceMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEventSourceMappingRequest> {
        /**
         * <p>
         * The identifier of the event source mapping.
         * </p>
         * 
         * @param uuid
         *        The identifier of the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The name or ARN of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> – <code>MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Version or Alias ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> – <code>123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
         * characters in length.
         * </p>
         * 
         * @param functionName
         *        The name or ARN of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> – <code>MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Version or Alias ARN</b> –
         *        <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> – <code>123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it's
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
         * </p>
         * <p>
         * Default: True
         * </p>
         * 
         * @param enabled
         *        When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
         *        <p>
         *        Default: True
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your
         * function. Lambda passes all of the records in the batch to the function in a single call, up to the payload
         * limit for synchronous invocation (6 MB).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Amazon Kinesis</b> – Default 100. Max 10,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon DynamoDB Streams</b> – Default 100. Max 10,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon Simple Queue Service</b> – Default 10. For standard queues the max is 10,000. For FIFO queues the
         * max is 10.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon Managed Streaming for Apache Kafka</b> – Default 100. Max 10,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Self-managed Apache Kafka</b> – Default 100. Max 10,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> – Default 100. Max 10,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>DocumentDB</b> – Default 100. Max 10,000.
         * </p>
         * </li>
         * </ul>
         * 
         * @param batchSize
         *        The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to
         *        your function. Lambda passes all of the records in the batch to the function in a single call, up to
         *        the payload limit for synchronous invocation (6 MB).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Amazon Kinesis</b> – Default 100. Max 10,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon DynamoDB Streams</b> – Default 100. Max 10,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon Simple Queue Service</b> – Default 10. For standard queues the max is 10,000. For FIFO
         *        queues the max is 10.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon Managed Streaming for Apache Kafka</b> – Default 100. Max 10,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Self-managed Apache Kafka</b> – Default 100. Max 10,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon MQ (ActiveMQ and RabbitMQ)</b> – Default 100. Max 10,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DocumentDB</b> – Default 100. Max 10,000.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * An object that defines the filter criteria that determine whether Lambda should process an event. For more
         * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda
         * event filtering</a>.
         * </p>
         * 
         * @param filterCriteria
         *        An object that defines the filter criteria that determine whether Lambda should process an event. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event
         *        filtering</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(FilterCriteria filterCriteria);

        /**
         * <p>
         * An object that defines the filter criteria that determine whether Lambda should process an event. For more
         * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda
         * event filtering</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCriteria.Builder} avoiding the need
         * to create one manually via {@link FilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #filterCriteria(FilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link FilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(FilterCriteria)
         */
        default Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return filterCriteria(FilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
         * You can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to 300 seconds in
         * increments of seconds.
         * </p>
         * <p>
         * For Kinesis, DynamoDB, and Amazon SQS event sources, the default batching window is 0 seconds. For Amazon
         * MSK, Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching window is 500
         * ms. Note that because you can only change <code>MaximumBatchingWindowInSeconds</code> in increments of
         * seconds, you cannot revert back to the 500 ms default batching window after you have changed it. To restore
         * the default batching window, you must create a new event source mapping.
         * </p>
         * <p>
         * Related setting: For Kinesis, DynamoDB, and Amazon SQS event sources, when you set <code>BatchSize</code> to
         * a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the
         *        function. You can configure <code>MaximumBatchingWindowInSeconds</code> to any value from 0 seconds to
         *        300 seconds in increments of seconds.</p>
         *        <p>
         *        For Kinesis, DynamoDB, and Amazon SQS event sources, the default batching window is 0 seconds. For
         *        Amazon MSK, Self-managed Apache Kafka, Amazon MQ, and DocumentDB event sources, the default batching
         *        window is 500 ms. Note that because you can only change <code>MaximumBatchingWindowInSeconds</code> in
         *        increments of seconds, you cannot revert back to the 500 ms default batching window after you have
         *        changed it. To restore the default batching window, you must create a new event source mapping.
         *        </p>
         *        <p>
         *        Related setting: For Kinesis, DynamoDB, and Amazon SQS event sources, when you set
         *        <code>BatchSize</code> to a value greater than 10, you must set
         *        <code>MaximumBatchingWindowInSeconds</code> to at least 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A configuration object that specifies
         * the destination of an event after Lambda processes it.
         * </p>
         * 
         * @param destinationConfig
         *        (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A configuration object that
         *        specifies the destination of an event after Lambda processes it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(DestinationConfig destinationConfig);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka only) A configuration object that specifies
         * the destination of an event after Lambda processes it.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationConfig.Builder} avoiding the
         * need to create one manually via {@link DestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConfig(DestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(DestinationConfig)
         */
        default Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return destinationConfig(DestinationConfig.builder().applyMutation(destinationConfig).build());
        }

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is
         * infinite (-1).
         * </p>
         * 
         * @param maximumRecordAgeInSeconds
         *        (Kinesis and DynamoDB Streams only) Discard records older than the specified age. The default value is
         *        infinite (-1).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds);

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry.
         * </p>
         * 
         * @param bisectBatchOnFunctionError
         *        (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and
         *        retry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError);

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default value
         * is infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
         * </p>
         * 
         * @param maximumRetryAttempts
         *        (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries. The default
         *        value is infinite (-1). When set to infinite (-1), failed records are retried until the record
         *        expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetryAttempts(Integer maximumRetryAttempts);

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) The number of batches to process from each shard concurrently.
         * </p>
         * 
         * @param parallelizationFactor
         *        (Kinesis and DynamoDB Streams only) The number of batches to process from each shard concurrently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelizationFactor(Integer parallelizationFactor);

        /**
         * <p>
         * An array of authentication protocols or VPC components required to secure your event source.
         * </p>
         * 
         * @param sourceAccessConfigurations
         *        An array of authentication protocols or VPC components required to secure your event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> sourceAccessConfigurations);

        /**
         * <p>
         * An array of authentication protocols or VPC components required to secure your event source.
         * </p>
         * 
         * @param sourceAccessConfigurations
         *        An array of authentication protocols or VPC components required to secure your event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccessConfigurations(SourceAccessConfiguration... sourceAccessConfigurations);

        /**
         * <p>
         * An array of authentication protocols or VPC components required to secure your event source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAccessConfigurations(List<SourceAccessConfiguration>)}.
         * 
         * @param sourceAccessConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAccessConfigurations(java.util.Collection<SourceAccessConfiguration>)
         */
        Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder>... sourceAccessConfigurations);

        /**
         * <p>
         * (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis
         * Streams event sources. A value of 0 seconds indicates no tumbling window.
         * </p>
         * 
         * @param tumblingWindowInSeconds
         *        (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and
         *        Kinesis Streams event sources. A value of 0 seconds indicates no tumbling window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tumblingWindowInSeconds(Integer tumblingWindowInSeconds);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
         * mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
         *        source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypesWithStrings(Collection<String> functionResponseTypes);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
         * mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
         *        source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypesWithStrings(String... functionResponseTypes);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
         * mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
         *        source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypes(Collection<FunctionResponseType> functionResponseTypes);

        /**
         * <p>
         * (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event source
         * mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current response type enums applied to the event
         *        source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypes(FunctionResponseType... functionResponseTypes);

        /**
         * <p>
         * (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring
         * maximum concurrency for Amazon SQS event sources</a>.
         * </p>
         * 
         * @param scalingConfig
         *        (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency"
         *        >Configuring maximum concurrency for Amazon SQS event sources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingConfig(ScalingConfig scalingConfig);

        /**
         * <p>
         * (Amazon SQS only) The scaling configuration for the event source. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring
         * maximum concurrency for Amazon SQS event sources</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScalingConfig.Builder} avoiding the need
         * to create one manually via {@link ScalingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScalingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #scalingConfig(ScalingConfig)}.
         * 
         * @param scalingConfig
         *        a consumer that will call methods on {@link ScalingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingConfig(ScalingConfig)
         */
        default Builder scalingConfig(Consumer<ScalingConfig.Builder> scalingConfig) {
            return scalingConfig(ScalingConfig.builder().applyMutation(scalingConfig).build());
        }

        /**
         * Sets the value of the AmazonManagedKafkaEventSourceConfig property for this object.
         *
         * @param amazonManagedKafkaEventSourceConfig
         *        The new value for the AmazonManagedKafkaEventSourceConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig);

        /**
         * Sets the value of the AmazonManagedKafkaEventSourceConfig property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link AmazonManagedKafkaEventSourceConfig.Builder} avoiding the need to create one manually via
         * {@link AmazonManagedKafkaEventSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonManagedKafkaEventSourceConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig)}.
         * 
         * @param amazonManagedKafkaEventSourceConfig
         *        a consumer that will call methods on {@link AmazonManagedKafkaEventSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig)
         */
        default Builder amazonManagedKafkaEventSourceConfig(
                Consumer<AmazonManagedKafkaEventSourceConfig.Builder> amazonManagedKafkaEventSourceConfig) {
            return amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfig.builder()
                    .applyMutation(amazonManagedKafkaEventSourceConfig).build());
        }

        /**
         * Sets the value of the SelfManagedKafkaEventSourceConfig property for this object.
         *
         * @param selfManagedKafkaEventSourceConfig
         *        The new value for the SelfManagedKafkaEventSourceConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig);

        /**
         * Sets the value of the SelfManagedKafkaEventSourceConfig property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link SelfManagedKafkaEventSourceConfig.Builder} avoiding the need to create one manually via
         * {@link SelfManagedKafkaEventSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfManagedKafkaEventSourceConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig)}.
         * 
         * @param selfManagedKafkaEventSourceConfig
         *        a consumer that will call methods on {@link SelfManagedKafkaEventSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig)
         */
        default Builder selfManagedKafkaEventSourceConfig(
                Consumer<SelfManagedKafkaEventSourceConfig.Builder> selfManagedKafkaEventSourceConfig) {
            return selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig.builder()
                    .applyMutation(selfManagedKafkaEventSourceConfig).build());
        }

        /**
         * <p>
         * Specific configuration settings for a DocumentDB event source.
         * </p>
         * 
         * @param documentDBEventSourceConfig
         *        Specific configuration settings for a DocumentDB event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDBEventSourceConfig(DocumentDBEventSourceConfig documentDBEventSourceConfig);

        /**
         * <p>
         * Specific configuration settings for a DocumentDB event source.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentDBEventSourceConfig.Builder}
         * avoiding the need to create one manually via {@link DocumentDBEventSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentDBEventSourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #documentDBEventSourceConfig(DocumentDBEventSourceConfig)}.
         * 
         * @param documentDBEventSourceConfig
         *        a consumer that will call methods on {@link DocumentDBEventSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentDBEventSourceConfig(DocumentDBEventSourceConfig)
         */
        default Builder documentDBEventSourceConfig(Consumer<DocumentDBEventSourceConfig.Builder> documentDBEventSourceConfig) {
            return documentDBEventSourceConfig(DocumentDBEventSourceConfig.builder().applyMutation(documentDBEventSourceConfig)
                    .build());
        }

        /**
         * <p>
         * The ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your function's
         * <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics">filter
         * criteria</a>. By default, Lambda does not encrypt your filter criteria object. Specify this property to
         * encrypt data using your own customer managed key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the Key Management Service (KMS) customer managed key that Lambda uses to encrypt your
         *        function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html#filtering-basics"
         *        >filter criteria</a>. By default, Lambda does not encrypt your filter criteria object. Specify this
         *        property to encrypt data using your own customer managed key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The metrics configuration for your event source. For more information, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         * >Event source mapping metrics</a>.
         * </p>
         * 
         * @param metricsConfig
         *        The metrics configuration for your event source. For more information, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         *        >Event source mapping metrics</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsConfig(EventSourceMappingMetricsConfig metricsConfig);

        /**
         * <p>
         * The metrics configuration for your event source. For more information, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/monitoring-metrics-types.html#event-source-mapping-metrics"
         * >Event source mapping metrics</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventSourceMappingMetricsConfig.Builder}
         * avoiding the need to create one manually via {@link EventSourceMappingMetricsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventSourceMappingMetricsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #metricsConfig(EventSourceMappingMetricsConfig)}.
         * 
         * @param metricsConfig
         *        a consumer that will call methods on {@link EventSourceMappingMetricsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsConfig(EventSourceMappingMetricsConfig)
         */
        default Builder metricsConfig(Consumer<EventSourceMappingMetricsConfig.Builder> metricsConfig) {
            return metricsConfig(EventSourceMappingMetricsConfig.builder().applyMutation(metricsConfig).build());
        }

        /**
         * <p>
         * (Amazon SQS, Amazon MSK, and self-managed Apache Kafka only) The provisioned mode configuration for the event
         * source. For more information, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
         * >provisioned mode</a>.
         * </p>
         * 
         * @param provisionedPollerConfig
         *        (Amazon SQS, Amazon MSK, and self-managed Apache Kafka only) The provisioned mode configuration for
         *        the event source. For more information, see <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
         *        >provisioned mode</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedPollerConfig(ProvisionedPollerConfig provisionedPollerConfig);

        /**
         * <p>
         * (Amazon SQS, Amazon MSK, and self-managed Apache Kafka only) The provisioned mode configuration for the event
         * source. For more information, see <a href=
         * "https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html#invocation-eventsourcemapping-provisioned-mode"
         * >provisioned mode</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedPollerConfig.Builder} avoiding
         * the need to create one manually via {@link ProvisionedPollerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedPollerConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #provisionedPollerConfig(ProvisionedPollerConfig)}.
         * 
         * @param provisionedPollerConfig
         *        a consumer that will call methods on {@link ProvisionedPollerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedPollerConfig(ProvisionedPollerConfig)
         */
        default Builder provisionedPollerConfig(Consumer<ProvisionedPollerConfig.Builder> provisionedPollerConfig) {
            return provisionedPollerConfig(ProvisionedPollerConfig.builder().applyMutation(provisionedPollerConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String uuid;

        private String functionName;

        private Boolean enabled;

        private Integer batchSize;

        private FilterCriteria filterCriteria;

        private Integer maximumBatchingWindowInSeconds;

        private DestinationConfig destinationConfig;

        private Integer maximumRecordAgeInSeconds;

        private Boolean bisectBatchOnFunctionError;

        private Integer maximumRetryAttempts;

        private Integer parallelizationFactor;

        private List<SourceAccessConfiguration> sourceAccessConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Integer tumblingWindowInSeconds;

        private List<String> functionResponseTypes = DefaultSdkAutoConstructList.getInstance();

        private ScalingConfig scalingConfig;

        private AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig;

        private SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig;

        private DocumentDBEventSourceConfig documentDBEventSourceConfig;

        private String kmsKeyArn;

        private EventSourceMappingMetricsConfig metricsConfig;

        private ProvisionedPollerConfig provisionedPollerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventSourceMappingRequest model) {
            super(model);
            uuid(model.uuid);
            functionName(model.functionName);
            enabled(model.enabled);
            batchSize(model.batchSize);
            filterCriteria(model.filterCriteria);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            destinationConfig(model.destinationConfig);
            maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            bisectBatchOnFunctionError(model.bisectBatchOnFunctionError);
            maximumRetryAttempts(model.maximumRetryAttempts);
            parallelizationFactor(model.parallelizationFactor);
            sourceAccessConfigurations(model.sourceAccessConfigurations);
            tumblingWindowInSeconds(model.tumblingWindowInSeconds);
            functionResponseTypesWithStrings(model.functionResponseTypes);
            scalingConfig(model.scalingConfig);
            amazonManagedKafkaEventSourceConfig(model.amazonManagedKafkaEventSourceConfig);
            selfManagedKafkaEventSourceConfig(model.selfManagedKafkaEventSourceConfig);
            documentDBEventSourceConfig(model.documentDBEventSourceConfig);
            kmsKeyArn(model.kmsKeyArn);
            metricsConfig(model.metricsConfig);
            provisionedPollerConfig(model.provisionedPollerConfig);
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return maximumRecordAgeInSeconds;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final Boolean getBisectBatchOnFunctionError() {
            return bisectBatchOnFunctionError;
        }

        public final void setBisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
        }

        @Override
        public final Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getParallelizationFactor() {
            return parallelizationFactor;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public final List<SourceAccessConfiguration.Builder> getSourceAccessConfigurations() {
            List<SourceAccessConfiguration.Builder> result = SourceAccessConfigurationsCopier
                    .copyToBuilder(this.sourceAccessConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAccessConfigurations(
                Collection<SourceAccessConfiguration.BuilderImpl> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copyFromBuilder(sourceAccessConfigurations);
        }

        @Override
        public final Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copy(sourceAccessConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(SourceAccessConfiguration... sourceAccessConfigurations) {
            sourceAccessConfigurations(Arrays.asList(sourceAccessConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder>... sourceAccessConfigurations) {
            sourceAccessConfigurations(Stream.of(sourceAccessConfigurations)
                    .map(c -> SourceAccessConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTumblingWindowInSeconds() {
            return tumblingWindowInSeconds;
        }

        public final void setTumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
        }

        @Override
        public final Builder tumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
            return this;
        }

        public final Collection<String> getFunctionResponseTypes() {
            if (functionResponseTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return functionResponseTypes;
        }

        public final void setFunctionResponseTypes(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
        }

        @Override
        public final Builder functionResponseTypesWithStrings(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypesWithStrings(String... functionResponseTypes) {
            functionResponseTypesWithStrings(Arrays.asList(functionResponseTypes));
            return this;
        }

        @Override
        public final Builder functionResponseTypes(Collection<FunctionResponseType> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copyEnumToString(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypes(FunctionResponseType... functionResponseTypes) {
            functionResponseTypes(Arrays.asList(functionResponseTypes));
            return this;
        }

        public final ScalingConfig.Builder getScalingConfig() {
            return scalingConfig != null ? scalingConfig.toBuilder() : null;
        }

        public final void setScalingConfig(ScalingConfig.BuilderImpl scalingConfig) {
            this.scalingConfig = scalingConfig != null ? scalingConfig.build() : null;
        }

        @Override
        public final Builder scalingConfig(ScalingConfig scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        public final AmazonManagedKafkaEventSourceConfig.Builder getAmazonManagedKafkaEventSourceConfig() {
            return amazonManagedKafkaEventSourceConfig != null ? amazonManagedKafkaEventSourceConfig.toBuilder() : null;
        }

        public final void setAmazonManagedKafkaEventSourceConfig(
                AmazonManagedKafkaEventSourceConfig.BuilderImpl amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig != null ? amazonManagedKafkaEventSourceConfig
                    .build() : null;
        }

        @Override
        public final Builder amazonManagedKafkaEventSourceConfig(
                AmazonManagedKafkaEventSourceConfig amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig;
            return this;
        }

        public final SelfManagedKafkaEventSourceConfig.Builder getSelfManagedKafkaEventSourceConfig() {
            return selfManagedKafkaEventSourceConfig != null ? selfManagedKafkaEventSourceConfig.toBuilder() : null;
        }

        public final void setSelfManagedKafkaEventSourceConfig(
                SelfManagedKafkaEventSourceConfig.BuilderImpl selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig != null ? selfManagedKafkaEventSourceConfig
                    .build() : null;
        }

        @Override
        public final Builder selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfig selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig;
            return this;
        }

        public final DocumentDBEventSourceConfig.Builder getDocumentDBEventSourceConfig() {
            return documentDBEventSourceConfig != null ? documentDBEventSourceConfig.toBuilder() : null;
        }

        public final void setDocumentDBEventSourceConfig(DocumentDBEventSourceConfig.BuilderImpl documentDBEventSourceConfig) {
            this.documentDBEventSourceConfig = documentDBEventSourceConfig != null ? documentDBEventSourceConfig.build() : null;
        }

        @Override
        public final Builder documentDBEventSourceConfig(DocumentDBEventSourceConfig documentDBEventSourceConfig) {
            this.documentDBEventSourceConfig = documentDBEventSourceConfig;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final EventSourceMappingMetricsConfig.Builder getMetricsConfig() {
            return metricsConfig != null ? metricsConfig.toBuilder() : null;
        }

        public final void setMetricsConfig(EventSourceMappingMetricsConfig.BuilderImpl metricsConfig) {
            this.metricsConfig = metricsConfig != null ? metricsConfig.build() : null;
        }

        @Override
        public final Builder metricsConfig(EventSourceMappingMetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        public final ProvisionedPollerConfig.Builder getProvisionedPollerConfig() {
            return provisionedPollerConfig != null ? provisionedPollerConfig.toBuilder() : null;
        }

        public final void setProvisionedPollerConfig(ProvisionedPollerConfig.BuilderImpl provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig != null ? provisionedPollerConfig.build() : null;
        }

        @Override
        public final Builder provisionedPollerConfig(ProvisionedPollerConfig provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventSourceMappingRequest build() {
            return new UpdateEventSourceMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
