/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.AddPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddPermissionResponse;
import software.amazon.awssdk.services.lambda.model.CodeStorageExceededException;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.Ec2AccessDeniedException;
import software.amazon.awssdk.services.lambda.model.Ec2ThrottledException;
import software.amazon.awssdk.services.lambda.model.Ec2UnexpectedException;
import software.amazon.awssdk.services.lambda.model.EniLimitReachedException;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.GetPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetPolicyResponse;
import software.amazon.awssdk.services.lambda.model.InvalidParameterValueException;
import software.amazon.awssdk.services.lambda.model.InvalidRequestContentException;
import software.amazon.awssdk.services.lambda.model.InvalidRuntimeException;
import software.amazon.awssdk.services.lambda.model.InvalidSecurityGroupIdException;
import software.amazon.awssdk.services.lambda.model.InvalidSubnetIdException;
import software.amazon.awssdk.services.lambda.model.InvalidZipFileException;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.lambda.model.KmsDisabledException;
import software.amazon.awssdk.services.lambda.model.KmsInvalidStateException;
import software.amazon.awssdk.services.lambda.model.KmsNotFoundException;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayersRequest;
import software.amazon.awssdk.services.lambda.model.ListLayersResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.lambda.model.PreconditionFailedException;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.RemovePermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemovePermissionResponse;
import software.amazon.awssdk.services.lambda.model.RequestTooLargeException;
import software.amazon.awssdk.services.lambda.model.ResourceConflictException;
import software.amazon.awssdk.services.lambda.model.ResourceInUseException;
import software.amazon.awssdk.services.lambda.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lambda.model.ServiceException;
import software.amazon.awssdk.services.lambda.model.SubnetIpAddressLimitReachedException;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.TooManyRequestsException;
import software.amazon.awssdk.services.lambda.model.UnsupportedMediaTypeException;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateAliasRequest;
import software.amazon.awssdk.services.lambda.model.UpdateAliasResponse;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher;
import software.amazon.awssdk.services.lambda.transform.AddLayerVersionPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionConcurrencyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteLayerVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetLayerVersionPolicyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetLayerVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.InvokeRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListEventSourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListLayerVersionsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListLayersRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListVersionsByFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PublishLayerVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PublishVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PutFunctionConcurrencyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.RemoveLayerVersionPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionCodeRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link LambdaAsyncClient}.
 *
 * @see LambdaAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLambdaAsyncClient implements LambdaAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLambdaAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLambdaAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. Use this
     * action to grant layer usage permission to other accounts. You can grant permission to a single account, all AWS
     * accounts, or all accounts in an organization.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     * @return A Java Future containing the result of the AddLayerVersionPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>PolicyLengthExceededException Lambda function access policy is limited to 20 KB.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AddLayerVersionPermissionResponse> addLayerVersionPermission(
            AddLayerVersionPermissionRequest addLayerVersionPermissionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddLayerVersionPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddLayerVersionPermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<AddLayerVersionPermissionRequest, AddLayerVersionPermissionResponse>()
                            .withOperationName("AddLayerVersionPermission")
                            .withMarshaller(new AddLayerVersionPermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(addLayerVersionPermissionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants an AWS service or another account permission to use a function. You can apply the policy at the function
     * level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the
     * invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function.
     * </p>
     * <p>
     * To grant permission to another account, specify the account ID as the <code>Principal</code>. For AWS services,
     * the principal is a domain-style identifier defined by the service, like <code>s3.amazonaws.com</code> or
     * <code>sns.amazonaws.com</code>. For AWS services, you can also specify the ARN or owning account of the
     * associated resource as the <code>SourceArn</code> or <code>SourceAccount</code>. If you grant permission to a
     * service principal without specifying the source, other accounts could potentially configure resources in their
     * account to invoke your Lambda function.
     * </p>
     * <p>
     * This action adds a statement to a resource-based permission policy for the function. For more information about
     * function policies, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Lambda Function
     * Policies</a>.
     * </p>
     *
     * @param addPermissionRequest
     * @return A Java Future containing the result of the AddPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>PolicyLengthExceededException Lambda function access policy is limited to 20 KB.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddPermissionResponse> addPermission(AddPermissionRequest addPermissionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddPermissionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddPermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<AddPermissionRequest, AddPermissionResponse>()
                    .withOperationName("AddPermission").withMarshaller(new AddPermissionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(addPermissionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a> for a Lambda
     * function version. Use aliases to provide clients with a function identifier that you can update to invoke a
     * different version.
     * </p>
     * <p>
     * You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code>
     * parameter to specify a second version and the percentage of invocation requests that it receives.
     * </p>
     *
     * @param createAliasRequest
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                    .withOperationName("CreateAlias").withMarshaller(new CreateAliasRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createAliasRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a mapping between an event source and an AWS Lambda function. Lambda reads items from the event source
     * and triggers the function.
     * </p>
     * <p>
     * For details about each event source type, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html">Using AWS Lambda with Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html">Using AWS Lambda with Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html">Using AWS Lambda with Amazon DynamoDB</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createEventSourceMappingRequest
     * @return A Java Future containing the result of the CreateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEventSourceMappingResponse> createEventSourceMapping(
            CreateEventSourceMappingRequest createEventSourceMappingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEventSourceMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEventSourceMappingRequest, CreateEventSourceMappingResponse>()
                            .withOperationName("CreateEventSourceMapping")
                            .withMarshaller(new CreateEventSourceMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createEventSourceMappingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Lambda function. To create a function, you need a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html">deployment package</a> and an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">
     * execution role</a>. The deployment package contains your function code. The execution role grants the function
     * permission to use AWS services, such as Amazon CloudWatch Logs for log streaming and AWS X-Ray for request
     * tracing.
     * </p>
     * <p>
     * A function has an unpublished version, and can have published versions and aliases. The unpublished version
     * changes when you update your function's code and configuration. A published version is a snapshot of your
     * function code and configuration that can't be changed. An alias is a named resource that maps to a version, and
     * can be changed to map to a different version. Use the <code>Publish</code> parameter to create version
     * <code>1</code> of your function from its initial configuration.
     * </p>
     * <p>
     * The other parameters let you configure version-specific and function-level settings. You can modify
     * version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both
     * the unpublished and published versions of the function, and include tags (<a>TagResource</a>) and per-function
     * concurrency limits (<a>PutFunctionConcurrency</a>).
     * </p>
     * <p>
     * If another account or an AWS service invokes your function, use <a>AddPermission</a> to grant permission by
     * creating a resource-based IAM policy. You can grant permissions at the function level, on a version, or on an
     * alias.
     * </p>
     * <p>
     * To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other AWS
     * services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a function trigger in
     * the other service. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invoking-lambda-functions.html">Invoking Functions</a>.
     * </p>
     *
     * @param createFunctionRequest
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFunctionResponse> createFunction(CreateFunctionRequest createFunctionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFunctionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<CreateFunctionRequest, CreateFunctionResponse>()
                    .withOperationName("CreateFunction").withMarshaller(new CreateFunctionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(createFunctionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param deleteAliasRequest
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<DeleteAliasRequest, DeleteAliasResponse>()
                    .withOperationName("DeleteAlias").withMarshaller(new DeleteAliasRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteAliasRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
     * mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     * @return A Java Future containing the result of the DeleteEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         attempted to update an EventSource Mapping in CREATING, or tried to delete a EventSource mapping
     *         currently in the UPDATING state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventSourceMappingResponse> deleteEventSourceMapping(
            DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventSourceMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventSourceMappingRequest, DeleteEventSourceMappingResponse>()
                            .withOperationName("DeleteEventSourceMapping")
                            .withMarshaller(new DeleteEventSourceMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteEventSourceMappingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted.
     * </p>
     * <p>
     * To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For AWS
     * services and resources that invoke your function directly, delete the trigger in the service where you originally
     * configured it.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFunctionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<DeleteFunctionRequest, DeleteFunctionResponse>()
                    .withOperationName("DeleteFunction").withMarshaller(new DeleteFunctionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteFunctionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a concurrent execution limit from a function.
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     * @return A Java Future containing the result of the DeleteFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFunctionConcurrencyResponse> deleteFunctionConcurrency(
            DeleteFunctionConcurrencyRequest deleteFunctionConcurrencyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFunctionConcurrencyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFunctionConcurrencyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFunctionConcurrencyRequest, DeleteFunctionConcurrencyResponse>()
                            .withOperationName("DeleteFunctionConcurrency")
                            .withMarshaller(new DeleteFunctionConcurrencyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteFunctionConcurrencyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
     * Lambda layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a
     * copy of the version remains in Lambda until no functions refer to it.
     * </p>
     *
     * @param deleteLayerVersionRequest
     * @return A Java Future containing the result of the DeleteLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLayerVersionResponse> deleteLayerVersion(DeleteLayerVersionRequest deleteLayerVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLayerVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLayerVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<DeleteLayerVersionRequest, DeleteLayerVersionResponse>()
                    .withOperationName("DeleteLayerVersion")
                    .withMarshaller(new DeleteLayerVersionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(deleteLayerVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an AWS Region.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAccountSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetAccountSettingsRequest, GetAccountSettingsResponse>()
                    .withOperationName("GetAccountSettings")
                    .withMarshaller(new GetAccountSettingsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getAccountSettingsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details about a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param getAliasRequest
     * @return A Java Future containing the result of the GetAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAliasResponse> getAlias(GetAliasRequest getAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetAliasRequest, GetAliasResponse>()
                    .withOperationName("GetAlias").withMarshaller(new GetAliasRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getAliasRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of
     * <a>ListEventSourceMappings</a>.
     * </p>
     *
     * @param getEventSourceMappingRequest
     * @return A Java Future containing the result of the GetEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventSourceMappingResponse> getEventSourceMapping(
            GetEventSourceMappingRequest getEventSourceMappingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEventSourceMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetEventSourceMappingRequest, GetEventSourceMappingResponse>()
                    .withOperationName("GetEventSourceMapping")
                    .withMarshaller(new GetEventSourceMappingRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getEventSourceMappingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the function or function version, with a link to download the deployment package that's
     * valid for 10 minutes. If you specify a function version, only details that are specific to that version are
     * returned.
     * </p>
     *
     * @param getFunctionRequest
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFunctionResponse> getFunction(GetFunctionRequest getFunctionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFunctionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetFunctionRequest, GetFunctionResponse>()
                    .withOperationName("GetFunction").withMarshaller(new GetFunctionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getFunctionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the version-specific settings of a Lambda function or version. The output includes only options that can
     * vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To get all of a function's details, including function-level settings, use <a>GetFunction</a>.
     * </p>
     *
     * @param getFunctionConfigurationRequest
     * @return A Java Future containing the result of the GetFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFunctionConfigurationResponse> getFunctionConfiguration(
            GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFunctionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFunctionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<GetFunctionConfigurationRequest, GetFunctionConfigurationResponse>()
                            .withOperationName("GetFunctionConfiguration")
                            .withMarshaller(new GetFunctionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getFunctionConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>, with a link
     * to download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionRequest
     * @return A Java Future containing the result of the GetLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLayerVersionResponse> getLayerVersion(GetLayerVersionRequest getLayerVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLayerVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLayerVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetLayerVersionRequest, GetLayerVersionResponse>()
                    .withOperationName("GetLayerVersion").withMarshaller(new GetLayerVersionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getLayerVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the permission policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     * @return A Java Future containing the result of the GetLayerVersionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersionPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLayerVersionPolicyResponse> getLayerVersionPolicy(
            GetLayerVersionPolicyRequest getLayerVersionPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLayerVersionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLayerVersionPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetLayerVersionPolicyRequest, GetLayerVersionPolicyResponse>()
                    .withOperationName("GetLayerVersionPolicy")
                    .withMarshaller(new GetLayerVersionPolicyRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getLayerVersionPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM
     * policy</a> for a function, version, or alias.
     * </p>
     *
     * @param getPolicyRequest
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>()
                    .withOperationName("GetPolicy").withMarshaller(new GetPolicyRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(getPolicyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or
     * asynchronously. To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>.
     * </p>
     * <p>
     * For synchronous invocation, details about the function response, including errors, are included in the response
     * body and headers. For either invocation type, you can find more information in the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/dlq.html">trace</a>. To record function errors for
     * asynchronous invocations, configure your function with a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/dlq.html">dead letter queue</a>.
     * </p>
     * <p>
     * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your function from executing, such as permissions errors, <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limit errors</a>, or issues with your function's
     * code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if executing the
     * function would cause you to exceed a concurrency limit at either the account level (
     * <code>ConcurrentInvocationLimitExceeded</code>) or function level (
     * <code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).
     * </p>
     * <p>
     * For functions with a long timeout, your client might be disconnected during synchronous invocation while it waits
     * for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long
     * connections with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:InvokeFunction</code> action.
     * </p>
     *
     * @param invokeRequest
     * @return A Java Future containing the result of the Invoke operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidRequestContentException The request body could not be parsed as JSON.</li>
     *         <li>RequestTooLargeException The request payload exceeded the <code>Invoke</code> request body JSON input
     *         limit. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>.</li>
     *         <li>UnsupportedMediaTypeException The content type of the <code>Invoke</code> request body is not JSON.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>Ec2UnexpectedException AWS Lambda received an unexpected EC2 client exception while setting up for
     *         the Lambda function.</li>
     *         <li>SubnetIpAddressLimitReachedException AWS Lambda was not able to set up VPC access for the Lambda
     *         function because one or more configured subnets has no available IP addresses.</li>
     *         <li>EniLimitReachedException AWS Lambda was not able to create an Elastic Network Interface (ENI) in the
     *         VPC, specified as part of Lambda function configuration, because the limit for network interfaces has
     *         been reached.</li>
     *         <li>Ec2ThrottledException AWS Lambda was throttled by Amazon EC2 during Lambda function initialization
     *         using the execution role provided for the Lambda function.</li>
     *         <li>Ec2AccessDeniedException Need additional permissions to configure VPC settings.</li>
     *         <li>InvalidSubnetIdException The Subnet ID provided in the Lambda function VPC configuration is invalid.</li>
     *         <li>InvalidSecurityGroupIdException The Security Group ID provided in the Lambda function VPC
     *         configuration is invalid.</li>
     *         <li>InvalidZipFileException AWS Lambda could not unzip the deployment package.</li>
     *         <li>KmsDisabledException Lambda was unable to decrypt the environment variables because the KMS key used
     *         is disabled. Check the Lambda function's KMS key settings.</li>
     *         <li>KmsInvalidStateException Lambda was unable to decrypt the environment variables because the KMS key
     *         used is in an invalid state for Decrypt. Check the function's KMS key settings.</li>
     *         <li>KmsAccessDeniedException Lambda was unable to decrypt the environment variables because KMS access
     *         was denied. Check the Lambda function's KMS permissions.</li>
     *         <li>KmsNotFoundException Lambda was unable to decrypt the environment variables because the KMS key was
     *         not found. Check the function's KMS key settings.</li>
     *         <li>InvalidRuntimeException The runtime or runtime version specified is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.Invoke
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<InvokeResponse> invoke(InvokeRequest invokeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(false).build();

            HttpResponseHandler<InvokeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    InvokeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<InvokeRequest, InvokeResponse>().withOperationName("Invoke")
                    .withMarshaller(new InvokeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(invokeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">aliases</a> for
     * a Lambda function.
     * </p>
     *
     * @param listAliasesRequest
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAliasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListAliasesRequest, ListAliasesResponse>()
                    .withOperationName("ListAliases").withMarshaller(new ListAliasesRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listAliasesRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A Java Future containing the result of the ListEventSourceMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEventSourceMappingsResponse> listEventSourceMappings(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEventSourceMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEventSourceMappingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListEventSourceMappingsRequest, ListEventSourceMappingsResponse>()
                            .withOperationName("ListEventSourceMappings")
                            .withMarshaller(new ListEventSourceMappingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listEventSourceMappingsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    public ListEventSourceMappingsPublisher listEventSourceMappingsPaginator(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) {
        return new ListEventSourceMappingsPublisher(this, applyPaginatorUserAgent(listEventSourceMappingsRequest));
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     *
     * @param listFunctionsRequest
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFunctionsResponse> listFunctions(ListFunctionsRequest listFunctionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFunctionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFunctionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListFunctionsRequest, ListFunctionsResponse>()
                    .withOperationName("ListFunctions").withMarshaller(new ListFunctionsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listFunctionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @param listFunctionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    public ListFunctionsPublisher listFunctionsPaginator(ListFunctionsRequest listFunctionsRequest) {
        return new ListFunctionsPublisher(this, applyPaginatorUserAgent(listFunctionsRequest));
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
     * Lambda layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime.
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return A Java Future containing the result of the ListLayerVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayerVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListLayerVersionsResponse> listLayerVersions(ListLayerVersionsRequest listLayerVersionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLayerVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLayerVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListLayerVersionsRequest, ListLayerVersionsResponse>()
                    .withOperationName("ListLayerVersions")
                    .withMarshaller(new ListLayerVersionsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listLayerVersionsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layers</a> and
     * shows information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime.
     * </p>
     *
     * @param listLayersRequest
     * @return A Java Future containing the result of the ListLayers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListLayersResponse> listLayers(ListLayersRequest listLayersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLayersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListLayersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListLayersRequest, ListLayersResponse>()
                    .withOperationName("ListLayers").withMarshaller(new ListLayersRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listLayersRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also
     * view tags with <a>GetFunction</a>.
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>()
                    .withOperationName("ListTags").withMarshaller(new ListTagsRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(listTagsRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each.
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return A Java Future containing the result of the ListVersionsByFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListVersionsByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVersionsByFunctionResponse> listVersionsByFunction(
            ListVersionsByFunctionRequest listVersionsByFunctionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVersionsByFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVersionsByFunctionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<ListVersionsByFunctionRequest, ListVersionsByFunctionResponse>()
                            .withOperationName("ListVersionsByFunction")
                            .withMarshaller(new ListVersionsByFunctionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listVersionsByFunctionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>
     * from a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same version name, a new version
     * is created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     *
     * @param publishLayerVersionRequest
     * @return A Java Future containing the result of the PublishLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PublishLayerVersionResponse> publishLayerVersion(
            PublishLayerVersionRequest publishLayerVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PublishLayerVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PublishLayerVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<PublishLayerVersionRequest, PublishLayerVersionResponse>()
                    .withOperationName("PublishLayerVersion")
                    .withMarshaller(new PublishLayerVersionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(publishLayerVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
     * current code and configuration of a function. Use versions to create a snapshot of your function code and
     * configuration that doesn't change.
     * </p>
     * <p>
     * AWS Lambda doesn't publish a version if the function's configuration and code haven't changed since the last
     * version. Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function before
     * publishing a version.
     * </p>
     * <p>
     * Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.
     * </p>
     *
     * @param publishVersionRequest
     * @return A Java Future containing the result of the PublishVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PublishVersionResponse> publishVersion(PublishVersionRequest publishVersionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PublishVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PublishVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<PublishVersionRequest, PublishVersionResponse>()
                    .withOperationName("PublishVersion").withMarshaller(new PublishVersionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(publishVersionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
     * level.
     * </p>
     * <p>
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished
     * version. Reserving concurrency both ensures that your function has capacity to process the specified number of
     * events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current
     * setting for a function.
     * </p>
     * <p>
     * Use <a>GetAccountSettings</a> to see your regional concurrency limit. You can reserve concurrency for as many
     * functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that
     * aren't configured with a per-function limit. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     * @return A Java Future containing the result of the PutFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutFunctionConcurrencyResponse> putFunctionConcurrency(
            PutFunctionConcurrencyRequest putFunctionConcurrencyRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutFunctionConcurrencyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutFunctionConcurrencyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<PutFunctionConcurrencyRequest, PutFunctionConcurrencyResponse>()
                            .withOperationName("PutFunctionConcurrency")
                            .withMarshaller(new PutFunctionConcurrencyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putFunctionConcurrencyRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     * @return A Java Future containing the result of the RemoveLayerVersionPermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemoveLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RemoveLayerVersionPermissionResponse> removeLayerVersionPermission(
            RemoveLayerVersionPermissionRequest removeLayerVersionPermissionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveLayerVersionPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemoveLayerVersionPermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveLayerVersionPermissionRequest, RemoveLayerVersionPermissionResponse>()
                            .withOperationName("RemoveLayerVersionPermission")
                            .withMarshaller(new RemoveLayerVersionPermissionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(removeLayerVersionPermissionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes function-use permission from an AWS service or another account. You can get the ID of the statement from
     * the output of <a>GetPolicy</a>.
     * </p>
     *
     * @param removePermissionRequest
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemovePermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RemovePermissionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<RemovePermissionRequest, RemovePermissionResponse>()
                    .withOperationName("RemovePermission").withMarshaller(new RemovePermissionRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(removePermissionRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(tagResourceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(untagResourceRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param updateAliasRequest
     * @return A Java Future containing the result of the UpdateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAliasResponse> updateAlias(UpdateAliasRequest updateAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<UpdateAliasRequest, UpdateAliasResponse>()
                    .withOperationName("UpdateAlias").withMarshaller(new UpdateAliasRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(updateAliasRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that AWS Lambda invokes, or pause invocation and
     * resume later from the same location.
     * </p>
     *
     * @param updateEventSourceMappingRequest
     * @return A Java Future containing the result of the UpdateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         attempted to update an EventSource Mapping in CREATING, or tried to delete a EventSource mapping
     *         currently in the UPDATING state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEventSourceMappingResponse> updateEventSourceMapping(
            UpdateEventSourceMappingRequest updateEventSourceMappingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEventSourceMappingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateEventSourceMappingRequest, UpdateEventSourceMappingResponse>()
                            .withOperationName("UpdateEventSourceMapping")
                            .withMarshaller(new UpdateEventSourceMappingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateEventSourceMappingRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a Lambda function's code.
     * </p>
     * <p>
     * The function's code is locked when you publish a version. You can't modify the code of a published version, only
     * the unpublished version.
     * </p>
     *
     * @param updateFunctionCodeRequest
     * @return A Java Future containing the result of the UpdateFunctionCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFunctionCodeResponse> updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFunctionCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFunctionCodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler.execute(new ClientExecutionParams<UpdateFunctionCodeRequest, UpdateFunctionCodeResponse>()
                    .withOperationName("UpdateFunctionCode")
                    .withMarshaller(new UpdateFunctionCodeRequestMarshaller(protocolFactory))
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withInput(updateFunctionCodeRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modify the version-specifc settings of a Lambda function.
     * </p>
     * <p>
     * These settings can vary between versions of a function and are locked when you publish a version. You can't
     * modify the configuration of a published version, only the unpublished version.
     * </p>
     * <p>
     * To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an account
     * or AWS service, use <a>AddPermission</a>.
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     * @return A Java Future containing the result of the UpdateFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFunctionConfigurationResponse> updateFunctionConfiguration(
            UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFunctionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFunctionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFunctionConfigurationRequest, UpdateFunctionConfigurationResponse>()
                            .withOperationName("UpdateFunctionConfiguration")
                            .withMarshaller(new UpdateFunctionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateFunctionConfigurationRequest));
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LambdaException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EC2AccessDeniedException")
                                .exceptionBuilderSupplier(Ec2AccessDeniedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSInvalidStateException")
                                .exceptionBuilderSupplier(KmsInvalidStateException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSNotFoundException")
                                .exceptionBuilderSupplier(KmsNotFoundException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PolicyLengthExceededException")
                                .exceptionBuilderSupplier(PolicyLengthExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceException")
                                .exceptionBuilderSupplier(ServiceException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetIPAddressLimitReachedException")
                                .exceptionBuilderSupplier(SubnetIpAddressLimitReachedException::builder).httpStatusCode(502)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidZipFileException")
                                .exceptionBuilderSupplier(InvalidZipFileException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestContentException")
                                .exceptionBuilderSupplier(InvalidRequestContentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRuntimeException")
                                .exceptionBuilderSupplier(InvalidRuntimeException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ENILimitReachedException")
                                .exceptionBuilderSupplier(EniLimitReachedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnetIDException")
                                .exceptionBuilderSupplier(InvalidSubnetIdException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceConflictException")
                                .exceptionBuilderSupplier(ResourceConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeStorageExceededException")
                                .exceptionBuilderSupplier(CodeStorageExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSecurityGroupIDException")
                                .exceptionBuilderSupplier(InvalidSecurityGroupIdException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EC2ThrottledException")
                                .exceptionBuilderSupplier(Ec2ThrottledException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSAccessDeniedException")
                                .exceptionBuilderSupplier(KmsAccessDeniedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSDisabledException")
                                .exceptionBuilderSupplier(KmsDisabledException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailedException")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EC2UnexpectedException")
                                .exceptionBuilderSupplier(Ec2UnexpectedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RequestTooLargeException")
                                .exceptionBuilderSupplier(RequestTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedMediaTypeException")
                                .exceptionBuilderSupplier(UnsupportedMediaTypeException::builder).httpStatusCode(415).build());
    }

    private <T extends LambdaRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
