/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentRequest extends LaunchWizardRequest implements
        ToCopyableBuilder<CreateDeploymentRequest.Builder, CreateDeploymentRequest> {
    private static final SdkField<String> DEPLOYMENT_PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentPatternName").getter(getter(CreateDeploymentRequest::deploymentPatternName))
            .setter(setter(Builder::deploymentPatternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPatternName").build())
            .build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dryRun").getter(getter(CreateDeploymentRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dryRun").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDeploymentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> SPECIFICATIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("specifications")
            .getter(getter(CreateDeploymentRequest::specifications))
            .setter(setter(Builder::specifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specifications").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDeploymentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadName").getter(getter(CreateDeploymentRequest::workloadName))
            .setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_PATTERN_NAME_FIELD,
            DRY_RUN_FIELD, NAME_FIELD, SPECIFICATIONS_FIELD, TAGS_FIELD, WORKLOAD_NAME_FIELD));

    private final String deploymentPatternName;

    private final Boolean dryRun;

    private final String name;

    private final Map<String, String> specifications;

    private final Map<String, String> tags;

    private final String workloadName;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentPatternName = builder.deploymentPatternName;
        this.dryRun = builder.dryRun;
        this.name = builder.name;
        this.specifications = builder.specifications;
        this.tags = builder.tags;
        this.workloadName = builder.workloadName;
    }

    /**
     * <p>
     * The name of the deployment pattern supported by a given workload. You can use the <a
     * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloadDeploymentPatterns.html">
     * <code>ListWorkloadDeploymentPatterns</code> </a> operation to discover supported values for this parameter.
     * </p>
     * 
     * @return The name of the deployment pattern supported by a given workload. You can use the <a
     *         href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloadDeploymentPatterns.html"
     *         > <code>ListWorkloadDeploymentPatterns</code> </a> operation to discover supported values for this
     *         parameter.
     */
    public final String deploymentPatternName() {
        return deploymentPatternName;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The name of the deployment.
     * </p>
     * 
     * @return The name of the deployment.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Specifications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSpecifications() {
        return specifications != null && !(specifications instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The settings specified for the deployment. These settings define how to deploy and configure your resources
     * created by the deployment. For more information about the specifications required for creating a deployment for a
     * SAP workload, see <a
     * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html">SAP
     * deployment specifications</a>. To retrieve the specifications required to create a deployment for other
     * workloads, use the <a
     * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
     * <code>GetWorkloadDeploymentPattern</code> </a> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpecifications} method.
     * </p>
     * 
     * @return The settings specified for the deployment. These settings define how to deploy and configure your
     *         resources created by the deployment. For more information about the specifications required for creating
     *         a deployment for a SAP workload, see <a href=
     *         "https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html">SAP
     *         deployment specifications</a>. To retrieve the specifications required to create a deployment for other
     *         workloads, use the <a href=
     *         "https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
     *         <code>GetWorkloadDeploymentPattern</code> </a> operation.
     */
    public final Map<String, String> specifications() {
        return specifications;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to add to the deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add to the deployment.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the workload. You can use the <a
     * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloads.html">
     * <code>ListWorkloads</code> </a> operation to discover supported values for this parameter.
     * </p>
     * 
     * @return The name of the workload. You can use the <a
     *         href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloads.html">
     *         <code>ListWorkloads</code> </a> operation to discover supported values for this parameter.
     */
    public final String workloadName() {
        return workloadName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentPatternName());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpecifications() ? specifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest) obj;
        return Objects.equals(deploymentPatternName(), other.deploymentPatternName()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(name(), other.name()) && hasSpecifications() == other.hasSpecifications()
                && Objects.equals(specifications(), other.specifications()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(workloadName(), other.workloadName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDeploymentRequest").add("DeploymentPatternName", deploymentPatternName())
                .add("DryRun", dryRun()).add("Name", name())
                .add("Specifications", specifications() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null).add("WorkloadName", workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentPatternName":
            return Optional.ofNullable(clazz.cast(deploymentPatternName()));
        case "dryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "specifications":
            return Optional.ofNullable(clazz.cast(specifications()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LaunchWizardRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentRequest> {
        /**
         * <p>
         * The name of the deployment pattern supported by a given workload. You can use the <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloadDeploymentPatterns.html">
         * <code>ListWorkloadDeploymentPatterns</code> </a> operation to discover supported values for this parameter.
         * </p>
         * 
         * @param deploymentPatternName
         *        The name of the deployment pattern supported by a given workload. You can use the <a href=
         *        "https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloadDeploymentPatterns.html"
         *        > <code>ListWorkloadDeploymentPatterns</code> </a> operation to discover supported values for this
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentPatternName(String deploymentPatternName);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The name of the deployment.
         * </p>
         * 
         * @param name
         *        The name of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The settings specified for the deployment. These settings define how to deploy and configure your resources
         * created by the deployment. For more information about the specifications required for creating a deployment
         * for a SAP workload, see <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html">SAP
         * deployment specifications</a>. To retrieve the specifications required to create a deployment for other
         * workloads, use the <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
         * <code>GetWorkloadDeploymentPattern</code> </a> operation.
         * </p>
         * 
         * @param specifications
         *        The settings specified for the deployment. These settings define how to deploy and configure your
         *        resources created by the deployment. For more information about the specifications required for
         *        creating a deployment for a SAP workload, see <a href=
         *        "https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html"
         *        >SAP deployment specifications</a>. To retrieve the specifications required to create a deployment for
         *        other workloads, use the <a href=
         *        "https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
         *        <code>GetWorkloadDeploymentPattern</code> </a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specifications(Map<String, String> specifications);

        /**
         * <p>
         * The tags to add to the deployment.
         * </p>
         * 
         * @param tags
         *        The tags to add to the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The name of the workload. You can use the <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloads.html">
         * <code>ListWorkloads</code> </a> operation to discover supported values for this parameter.
         * </p>
         * 
         * @param workloadName
         *        The name of the workload. You can use the <a
         *        href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloads.html">
         *        <code>ListWorkloads</code> </a> operation to discover supported values for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LaunchWizardRequest.BuilderImpl implements Builder {
        private String deploymentPatternName;

        private Boolean dryRun;

        private String name;

        private Map<String, String> specifications = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            deploymentPatternName(model.deploymentPatternName);
            dryRun(model.dryRun);
            name(model.name);
            specifications(model.specifications);
            tags(model.tags);
            workloadName(model.workloadName);
        }

        public final String getDeploymentPatternName() {
            return deploymentPatternName;
        }

        public final void setDeploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
        }

        @Override
        public final Builder deploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getSpecifications() {
            if (specifications instanceof SdkAutoConstructMap) {
                return null;
            }
            return specifications;
        }

        public final void setSpecifications(Map<String, String> specifications) {
            this.specifications = DeploymentSpecificationsCopier.copy(specifications);
        }

        @Override
        public final Builder specifications(Map<String, String> specifications) {
            this.specifications = DeploymentSpecificationsCopier.copy(specifications);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
