/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data that details a workload deployment pattern.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadDeploymentPatternData implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkloadDeploymentPatternData.Builder, WorkloadDeploymentPatternData> {
    private static final SdkField<String> DEPLOYMENT_PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentPatternName").getter(getter(WorkloadDeploymentPatternData::deploymentPatternName))
            .setter(setter(Builder::deploymentPatternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPatternName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(WorkloadDeploymentPatternData::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(WorkloadDeploymentPatternData::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<List<DeploymentSpecificationsField>> SPECIFICATIONS_FIELD = SdkField
            .<List<DeploymentSpecificationsField>> builder(MarshallingType.LIST)
            .memberName("specifications")
            .getter(getter(WorkloadDeploymentPatternData::specifications))
            .setter(setter(Builder::specifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentSpecificationsField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentSpecificationsField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorkloadDeploymentPatternData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(WorkloadDeploymentPatternData::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadName").getter(getter(WorkloadDeploymentPatternData::workloadName))
            .setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()).build();

    private static final SdkField<String> WORKLOAD_VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadVersionName").getter(getter(WorkloadDeploymentPatternData::workloadVersionName))
            .setter(setter(Builder::workloadVersionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadVersionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_PATTERN_NAME_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, SPECIFICATIONS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, WORKLOAD_NAME_FIELD,
            WORKLOAD_VERSION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentPatternName;

    private final String description;

    private final String displayName;

    private final List<DeploymentSpecificationsField> specifications;

    private final String status;

    private final String statusMessage;

    private final String workloadName;

    private final String workloadVersionName;

    private WorkloadDeploymentPatternData(BuilderImpl builder) {
        this.deploymentPatternName = builder.deploymentPatternName;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.specifications = builder.specifications;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.workloadName = builder.workloadName;
        this.workloadVersionName = builder.workloadVersionName;
    }

    /**
     * <p>
     * The name of the deployment pattern.
     * </p>
     * 
     * @return The name of the deployment pattern.
     */
    public final String deploymentPatternName() {
        return deploymentPatternName;
    }

    /**
     * <p>
     * The description of the deployment pattern.
     * </p>
     * 
     * @return The description of the deployment pattern.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the deployment pattern.
     * </p>
     * 
     * @return The display name of the deployment pattern.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Specifications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSpecifications() {
        return specifications != null && !(specifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The settings specified for the deployment. These settings define how to deploy and configure your resources
     * created by the deployment. For more information about the specifications required for creating a deployment for a
     * SAP workload, see <a
     * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html">SAP
     * deployment specifications</a>. To retrieve the specifications required to create a deployment for other
     * workloads, use the <a
     * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
     * <code>GetWorkloadDeploymentPattern</code> </a> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpecifications} method.
     * </p>
     * 
     * @return The settings specified for the deployment. These settings define how to deploy and configure your
     *         resources created by the deployment. For more information about the specifications required for creating
     *         a deployment for a SAP workload, see <a href=
     *         "https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html">SAP
     *         deployment specifications</a>. To retrieve the specifications required to create a deployment for other
     *         workloads, use the <a href=
     *         "https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
     *         <code>GetWorkloadDeploymentPattern</code> </a> operation.
     */
    public final List<DeploymentSpecificationsField> specifications() {
        return specifications;
    }

    /**
     * <p>
     * The status of the deployment pattern.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadDeploymentPatternStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment pattern.
     * @see WorkloadDeploymentPatternStatus
     */
    public final WorkloadDeploymentPatternStatus status() {
        return WorkloadDeploymentPatternStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the deployment pattern.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadDeploymentPatternStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment pattern.
     * @see WorkloadDeploymentPatternStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the deployment pattern.
     * </p>
     * 
     * @return The status message of the deployment pattern.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The workload name of the deployment pattern.
     * </p>
     * 
     * @return The workload name of the deployment pattern.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * <p>
     * The workload version name of the deployment pattern.
     * </p>
     * 
     * @return The workload version name of the deployment pattern.
     */
    public final String workloadVersionName() {
        return workloadVersionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentPatternName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpecifications() ? specifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(workloadVersionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadDeploymentPatternData)) {
            return false;
        }
        WorkloadDeploymentPatternData other = (WorkloadDeploymentPatternData) obj;
        return Objects.equals(deploymentPatternName(), other.deploymentPatternName())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && hasSpecifications() == other.hasSpecifications() && Objects.equals(specifications(), other.specifications())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(workloadName(), other.workloadName())
                && Objects.equals(workloadVersionName(), other.workloadVersionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadDeploymentPatternData").add("DeploymentPatternName", deploymentPatternName())
                .add("Description", description()).add("DisplayName", displayName())
                .add("Specifications", hasSpecifications() ? specifications() : null).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("WorkloadName", workloadName())
                .add("WorkloadVersionName", workloadVersionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentPatternName":
            return Optional.ofNullable(clazz.cast(deploymentPatternName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "specifications":
            return Optional.ofNullable(clazz.cast(specifications()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "workloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "workloadVersionName":
            return Optional.ofNullable(clazz.cast(workloadVersionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkloadDeploymentPatternData, T> g) {
        return obj -> g.apply((WorkloadDeploymentPatternData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadDeploymentPatternData> {
        /**
         * <p>
         * The name of the deployment pattern.
         * </p>
         * 
         * @param deploymentPatternName
         *        The name of the deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentPatternName(String deploymentPatternName);

        /**
         * <p>
         * The description of the deployment pattern.
         * </p>
         * 
         * @param description
         *        The description of the deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the deployment pattern.
         * </p>
         * 
         * @param displayName
         *        The display name of the deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The settings specified for the deployment. These settings define how to deploy and configure your resources
         * created by the deployment. For more information about the specifications required for creating a deployment
         * for a SAP workload, see <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html">SAP
         * deployment specifications</a>. To retrieve the specifications required to create a deployment for other
         * workloads, use the <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
         * <code>GetWorkloadDeploymentPattern</code> </a> operation.
         * </p>
         * 
         * @param specifications
         *        The settings specified for the deployment. These settings define how to deploy and configure your
         *        resources created by the deployment. For more information about the specifications required for
         *        creating a deployment for a SAP workload, see <a href=
         *        "https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html"
         *        >SAP deployment specifications</a>. To retrieve the specifications required to create a deployment for
         *        other workloads, use the <a href=
         *        "https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
         *        <code>GetWorkloadDeploymentPattern</code> </a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specifications(Collection<DeploymentSpecificationsField> specifications);

        /**
         * <p>
         * The settings specified for the deployment. These settings define how to deploy and configure your resources
         * created by the deployment. For more information about the specifications required for creating a deployment
         * for a SAP workload, see <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html">SAP
         * deployment specifications</a>. To retrieve the specifications required to create a deployment for other
         * workloads, use the <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
         * <code>GetWorkloadDeploymentPattern</code> </a> operation.
         * </p>
         * 
         * @param specifications
         *        The settings specified for the deployment. These settings define how to deploy and configure your
         *        resources created by the deployment. For more information about the specifications required for
         *        creating a deployment for a SAP workload, see <a href=
         *        "https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html"
         *        >SAP deployment specifications</a>. To retrieve the specifications required to create a deployment for
         *        other workloads, use the <a href=
         *        "https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
         *        <code>GetWorkloadDeploymentPattern</code> </a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specifications(DeploymentSpecificationsField... specifications);

        /**
         * <p>
         * The settings specified for the deployment. These settings define how to deploy and configure your resources
         * created by the deployment. For more information about the specifications required for creating a deployment
         * for a SAP workload, see <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/launch-wizard-specifications-sap.html">SAP
         * deployment specifications</a>. To retrieve the specifications required to create a deployment for other
         * workloads, use the <a
         * href="https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_GetWorkloadDeploymentPattern.html">
         * <code>GetWorkloadDeploymentPattern</code> </a> operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.launchwizard.model.DeploymentSpecificationsField.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.launchwizard.model.DeploymentSpecificationsField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.launchwizard.model.DeploymentSpecificationsField.Builder#build()} is
         * called immediately and its result is passed to {@link #specifications(List<DeploymentSpecificationsField>)}.
         * 
         * @param specifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.launchwizard.model.DeploymentSpecificationsField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #specifications(java.util.Collection<DeploymentSpecificationsField>)
         */
        Builder specifications(Consumer<DeploymentSpecificationsField.Builder>... specifications);

        /**
         * <p>
         * The status of the deployment pattern.
         * </p>
         * 
         * @param status
         *        The status of the deployment pattern.
         * @see WorkloadDeploymentPatternStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadDeploymentPatternStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the deployment pattern.
         * </p>
         * 
         * @param status
         *        The status of the deployment pattern.
         * @see WorkloadDeploymentPatternStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadDeploymentPatternStatus
         */
        Builder status(WorkloadDeploymentPatternStatus status);

        /**
         * <p>
         * The status message of the deployment pattern.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The workload name of the deployment pattern.
         * </p>
         * 
         * @param workloadName
         *        The workload name of the deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * <p>
         * The workload version name of the deployment pattern.
         * </p>
         * 
         * @param workloadVersionName
         *        The workload version name of the deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadVersionName(String workloadVersionName);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentPatternName;

        private String description;

        private String displayName;

        private List<DeploymentSpecificationsField> specifications = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private String statusMessage;

        private String workloadName;

        private String workloadVersionName;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadDeploymentPatternData model) {
            deploymentPatternName(model.deploymentPatternName);
            description(model.description);
            displayName(model.displayName);
            specifications(model.specifications);
            status(model.status);
            statusMessage(model.statusMessage);
            workloadName(model.workloadName);
            workloadVersionName(model.workloadVersionName);
        }

        public final String getDeploymentPatternName() {
            return deploymentPatternName;
        }

        public final void setDeploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
        }

        @Override
        public final Builder deploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<DeploymentSpecificationsField.Builder> getSpecifications() {
            List<DeploymentSpecificationsField.Builder> result = DeploymentSpecificationsDataCopier
                    .copyToBuilder(this.specifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpecifications(Collection<DeploymentSpecificationsField.BuilderImpl> specifications) {
            this.specifications = DeploymentSpecificationsDataCopier.copyFromBuilder(specifications);
        }

        @Override
        public final Builder specifications(Collection<DeploymentSpecificationsField> specifications) {
            this.specifications = DeploymentSpecificationsDataCopier.copy(specifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder specifications(DeploymentSpecificationsField... specifications) {
            specifications(Arrays.asList(specifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder specifications(Consumer<DeploymentSpecificationsField.Builder>... specifications) {
            specifications(Stream.of(specifications).map(c -> DeploymentSpecificationsField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkloadDeploymentPatternStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getWorkloadVersionName() {
            return workloadVersionName;
        }

        public final void setWorkloadVersionName(String workloadVersionName) {
            this.workloadVersionName = workloadVersionName;
        }

        @Override
        public final Builder workloadVersionName(String workloadVersionName) {
            this.workloadVersionName = workloadVersionName;
            return this;
        }

        @Override
        public WorkloadDeploymentPatternData build() {
            return new WorkloadDeploymentPatternData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
