/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A field that details a specification of a deployment pattern.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentSpecificationsField implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentSpecificationsField.Builder, DeploymentSpecificationsField> {
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedValues")
            .getter(getter(DeploymentSpecificationsField::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DeploymentConditionalField>> CONDITIONALS_FIELD = SdkField
            .<List<DeploymentConditionalField>> builder(MarshallingType.LIST)
            .memberName("conditionals")
            .getter(getter(DeploymentSpecificationsField::conditionals))
            .setter(setter(Builder::conditionals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentConditionalField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentConditionalField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DeploymentSpecificationsField::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeploymentSpecificationsField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REQUIRED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("required").getter(getter(DeploymentSpecificationsField::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD,
            CONDITIONALS_FIELD, DESCRIPTION_FIELD, NAME_FIELD, REQUIRED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> allowedValues;

    private final List<DeploymentConditionalField> conditionals;

    private final String description;

    private final String name;

    private final String required;

    private DeploymentSpecificationsField(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
        this.conditionals = builder.conditionals;
        this.description = builder.description;
        this.name = builder.name;
        this.required = builder.required;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedValues() {
        return allowedValues != null && !(allowedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed values of the deployment specification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedValues} method.
     * </p>
     * 
     * @return The allowed values of the deployment specification.
     */
    public final List<String> allowedValues() {
        return allowedValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditionals property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConditionals() {
        return conditionals != null && !(conditionals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conditionals used for the deployment specification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditionals} method.
     * </p>
     * 
     * @return The conditionals used for the deployment specification.
     */
    public final List<DeploymentConditionalField> conditionals() {
        return conditionals;
    }

    /**
     * <p>
     * The description of the deployment specification.
     * </p>
     * 
     * @return The description of the deployment specification.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the deployment specification.
     * </p>
     * 
     * @return The name of the deployment specification.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates if the deployment specification is required.
     * </p>
     * 
     * @return Indicates if the deployment specification is required.
     */
    public final String required() {
        return required;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedValues() ? allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConditionals() ? conditionals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentSpecificationsField)) {
            return false;
        }
        DeploymentSpecificationsField other = (DeploymentSpecificationsField) obj;
        return hasAllowedValues() == other.hasAllowedValues() && Objects.equals(allowedValues(), other.allowedValues())
                && hasConditionals() == other.hasConditionals() && Objects.equals(conditionals(), other.conditionals())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(required(), other.required());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentSpecificationsField")
                .add("AllowedValues", hasAllowedValues() ? allowedValues() : null)
                .add("Conditionals", hasConditionals() ? conditionals() : null).add("Description", description())
                .add("Name", name()).add("Required", required()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "conditionals":
            return Optional.ofNullable(clazz.cast(conditionals()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowedValues", ALLOWED_VALUES_FIELD);
        map.put("conditionals", CONDITIONALS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("required", REQUIRED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentSpecificationsField, T> g) {
        return obj -> g.apply((DeploymentSpecificationsField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentSpecificationsField> {
        /**
         * <p>
         * The allowed values of the deployment specification.
         * </p>
         * 
         * @param allowedValues
         *        The allowed values of the deployment specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<String> allowedValues);

        /**
         * <p>
         * The allowed values of the deployment specification.
         * </p>
         * 
         * @param allowedValues
         *        The allowed values of the deployment specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String... allowedValues);

        /**
         * <p>
         * The conditionals used for the deployment specification.
         * </p>
         * 
         * @param conditionals
         *        The conditionals used for the deployment specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionals(Collection<DeploymentConditionalField> conditionals);

        /**
         * <p>
         * The conditionals used for the deployment specification.
         * </p>
         * 
         * @param conditionals
         *        The conditionals used for the deployment specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionals(DeploymentConditionalField... conditionals);

        /**
         * <p>
         * The conditionals used for the deployment specification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.launchwizard.model.DeploymentConditionalField.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.launchwizard.model.DeploymentConditionalField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.launchwizard.model.DeploymentConditionalField.Builder#build()} is
         * called immediately and its result is passed to {@link #conditionals(List<DeploymentConditionalField>)}.
         * 
         * @param conditionals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.launchwizard.model.DeploymentConditionalField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionals(java.util.Collection<DeploymentConditionalField>)
         */
        Builder conditionals(Consumer<DeploymentConditionalField.Builder>... conditionals);

        /**
         * <p>
         * The description of the deployment specification.
         * </p>
         * 
         * @param description
         *        The description of the deployment specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the deployment specification.
         * </p>
         * 
         * @param name
         *        The name of the deployment specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates if the deployment specification is required.
         * </p>
         * 
         * @param required
         *        Indicates if the deployment specification is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(String required);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private List<DeploymentConditionalField> conditionals = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String name;

        private String required;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentSpecificationsField model) {
            allowedValues(model.allowedValues);
            conditionals(model.conditionals);
            description(model.description);
            name(model.name);
            required(model.required);
        }

        public final Collection<String> getAllowedValues() {
            if (allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final List<DeploymentConditionalField.Builder> getConditionals() {
            List<DeploymentConditionalField.Builder> result = SpecificationsConditionalDataCopier
                    .copyToBuilder(this.conditionals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditionals(Collection<DeploymentConditionalField.BuilderImpl> conditionals) {
            this.conditionals = SpecificationsConditionalDataCopier.copyFromBuilder(conditionals);
        }

        @Override
        public final Builder conditionals(Collection<DeploymentConditionalField> conditionals) {
            this.conditionals = SpecificationsConditionalDataCopier.copy(conditionals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionals(DeploymentConditionalField... conditionals) {
            conditionals(Arrays.asList(conditionals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionals(Consumer<DeploymentConditionalField.Builder>... conditionals) {
            conditionals(Stream.of(conditionals).map(c -> DeploymentConditionalField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequired() {
            return required;
        }

        public final void setRequired(String required) {
            this.required = required;
        }

        @Override
        public final Builder required(String required) {
            this.required = required;
            return this;
        }

        @Override
        public DeploymentSpecificationsField build() {
            return new DeploymentSpecificationsField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
