/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeploymentEventsResponse extends LaunchWizardResponse implements
        ToCopyableBuilder<ListDeploymentEventsResponse.Builder, ListDeploymentEventsResponse> {
    private static final SdkField<List<DeploymentEventDataSummary>> DEPLOYMENT_EVENTS_FIELD = SdkField
            .<List<DeploymentEventDataSummary>> builder(MarshallingType.LIST)
            .memberName("deploymentEvents")
            .getter(getter(ListDeploymentEventsResponse::deploymentEvents))
            .setter(setter(Builder::deploymentEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentEventDataSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentEventDataSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDeploymentEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DeploymentEventDataSummary> deploymentEvents;

    private final String nextToken;

    private ListDeploymentEventsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentEvents = builder.deploymentEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeploymentEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeploymentEvents() {
        return deploymentEvents != null && !(deploymentEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the deployment events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeploymentEvents} method.
     * </p>
     * 
     * @return Lists the deployment events.
     */
    public final List<DeploymentEventDataSummary> deploymentEvents() {
        return deploymentEvents;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentEvents() ? deploymentEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentEventsResponse)) {
            return false;
        }
        ListDeploymentEventsResponse other = (ListDeploymentEventsResponse) obj;
        return hasDeploymentEvents() == other.hasDeploymentEvents()
                && Objects.equals(deploymentEvents(), other.deploymentEvents()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDeploymentEventsResponse")
                .add("DeploymentEvents", hasDeploymentEvents() ? deploymentEvents() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentEvents":
            return Optional.ofNullable(clazz.cast(deploymentEvents()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deploymentEvents", DEPLOYMENT_EVENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentEventsResponse, T> g) {
        return obj -> g.apply((ListDeploymentEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LaunchWizardResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDeploymentEventsResponse> {
        /**
         * <p>
         * Lists the deployment events.
         * </p>
         * 
         * @param deploymentEvents
         *        Lists the deployment events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentEvents(Collection<DeploymentEventDataSummary> deploymentEvents);

        /**
         * <p>
         * Lists the deployment events.
         * </p>
         * 
         * @param deploymentEvents
         *        Lists the deployment events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentEvents(DeploymentEventDataSummary... deploymentEvents);

        /**
         * <p>
         * Lists the deployment events.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.launchwizard.model.DeploymentEventDataSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.launchwizard.model.DeploymentEventDataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.launchwizard.model.DeploymentEventDataSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #deploymentEvents(List<DeploymentEventDataSummary>)}.
         * 
         * @param deploymentEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.launchwizard.model.DeploymentEventDataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentEvents(java.util.Collection<DeploymentEventDataSummary>)
         */
        Builder deploymentEvents(Consumer<DeploymentEventDataSummary.Builder>... deploymentEvents);

        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LaunchWizardResponse.BuilderImpl implements Builder {
        private List<DeploymentEventDataSummary> deploymentEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentEventsResponse model) {
            super(model);
            deploymentEvents(model.deploymentEvents);
            nextToken(model.nextToken);
        }

        public final List<DeploymentEventDataSummary.Builder> getDeploymentEvents() {
            List<DeploymentEventDataSummary.Builder> result = DeploymentEventDataSummaryListCopier
                    .copyToBuilder(this.deploymentEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentEvents(Collection<DeploymentEventDataSummary.BuilderImpl> deploymentEvents) {
            this.deploymentEvents = DeploymentEventDataSummaryListCopier.copyFromBuilder(deploymentEvents);
        }

        @Override
        public final Builder deploymentEvents(Collection<DeploymentEventDataSummary> deploymentEvents) {
            this.deploymentEvents = DeploymentEventDataSummaryListCopier.copy(deploymentEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentEvents(DeploymentEventDataSummary... deploymentEvents) {
            deploymentEvents(Arrays.asList(deploymentEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentEvents(Consumer<DeploymentEventDataSummary.Builder>... deploymentEvents) {
            deploymentEvents(Stream.of(deploymentEvents).map(c -> DeploymentEventDataSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeploymentEventsResponse build() {
            return new ListDeploymentEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
