/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkloadDeploymentPatternRequest extends LaunchWizardRequest implements
        ToCopyableBuilder<GetWorkloadDeploymentPatternRequest.Builder, GetWorkloadDeploymentPatternRequest> {
    private static final SdkField<String> DEPLOYMENT_PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentPatternName").getter(getter(GetWorkloadDeploymentPatternRequest::deploymentPatternName))
            .setter(setter(Builder::deploymentPatternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPatternName").build())
            .build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadName").getter(getter(GetWorkloadDeploymentPatternRequest::workloadName))
            .setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_PATTERN_NAME_FIELD,
            WORKLOAD_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String deploymentPatternName;

    private final String workloadName;

    private GetWorkloadDeploymentPatternRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentPatternName = builder.deploymentPatternName;
        this.workloadName = builder.workloadName;
    }

    /**
     * <p>
     * The name of the deployment pattern.
     * </p>
     * 
     * @return The name of the deployment pattern.
     */
    public final String deploymentPatternName() {
        return deploymentPatternName;
    }

    /**
     * <p>
     * The name of the workload.
     * </p>
     * 
     * @return The name of the workload.
     */
    public final String workloadName() {
        return workloadName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentPatternName());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkloadDeploymentPatternRequest)) {
            return false;
        }
        GetWorkloadDeploymentPatternRequest other = (GetWorkloadDeploymentPatternRequest) obj;
        return Objects.equals(deploymentPatternName(), other.deploymentPatternName())
                && Objects.equals(workloadName(), other.workloadName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkloadDeploymentPatternRequest").add("DeploymentPatternName", deploymentPatternName())
                .add("WorkloadName", workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentPatternName":
            return Optional.ofNullable(clazz.cast(deploymentPatternName()));
        case "workloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deploymentPatternName", DEPLOYMENT_PATTERN_NAME_FIELD);
        map.put("workloadName", WORKLOAD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkloadDeploymentPatternRequest, T> g) {
        return obj -> g.apply((GetWorkloadDeploymentPatternRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LaunchWizardRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkloadDeploymentPatternRequest> {
        /**
         * <p>
         * The name of the deployment pattern.
         * </p>
         * 
         * @param deploymentPatternName
         *        The name of the deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentPatternName(String deploymentPatternName);

        /**
         * <p>
         * The name of the workload.
         * </p>
         * 
         * @param workloadName
         *        The name of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LaunchWizardRequest.BuilderImpl implements Builder {
        private String deploymentPatternName;

        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkloadDeploymentPatternRequest model) {
            super(model);
            deploymentPatternName(model.deploymentPatternName);
            workloadName(model.workloadName);
        }

        public final String getDeploymentPatternName() {
            return deploymentPatternName;
        }

        public final void setDeploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
        }

        @Override
        public final Builder deploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkloadDeploymentPatternRequest build() {
            return new GetWorkloadDeploymentPatternRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
