/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadData implements SdkPojo, Serializable, ToCopyableBuilder<WorkloadData.Builder, WorkloadData> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(WorkloadData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(WorkloadData::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> DOCUMENTATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentationUrl").getter(getter(WorkloadData::documentationUrl))
            .setter(setter(Builder::documentationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentationUrl").build()).build();

    private static final SdkField<String> ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iconUrl").getter(getter(WorkloadData::iconUrl)).setter(setter(Builder::iconUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iconUrl").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorkloadData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(WorkloadData::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadName").getter(getter(WorkloadData::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, DOCUMENTATION_URL_FIELD, ICON_URL_FIELD,
                    STATUS_FIELD, STATUS_MESSAGE_FIELD, WORKLOAD_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String displayName;

    private final String documentationUrl;

    private final String iconUrl;

    private final String status;

    private final String statusMessage;

    private final String workloadName;

    private WorkloadData(BuilderImpl builder) {
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.documentationUrl = builder.documentationUrl;
        this.iconUrl = builder.iconUrl;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.workloadName = builder.workloadName;
    }

    /**
     * <p>
     * The description of a workload.
     * </p>
     * 
     * @return The description of a workload.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of a workload.
     * </p>
     * 
     * @return The display name of a workload.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The URL of a workload document.
     * </p>
     * 
     * @return The URL of a workload document.
     */
    public final String documentationUrl() {
        return documentationUrl;
    }

    /**
     * <p>
     * The URL of a workload icon.
     * </p>
     * 
     * @return The URL of a workload icon.
     */
    public final String iconUrl() {
        return iconUrl;
    }

    /**
     * <p>
     * The status of a workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a workload.
     * @see WorkloadStatus
     */
    public final WorkloadStatus status() {
        return WorkloadStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a workload.
     * @see WorkloadStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The message about a workload's status.
     * </p>
     * 
     * @return The message about a workload's status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The name of the workload.
     * </p>
     * 
     * @return The name of the workload.
     */
    public final String workloadName() {
        return workloadName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(documentationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(iconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadData)) {
            return false;
        }
        WorkloadData other = (WorkloadData) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(documentationUrl(), other.documentationUrl()) && Objects.equals(iconUrl(), other.iconUrl())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(workloadName(), other.workloadName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadData").add("Description", description()).add("DisplayName", displayName())
                .add("DocumentationUrl", documentationUrl()).add("IconUrl", iconUrl()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("WorkloadName", workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "documentationUrl":
            return Optional.ofNullable(clazz.cast(documentationUrl()));
        case "iconUrl":
            return Optional.ofNullable(clazz.cast(iconUrl()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "workloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("documentationUrl", DOCUMENTATION_URL_FIELD);
        map.put("iconUrl", ICON_URL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("workloadName", WORKLOAD_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadData, T> g) {
        return obj -> g.apply((WorkloadData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadData> {
        /**
         * <p>
         * The description of a workload.
         * </p>
         * 
         * @param description
         *        The description of a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of a workload.
         * </p>
         * 
         * @param displayName
         *        The display name of a workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The URL of a workload document.
         * </p>
         * 
         * @param documentationUrl
         *        The URL of a workload document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentationUrl(String documentationUrl);

        /**
         * <p>
         * The URL of a workload icon.
         * </p>
         * 
         * @param iconUrl
         *        The URL of a workload icon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iconUrl(String iconUrl);

        /**
         * <p>
         * The status of a workload.
         * </p>
         * 
         * @param status
         *        The status of a workload.
         * @see WorkloadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a workload.
         * </p>
         * 
         * @param status
         *        The status of a workload.
         * @see WorkloadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadStatus
         */
        Builder status(WorkloadStatus status);

        /**
         * <p>
         * The message about a workload's status.
         * </p>
         * 
         * @param statusMessage
         *        The message about a workload's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The name of the workload.
         * </p>
         * 
         * @param workloadName
         *        The name of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String displayName;

        private String documentationUrl;

        private String iconUrl;

        private String status;

        private String statusMessage;

        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadData model) {
            description(model.description);
            displayName(model.displayName);
            documentationUrl(model.documentationUrl);
            iconUrl(model.iconUrl);
            status(model.status);
            statusMessage(model.statusMessage);
            workloadName(model.workloadName);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDocumentationUrl() {
            return documentationUrl;
        }

        public final void setDocumentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        @Override
        public final Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public final String getIconUrl() {
            return iconUrl;
        }

        public final void setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
        }

        @Override
        public final Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkloadStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        @Override
        public WorkloadData build() {
            return new WorkloadData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
