/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkloadDeploymentPatternResponse extends LaunchWizardResponse implements
        ToCopyableBuilder<GetWorkloadDeploymentPatternResponse.Builder, GetWorkloadDeploymentPatternResponse> {
    private static final SdkField<WorkloadDeploymentPatternData> WORKLOAD_DEPLOYMENT_PATTERN_FIELD = SdkField
            .<WorkloadDeploymentPatternData> builder(MarshallingType.SDK_POJO).memberName("workloadDeploymentPattern")
            .getter(getter(GetWorkloadDeploymentPatternResponse::workloadDeploymentPattern))
            .setter(setter(Builder::workloadDeploymentPattern)).constructor(WorkloadDeploymentPatternData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadDeploymentPattern").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WORKLOAD_DEPLOYMENT_PATTERN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WorkloadDeploymentPatternData workloadDeploymentPattern;

    private GetWorkloadDeploymentPatternResponse(BuilderImpl builder) {
        super(builder);
        this.workloadDeploymentPattern = builder.workloadDeploymentPattern;
    }

    /**
     * <p>
     * Details about the workload deployment pattern.
     * </p>
     * 
     * @return Details about the workload deployment pattern.
     */
    public final WorkloadDeploymentPatternData workloadDeploymentPattern() {
        return workloadDeploymentPattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadDeploymentPattern());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkloadDeploymentPatternResponse)) {
            return false;
        }
        GetWorkloadDeploymentPatternResponse other = (GetWorkloadDeploymentPatternResponse) obj;
        return Objects.equals(workloadDeploymentPattern(), other.workloadDeploymentPattern());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkloadDeploymentPatternResponse")
                .add("WorkloadDeploymentPattern", workloadDeploymentPattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workloadDeploymentPattern":
            return Optional.ofNullable(clazz.cast(workloadDeploymentPattern()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workloadDeploymentPattern", WORKLOAD_DEPLOYMENT_PATTERN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkloadDeploymentPatternResponse, T> g) {
        return obj -> g.apply((GetWorkloadDeploymentPatternResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LaunchWizardResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetWorkloadDeploymentPatternResponse> {
        /**
         * <p>
         * Details about the workload deployment pattern.
         * </p>
         * 
         * @param workloadDeploymentPattern
         *        Details about the workload deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadDeploymentPattern(WorkloadDeploymentPatternData workloadDeploymentPattern);

        /**
         * <p>
         * Details about the workload deployment pattern.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkloadDeploymentPatternData.Builder}
         * avoiding the need to create one manually via {@link WorkloadDeploymentPatternData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkloadDeploymentPatternData.Builder#build()} is called
         * immediately and its result is passed to {@link #workloadDeploymentPattern(WorkloadDeploymentPatternData)}.
         * 
         * @param workloadDeploymentPattern
         *        a consumer that will call methods on {@link WorkloadDeploymentPatternData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloadDeploymentPattern(WorkloadDeploymentPatternData)
         */
        default Builder workloadDeploymentPattern(Consumer<WorkloadDeploymentPatternData.Builder> workloadDeploymentPattern) {
            return workloadDeploymentPattern(WorkloadDeploymentPatternData.builder().applyMutation(workloadDeploymentPattern)
                    .build());
        }
    }

    static final class BuilderImpl extends LaunchWizardResponse.BuilderImpl implements Builder {
        private WorkloadDeploymentPatternData workloadDeploymentPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkloadDeploymentPatternResponse model) {
            super(model);
            workloadDeploymentPattern(model.workloadDeploymentPattern);
        }

        public final WorkloadDeploymentPatternData.Builder getWorkloadDeploymentPattern() {
            return workloadDeploymentPattern != null ? workloadDeploymentPattern.toBuilder() : null;
        }

        public final void setWorkloadDeploymentPattern(WorkloadDeploymentPatternData.BuilderImpl workloadDeploymentPattern) {
            this.workloadDeploymentPattern = workloadDeploymentPattern != null ? workloadDeploymentPattern.build() : null;
        }

        @Override
        public final Builder workloadDeploymentPattern(WorkloadDeploymentPatternData workloadDeploymentPattern) {
            this.workloadDeploymentPattern = workloadDeploymentPattern;
            return this;
        }

        @Override
        public GetWorkloadDeploymentPatternResponse build() {
            return new GetWorkloadDeploymentPatternResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
