/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkloadDeploymentPatternsResponse extends LaunchWizardResponse implements
        ToCopyableBuilder<ListWorkloadDeploymentPatternsResponse.Builder, ListWorkloadDeploymentPatternsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorkloadDeploymentPatternsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<WorkloadDeploymentPatternDataSummary>> WORKLOAD_DEPLOYMENT_PATTERNS_FIELD = SdkField
            .<List<WorkloadDeploymentPatternDataSummary>> builder(MarshallingType.LIST)
            .memberName("workloadDeploymentPatterns")
            .getter(getter(ListWorkloadDeploymentPatternsResponse::workloadDeploymentPatterns))
            .setter(setter(Builder::workloadDeploymentPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadDeploymentPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkloadDeploymentPatternDataSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkloadDeploymentPatternDataSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WORKLOAD_DEPLOYMENT_PATTERNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns;

    private ListWorkloadDeploymentPatternsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workloadDeploymentPatterns = builder.workloadDeploymentPatterns;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkloadDeploymentPatterns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWorkloadDeploymentPatterns() {
        return workloadDeploymentPatterns != null && !(workloadDeploymentPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the workload deployment patterns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkloadDeploymentPatterns} method.
     * </p>
     * 
     * @return Describes the workload deployment patterns.
     */
    public final List<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns() {
        return workloadDeploymentPatterns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkloadDeploymentPatterns() ? workloadDeploymentPatterns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadDeploymentPatternsResponse)) {
            return false;
        }
        ListWorkloadDeploymentPatternsResponse other = (ListWorkloadDeploymentPatternsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasWorkloadDeploymentPatterns() == other.hasWorkloadDeploymentPatterns()
                && Objects.equals(workloadDeploymentPatterns(), other.workloadDeploymentPatterns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkloadDeploymentPatternsResponse").add("NextToken", nextToken())
                .add("WorkloadDeploymentPatterns", hasWorkloadDeploymentPatterns() ? workloadDeploymentPatterns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "workloadDeploymentPatterns":
            return Optional.ofNullable(clazz.cast(workloadDeploymentPatterns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("workloadDeploymentPatterns", WORKLOAD_DEPLOYMENT_PATTERNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadDeploymentPatternsResponse, T> g) {
        return obj -> g.apply((ListWorkloadDeploymentPatternsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LaunchWizardResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWorkloadDeploymentPatternsResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Describes the workload deployment patterns.
         * </p>
         * 
         * @param workloadDeploymentPatterns
         *        Describes the workload deployment patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadDeploymentPatterns(Collection<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns);

        /**
         * <p>
         * Describes the workload deployment patterns.
         * </p>
         * 
         * @param workloadDeploymentPatterns
         *        Describes the workload deployment patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadDeploymentPatterns(WorkloadDeploymentPatternDataSummary... workloadDeploymentPatterns);

        /**
         * <p>
         * Describes the workload deployment patterns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.launchwizard.model.WorkloadDeploymentPatternDataSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.launchwizard.model.WorkloadDeploymentPatternDataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.launchwizard.model.WorkloadDeploymentPatternDataSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #workloadDeploymentPatterns(List<WorkloadDeploymentPatternDataSummary>)}.
         * 
         * @param workloadDeploymentPatterns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.launchwizard.model.WorkloadDeploymentPatternDataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloadDeploymentPatterns(java.util.Collection<WorkloadDeploymentPatternDataSummary>)
         */
        Builder workloadDeploymentPatterns(Consumer<WorkloadDeploymentPatternDataSummary.Builder>... workloadDeploymentPatterns);
    }

    static final class BuilderImpl extends LaunchWizardResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadDeploymentPatternsResponse model) {
            super(model);
            nextToken(model.nextToken);
            workloadDeploymentPatterns(model.workloadDeploymentPatterns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkloadDeploymentPatternDataSummary.Builder> getWorkloadDeploymentPatterns() {
            List<WorkloadDeploymentPatternDataSummary.Builder> result = WorkloadDeploymentPatternDataSummaryListCopier
                    .copyToBuilder(this.workloadDeploymentPatterns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkloadDeploymentPatterns(
                Collection<WorkloadDeploymentPatternDataSummary.BuilderImpl> workloadDeploymentPatterns) {
            this.workloadDeploymentPatterns = WorkloadDeploymentPatternDataSummaryListCopier
                    .copyFromBuilder(workloadDeploymentPatterns);
        }

        @Override
        public final Builder workloadDeploymentPatterns(
                Collection<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns) {
            this.workloadDeploymentPatterns = WorkloadDeploymentPatternDataSummaryListCopier.copy(workloadDeploymentPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadDeploymentPatterns(WorkloadDeploymentPatternDataSummary... workloadDeploymentPatterns) {
            workloadDeploymentPatterns(Arrays.asList(workloadDeploymentPatterns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadDeploymentPatterns(
                Consumer<WorkloadDeploymentPatternDataSummary.Builder>... workloadDeploymentPatterns) {
            workloadDeploymentPatterns(Stream.of(workloadDeploymentPatterns)
                    .map(c -> WorkloadDeploymentPatternDataSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkloadDeploymentPatternsResponse build() {
            return new ListWorkloadDeploymentPatternsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
