/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a workload deployment pattern.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadDeploymentPatternDataSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkloadDeploymentPatternDataSummary.Builder, WorkloadDeploymentPatternDataSummary> {
    private static final SdkField<String> DEPLOYMENT_PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentPatternName").getter(getter(WorkloadDeploymentPatternDataSummary::deploymentPatternName))
            .setter(setter(Builder::deploymentPatternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPatternName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(WorkloadDeploymentPatternDataSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(WorkloadDeploymentPatternDataSummary::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(WorkloadDeploymentPatternDataSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(WorkloadDeploymentPatternDataSummary::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadName").getter(getter(WorkloadDeploymentPatternDataSummary::workloadName))
            .setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()).build();

    private static final SdkField<String> WORKLOAD_VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workloadVersionName").getter(getter(WorkloadDeploymentPatternDataSummary::workloadVersionName))
            .setter(setter(Builder::workloadVersionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadVersionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_PATTERN_NAME_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, WORKLOAD_NAME_FIELD,
            WORKLOAD_VERSION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deploymentPatternName;

    private final String description;

    private final String displayName;

    private final String status;

    private final String statusMessage;

    private final String workloadName;

    private final String workloadVersionName;

    private WorkloadDeploymentPatternDataSummary(BuilderImpl builder) {
        this.deploymentPatternName = builder.deploymentPatternName;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.workloadName = builder.workloadName;
        this.workloadVersionName = builder.workloadVersionName;
    }

    /**
     * <p>
     * The name of a workload deployment pattern.
     * </p>
     * 
     * @return The name of a workload deployment pattern.
     */
    public final String deploymentPatternName() {
        return deploymentPatternName;
    }

    /**
     * <p>
     * The description of a workload deployment pattern.
     * </p>
     * 
     * @return The description of a workload deployment pattern.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of a workload deployment pattern.
     * </p>
     * 
     * @return The display name of a workload deployment pattern.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The status of a workload deployment pattern.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadDeploymentPatternStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a workload deployment pattern.
     * @see WorkloadDeploymentPatternStatus
     */
    public final WorkloadDeploymentPatternStatus status() {
        return WorkloadDeploymentPatternStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a workload deployment pattern.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkloadDeploymentPatternStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a workload deployment pattern.
     * @see WorkloadDeploymentPatternStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message about a workload deployment pattern's status.
     * </p>
     * 
     * @return A message about a workload deployment pattern's status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The name of the workload.
     * </p>
     * 
     * @return The name of the workload.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * <p>
     * The name of the workload deployment pattern version.
     * </p>
     * 
     * @return The name of the workload deployment pattern version.
     */
    public final String workloadVersionName() {
        return workloadVersionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentPatternName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(workloadVersionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadDeploymentPatternDataSummary)) {
            return false;
        }
        WorkloadDeploymentPatternDataSummary other = (WorkloadDeploymentPatternDataSummary) obj;
        return Objects.equals(deploymentPatternName(), other.deploymentPatternName())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(workloadName(), other.workloadName())
                && Objects.equals(workloadVersionName(), other.workloadVersionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadDeploymentPatternDataSummary").add("DeploymentPatternName", deploymentPatternName())
                .add("Description", description()).add("DisplayName", displayName()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("WorkloadName", workloadName())
                .add("WorkloadVersionName", workloadVersionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentPatternName":
            return Optional.ofNullable(clazz.cast(deploymentPatternName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "workloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "workloadVersionName":
            return Optional.ofNullable(clazz.cast(workloadVersionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deploymentPatternName", DEPLOYMENT_PATTERN_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("workloadName", WORKLOAD_NAME_FIELD);
        map.put("workloadVersionName", WORKLOAD_VERSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadDeploymentPatternDataSummary, T> g) {
        return obj -> g.apply((WorkloadDeploymentPatternDataSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadDeploymentPatternDataSummary> {
        /**
         * <p>
         * The name of a workload deployment pattern.
         * </p>
         * 
         * @param deploymentPatternName
         *        The name of a workload deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentPatternName(String deploymentPatternName);

        /**
         * <p>
         * The description of a workload deployment pattern.
         * </p>
         * 
         * @param description
         *        The description of a workload deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of a workload deployment pattern.
         * </p>
         * 
         * @param displayName
         *        The display name of a workload deployment pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The status of a workload deployment pattern.
         * </p>
         * 
         * @param status
         *        The status of a workload deployment pattern.
         * @see WorkloadDeploymentPatternStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadDeploymentPatternStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a workload deployment pattern.
         * </p>
         * 
         * @param status
         *        The status of a workload deployment pattern.
         * @see WorkloadDeploymentPatternStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkloadDeploymentPatternStatus
         */
        Builder status(WorkloadDeploymentPatternStatus status);

        /**
         * <p>
         * A message about a workload deployment pattern's status.
         * </p>
         * 
         * @param statusMessage
         *        A message about a workload deployment pattern's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The name of the workload.
         * </p>
         * 
         * @param workloadName
         *        The name of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * <p>
         * The name of the workload deployment pattern version.
         * </p>
         * 
         * @param workloadVersionName
         *        The name of the workload deployment pattern version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadVersionName(String workloadVersionName);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentPatternName;

        private String description;

        private String displayName;

        private String status;

        private String statusMessage;

        private String workloadName;

        private String workloadVersionName;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadDeploymentPatternDataSummary model) {
            deploymentPatternName(model.deploymentPatternName);
            description(model.description);
            displayName(model.displayName);
            status(model.status);
            statusMessage(model.statusMessage);
            workloadName(model.workloadName);
            workloadVersionName(model.workloadVersionName);
        }

        public final String getDeploymentPatternName() {
            return deploymentPatternName;
        }

        public final void setDeploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
        }

        @Override
        public final Builder deploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkloadDeploymentPatternStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getWorkloadVersionName() {
            return workloadVersionName;
        }

        public final void setWorkloadVersionName(String workloadVersionName) {
            this.workloadVersionName = workloadVersionName;
        }

        @Override
        public final Builder workloadVersionName(String workloadVersionName) {
            this.workloadVersionName = workloadVersionName;
            return this;
        }

        @Override
        public WorkloadDeploymentPatternDataSummary build() {
            return new WorkloadDeploymentPatternDataSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
