/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.BuiltinSlotTypeMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a built in slot type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BuiltinSlotTypeMetadata implements StructuredPojo,
        ToCopyableBuilder<BuiltinSlotTypeMetadata.Builder, BuiltinSlotTypeMetadata> {
    private final String signature;

    private final List<String> supportedLocales;

    private BuiltinSlotTypeMetadata(BuilderImpl builder) {
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
    }

    /**
     * <p>
     * A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     *         >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     */
    public String signature() {
        return signature;
    }

    /**
     * <p>
     * A list of target locales for the slot.
     * </p>
     * 
     * @return A list of target locales for the slot.
     * @see Locale
     */
    public List<String> supportedLocales() {
        return supportedLocales;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((signature() == null) ? 0 : signature().hashCode());
        hashCode = 31 * hashCode + ((supportedLocales() == null) ? 0 : supportedLocales().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltinSlotTypeMetadata)) {
            return false;
        }
        BuiltinSlotTypeMetadata other = (BuiltinSlotTypeMetadata) obj;
        if (other.signature() == null ^ this.signature() == null) {
            return false;
        }
        if (other.signature() != null && !other.signature().equals(this.signature())) {
            return false;
        }
        if (other.supportedLocales() == null ^ this.supportedLocales() == null) {
            return false;
        }
        if (other.supportedLocales() != null && !other.supportedLocales().equals(this.supportedLocales())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (signature() != null) {
            sb.append("Signature: ").append(signature()).append(",");
        }
        if (supportedLocales() != null) {
            sb.append("SupportedLocales: ").append(supportedLocales()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuiltinSlotTypeMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BuiltinSlotTypeMetadata> {
        /**
         * <p>
         * A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param signature
         *        A unique identifier for the built-in slot type. To find the signature for a slot type, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         *        >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder supportedLocales(Collection<String> supportedLocales);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSupportedLocales(java.util.Collection)} or {@link #withSupportedLocales(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder supportedLocales(String... supportedLocales);

        /**
         * <p>
         * A list of target locales for the slot.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSupportedLocales(java.util.Collection)} or {@link #withSupportedLocales(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param supportedLocales
         *        A list of target locales for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder supportedLocales(Locale... supportedLocales);
    }

    private static final class BuilderImpl implements Builder {
        private String signature;

        private List<String> supportedLocales;

        private BuilderImpl() {
        }

        private BuilderImpl(BuiltinSlotTypeMetadata model) {
            setSignature(model.signature);
            setSupportedLocales(model.supportedLocales);
        }

        public final String getSignature() {
            return signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocales() {
            return supportedLocales;
        }

        @Override
        public final Builder supportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(String... supportedLocales) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new ArrayList<>(supportedLocales.length);
            }
            for (String e : supportedLocales) {
                this.supportedLocales.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(Locale... supportedLocales) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new ArrayList<String>(supportedLocales.length);
            }
            for (Locale ele : supportedLocales) {
                this.supportedLocales.add(ele.toString());
            }
            return this;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        @SafeVarargs
        public final void setSupportedLocales(String... supportedLocales) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new ArrayList<>(supportedLocales.length);
            }
            for (String e : supportedLocales) {
                this.supportedLocales.add(e);
            }
        }

        @SafeVarargs
        public final void setSupportedLocales(Locale... supportedLocales) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new ArrayList<String>(supportedLocales.length);
            }
            for (Locale ele : supportedLocales) {
                this.supportedLocales.add(ele.toString());
            }
        }

        @Override
        public BuiltinSlotTypeMetadata build() {
            return new BuiltinSlotTypeMetadata(this);
        }
    }
}
