/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.EnumerationValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each slot type can have a set of values. Each enumeration value represents a value the slot type can take.
 * </p>
 * <p>
 * For example, a pizza ordering bot could have a slot type that specifies the type of crust that the pizza should have.
 * The slot type could include the values
 * </p>
 * <ul>
 * <li>
 * <p>
 * thick
 * </p>
 * </li>
 * <li>
 * <p>
 * thin
 * </p>
 * </li>
 * <li>
 * <p>
 * stuffed
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public class EnumerationValue implements StructuredPojo, ToCopyableBuilder<EnumerationValue.Builder, EnumerationValue> {
    private final String value;

    private EnumerationValue(BuilderImpl builder) {
        this.value = builder.value;
    }

    /**
     * <p>
     * The value of the slot type.
     * </p>
     * 
     * @return The value of the slot type.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumerationValue)) {
            return false;
        }
        EnumerationValue other = (EnumerationValue) obj;
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnumerationValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EnumerationValue> {
        /**
         * <p>
         * The value of the slot type.
         * </p>
         * 
         * @param value
         *        The value of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    private static final class BuilderImpl implements Builder {
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(EnumerationValue model) {
            setValue(model.value);
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public EnumerationValue build() {
            return new EnumerationValue(this);
        }
    }
}
