/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Date;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBotChannelAssociationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBotChannelAssociationResponse.Builder, GetBotChannelAssociationResponse> {
    private final String name;

    private final String description;

    private final String botAlias;

    private final String botName;

    private final Date createdDate;

    private final String type;

    private final Map<String, String> botConfiguration;

    private GetBotChannelAssociationResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.botAlias = builder.botAlias;
        this.botName = builder.botName;
        this.createdDate = builder.createdDate;
        this.type = builder.type;
        this.botConfiguration = builder.botConfiguration;
    }

    /**
     * <p>
     * The name of the association between the bot and the channel.
     * </p>
     * 
     * @return The name of the association between the bot and the channel.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the association between the bot and the channel.
     * </p>
     * 
     * @return A description of the association between the bot and the channel.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
     * </p>
     * 
     * @return An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
     */
    public String botAlias() {
        return botAlias;
    }

    /**
     * <p>
     * The name of the Amazon Lex bot.
     * </p>
     * 
     * @return The name of the Amazon Lex bot.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * The date that the association between the bot and the channel was created.
     * </p>
     * 
     * @return The date that the association between the bot and the channel was created.
     */
    public Date createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The type of the messaging platform.
     * </p>
     * 
     * @return The type of the messaging platform.
     * @see ChannelType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * Provides information that the messaging platform needs to communicate with the Amazon Lex bot.
     * </p>
     * 
     * @return Provides information that the messaging platform needs to communicate with the Amazon Lex bot.
     */
    public Map<String, String> botConfiguration() {
        return botConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((botAlias() == null) ? 0 : botAlias().hashCode());
        hashCode = 31 * hashCode + ((botName() == null) ? 0 : botName().hashCode());
        hashCode = 31 * hashCode + ((createdDate() == null) ? 0 : createdDate().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((botConfiguration() == null) ? 0 : botConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBotChannelAssociationResponse)) {
            return false;
        }
        GetBotChannelAssociationResponse other = (GetBotChannelAssociationResponse) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.botAlias() == null ^ this.botAlias() == null) {
            return false;
        }
        if (other.botAlias() != null && !other.botAlias().equals(this.botAlias())) {
            return false;
        }
        if (other.botName() == null ^ this.botName() == null) {
            return false;
        }
        if (other.botName() != null && !other.botName().equals(this.botName())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.botConfiguration() == null ^ this.botConfiguration() == null) {
            return false;
        }
        if (other.botConfiguration() != null && !other.botConfiguration().equals(this.botConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (botAlias() != null) {
            sb.append("BotAlias: ").append(botAlias()).append(",");
        }
        if (botName() != null) {
            sb.append("BotName: ").append(botName()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (botConfiguration() != null) {
            sb.append("BotConfiguration: ").append(botConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBotChannelAssociationResponse> {
        /**
         * <p>
         * The name of the association between the bot and the channel.
         * </p>
         * 
         * @param name
         *        The name of the association between the bot and the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the association between the bot and the channel.
         * </p>
         * 
         * @param description
         *        A description of the association between the bot and the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An alias pointing to the specific version of the Amazon Lex bot to which this association is being made.
         * </p>
         * 
         * @param botAlias
         *        An alias pointing to the specific version of the Amazon Lex bot to which this association is being
         *        made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAlias(String botAlias);

        /**
         * <p>
         * The name of the Amazon Lex bot.
         * </p>
         * 
         * @param botName
         *        The name of the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The date that the association between the bot and the channel was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the association between the bot and the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Date createdDate);

        /**
         * <p>
         * The type of the messaging platform.
         * </p>
         * 
         * @param type
         *        The type of the messaging platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the messaging platform.
         * </p>
         * 
         * @param type
         *        The type of the messaging platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder type(ChannelType type);

        /**
         * <p>
         * Provides information that the messaging platform needs to communicate with the Amazon Lex bot.
         * </p>
         * 
         * @param botConfiguration
         *        Provides information that the messaging platform needs to communicate with the Amazon Lex bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botConfiguration(Map<String, String> botConfiguration);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String botAlias;

        private String botName;

        private Date createdDate;

        private String type;

        private Map<String, String> botConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBotChannelAssociationResponse model) {
            setName(model.name);
            setDescription(model.description);
            setBotAlias(model.botAlias);
            setBotName(model.botName);
            setCreatedDate(model.createdDate);
            setType(model.type);
            setBotConfiguration(model.botConfiguration);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getBotAlias() {
            return botAlias;
        }

        @Override
        public final Builder botAlias(String botAlias) {
            this.botAlias = botAlias;
            return this;
        }

        public final void setBotAlias(String botAlias) {
            this.botAlias = botAlias;
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Date getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Date createdDate) {
            this.createdDate = StandardMemberCopier.copy(createdDate);
            return this;
        }

        public final void setCreatedDate(Date createdDate) {
            this.createdDate = StandardMemberCopier.copy(createdDate);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(ChannelType type) {
            this.type(type.toString());
        }

        public final Map<String, String> getBotConfiguration() {
            return botConfiguration;
        }

        @Override
        public final Builder botConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
            return this;
        }

        public final void setBotConfiguration(Map<String, String> botConfiguration) {
            this.botConfiguration = ChannelConfigurationMapCopier.copy(botConfiguration);
        }

        @Override
        public GetBotChannelAssociationResponse build() {
            return new GetBotChannelAssociationResponse(this);
        }
    }
}
