/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBuiltinSlotTypesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetBuiltinSlotTypesRequest.Builder, GetBuiltinSlotTypesRequest> {
    private final String locale;

    private final String signatureContains;

    private final String nextToken;

    private final Integer maxResults;

    private GetBuiltinSlotTypesRequest(BuilderImpl builder) {
        this.locale = builder.locale;
        this.signatureContains = builder.signatureContains;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * A list of locales that the slot type supports.
     * </p>
     * 
     * @return A list of locales that the slot type supports.
     * @see Locale
     */
    public String locale() {
        return locale;
    }

    /**
     * <p>
     * Substring to match in built-in slot type signatures. A slot type will be returned if any part of its signature
     * matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     * </p>
     * 
     * @return Substring to match in built-in slot type signatures. A slot type will be returned if any part of its
     *         signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
     */
    public String signatureContains() {
        return signatureContains;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of slot types. If the response to this API call is truncated,
     * Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the
     * pagination token in the next request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of slot types. If the response to this API call is
     *         truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot types,
     *         specify the pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of slot types to return in the response. The default is 10.
     * </p>
     * 
     * @return The maximum number of slot types to return in the response. The default is 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((locale() == null) ? 0 : locale().hashCode());
        hashCode = 31 * hashCode + ((signatureContains() == null) ? 0 : signatureContains().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinSlotTypesRequest)) {
            return false;
        }
        GetBuiltinSlotTypesRequest other = (GetBuiltinSlotTypesRequest) obj;
        if (other.locale() == null ^ this.locale() == null) {
            return false;
        }
        if (other.locale() != null && !other.locale().equals(this.locale())) {
            return false;
        }
        if (other.signatureContains() == null ^ this.signatureContains() == null) {
            return false;
        }
        if (other.signatureContains() != null && !other.signatureContains().equals(this.signatureContains())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (locale() != null) {
            sb.append("Locale: ").append(locale()).append(",");
        }
        if (signatureContains() != null) {
            sb.append("SignatureContains: ").append(signatureContains()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBuiltinSlotTypesRequest> {
        /**
         * <p>
         * A list of locales that the slot type supports.
         * </p>
         * 
         * @param locale
         *        A list of locales that the slot type supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * A list of locales that the slot type supports.
         * </p>
         * 
         * @param locale
         *        A list of locales that the slot type supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * Substring to match in built-in slot type signatures. A slot type will be returned if any part of its
         * signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * </p>
         * 
         * @param signatureContains
         *        Substring to match in built-in slot type signatures. A slot type will be returned if any part of its
         *        signature matches the substring. For example, "xyz" matches both "xyzabc" and "abcxyz."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureContains(String signatureContains);

        /**
         * <p>
         * A pagination token that fetches the next page of slot types. If the response to this API call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of slot types, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of slot types. If the response to this API call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of slot
         *        types, specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of slot types to return in the response. The default is 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of slot types to return in the response. The default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    private static final class BuilderImpl implements Builder {
        private String locale;

        private String signatureContains;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinSlotTypesRequest model) {
            setLocale(model.locale);
            setSignatureContains(model.signatureContains);
            setNextToken(model.nextToken);
            setMaxResults(model.maxResults);
        }

        public final String getLocale() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final void setLocale(Locale locale) {
            this.locale(locale.toString());
        }

        public final String getSignatureContains() {
            return signatureContains;
        }

        @Override
        public final Builder signatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
            return this;
        }

        public final void setSignatureContains(String signatureContains) {
            this.signatureContains = signatureContains;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public GetBuiltinSlotTypesRequest build() {
            return new GetBuiltinSlotTypesRequest(this);
        }
    }
}
