/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBuiltinSlotTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetBuiltinSlotTypesResponse.Builder, GetBuiltinSlotTypesResponse> {
    private final List<BuiltinSlotTypeMetadata> slotTypes;

    private final String nextToken;

    private GetBuiltinSlotTypesResponse(BuilderImpl builder) {
        this.slotTypes = builder.slotTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
     * </p>
     * 
     * @return An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
     */
    public List<BuiltinSlotTypeMetadata> slotTypes() {
        return slotTypes;
    }

    /**
     * <p>
     * If the response is truncated, the response includes a pagination token that you can use in your next request to
     * fetch the next page of slot types.
     * </p>
     * 
     * @return If the response is truncated, the response includes a pagination token that you can use in your next
     *         request to fetch the next page of slot types.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((slotTypes() == null) ? 0 : slotTypes().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinSlotTypesResponse)) {
            return false;
        }
        GetBuiltinSlotTypesResponse other = (GetBuiltinSlotTypesResponse) obj;
        if (other.slotTypes() == null ^ this.slotTypes() == null) {
            return false;
        }
        if (other.slotTypes() != null && !other.slotTypes().equals(this.slotTypes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (slotTypes() != null) {
            sb.append("SlotTypes: ").append(slotTypes()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetBuiltinSlotTypesResponse> {
        /**
         * <p>
         * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * </p>
         * 
         * @param slotTypes
         *        An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(Collection<BuiltinSlotTypeMetadata> slotTypes);

        /**
         * <p>
         * An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSlotTypes(java.util.Collection)} or {@link #withSlotTypes(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param slotTypes
         *        An array of <code>BuiltInSlotTypeMetadata</code> objects, one entry for each slot type returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypes(BuiltinSlotTypeMetadata... slotTypes);

        /**
         * <p>
         * If the response is truncated, the response includes a pagination token that you can use in your next request
         * to fetch the next page of slot types.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, the response includes a pagination token that you can use in your next
         *        request to fetch the next page of slot types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<BuiltinSlotTypeMetadata> slotTypes;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinSlotTypesResponse model) {
            setSlotTypes(model.slotTypes);
            setNextToken(model.nextToken);
        }

        public final Collection<BuiltinSlotTypeMetadata> getSlotTypes() {
            return slotTypes;
        }

        @Override
        public final Builder slotTypes(Collection<BuiltinSlotTypeMetadata> slotTypes) {
            this.slotTypes = BuiltinSlotTypeMetadataListCopier.copy(slotTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(BuiltinSlotTypeMetadata... slotTypes) {
            if (this.slotTypes == null) {
                this.slotTypes = new ArrayList<>(slotTypes.length);
            }
            for (BuiltinSlotTypeMetadata e : slotTypes) {
                this.slotTypes.add(e);
            }
            return this;
        }

        public final void setSlotTypes(Collection<BuiltinSlotTypeMetadata> slotTypes) {
            this.slotTypes = BuiltinSlotTypeMetadataListCopier.copy(slotTypes);
        }

        @SafeVarargs
        public final void setSlotTypes(BuiltinSlotTypeMetadata... slotTypes) {
            if (this.slotTypes == null) {
                this.slotTypes = new ArrayList<>(slotTypes.length);
            }
            for (BuiltinSlotTypeMetadata e : slotTypes) {
                this.slotTypes.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBuiltinSlotTypesResponse build() {
            return new GetBuiltinSlotTypesResponse(this);
        }
    }
}
