/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSlotTypeResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetSlotTypeResponse.Builder, GetSlotTypeResponse> {
    private final String name;

    private final String description;

    private final List<EnumerationValue> enumerationValues;

    private final Date lastUpdatedDate;

    private final Date createdDate;

    private final String version;

    private final String checksum;

    private GetSlotTypeResponse(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * The name of the slot type.
     * </p>
     * 
     * @return The name of the slot type.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the slot type.
     * </p>
     * 
     * @return A description of the slot type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
     * </p>
     * 
     * @return A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
     */
    public List<EnumerationValue> enumerationValues() {
        return enumerationValues;
    }

    /**
     * <p>
     * The date that the slot type was updated. When you create a resource, the creation date and last update date are
     * the same.
     * </p>
     * 
     * @return The date that the slot type was updated. When you create a resource, the creation date and last update
     *         date are the same.
     */
    public Date lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The date that the slot type was created.
     * </p>
     * 
     * @return The date that the slot type was created.
     */
    public Date createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The version of the slot type.
     * </p>
     * 
     * @return The version of the slot type.
     */
    public String version() {
        return version;
    }

    /**
     * <p>
     * Checksum of the <code>$LATEST</code> version of the slot type.
     * </p>
     * 
     * @return Checksum of the <code>$LATEST</code> version of the slot type.
     */
    public String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((enumerationValues() == null) ? 0 : enumerationValues().hashCode());
        hashCode = 31 * hashCode + ((lastUpdatedDate() == null) ? 0 : lastUpdatedDate().hashCode());
        hashCode = 31 * hashCode + ((createdDate() == null) ? 0 : createdDate().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((checksum() == null) ? 0 : checksum().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSlotTypeResponse)) {
            return false;
        }
        GetSlotTypeResponse other = (GetSlotTypeResponse) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.enumerationValues() == null ^ this.enumerationValues() == null) {
            return false;
        }
        if (other.enumerationValues() != null && !other.enumerationValues().equals(this.enumerationValues())) {
            return false;
        }
        if (other.lastUpdatedDate() == null ^ this.lastUpdatedDate() == null) {
            return false;
        }
        if (other.lastUpdatedDate() != null && !other.lastUpdatedDate().equals(this.lastUpdatedDate())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (enumerationValues() != null) {
            sb.append("EnumerationValues: ").append(enumerationValues()).append(",");
        }
        if (lastUpdatedDate() != null) {
            sb.append("LastUpdatedDate: ").append(lastUpdatedDate()).append(",");
        }
        if (createdDate() != null) {
            sb.append("CreatedDate: ").append(createdDate()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetSlotTypeResponse> {
        /**
         * <p>
         * The name of the slot type.
         * </p>
         * 
         * @param name
         *        The name of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the slot type.
         * </p>
         * 
         * @param description
         *        A description of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(Collection<EnumerationValue> enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEnumerationValues(java.util.Collection)} or {@link #withEnumerationValues(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(EnumerationValue... enumerationValues);

        /**
         * <p>
         * The date that the slot type was updated. When you create a resource, the creation date and last update date
         * are the same.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date that the slot type was updated. When you create a resource, the creation date and last update
         *        date are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Date lastUpdatedDate);

        /**
         * <p>
         * The date that the slot type was created.
         * </p>
         * 
         * @param createdDate
         *        The date that the slot type was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Date createdDate);

        /**
         * <p>
         * The version of the slot type.
         * </p>
         * 
         * @param version
         *        The version of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * Checksum of the <code>$LATEST</code> version of the slot type.
         * </p>
         * 
         * @param checksum
         *        Checksum of the <code>$LATEST</code> version of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<EnumerationValue> enumerationValues;

        private Date lastUpdatedDate;

        private Date createdDate;

        private String version;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSlotTypeResponse model) {
            setName(model.name);
            setDescription(model.description);
            setEnumerationValues(model.enumerationValues);
            setLastUpdatedDate(model.lastUpdatedDate);
            setCreatedDate(model.createdDate);
            setVersion(model.version);
            setChecksum(model.checksum);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue> getEnumerationValues() {
            return enumerationValues;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue... enumerationValues) {
            if (this.enumerationValues == null) {
                this.enumerationValues = new ArrayList<>(enumerationValues.length);
            }
            for (EnumerationValue e : enumerationValues) {
                this.enumerationValues.add(e);
            }
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
        }

        @SafeVarargs
        public final void setEnumerationValues(EnumerationValue... enumerationValues) {
            if (this.enumerationValues == null) {
                this.enumerationValues = new ArrayList<>(enumerationValues.length);
            }
            for (EnumerationValue e : enumerationValues) {
                this.enumerationValues.add(e);
            }
        }

        public final Date getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Date lastUpdatedDate) {
            this.lastUpdatedDate = StandardMemberCopier.copy(lastUpdatedDate);
            return this;
        }

        public final void setLastUpdatedDate(Date lastUpdatedDate) {
            this.lastUpdatedDate = StandardMemberCopier.copy(lastUpdatedDate);
        }

        public final Date getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Date createdDate) {
            this.createdDate = StandardMemberCopier.copy(createdDate);
            return this;
        }

        public final void setCreatedDate(Date createdDate) {
            this.createdDate = StandardMemberCopier.copy(createdDate);
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public GetSlotTypeResponse build() {
            return new GetSlotTypeResponse(this);
        }
    }
}
