/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutSlotTypeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutSlotTypeRequest.Builder, PutSlotTypeRequest> {
    private final String name;

    private final String description;

    private final List<EnumerationValue> enumerationValues;

    private final String checksum;

    private PutSlotTypeRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.enumerationValues = builder.enumerationValues;
        this.checksum = builder.checksum;
    }

    /**
     * <p>
     * The name of the slot type. The name is <i>not</i> case sensitive.
     * </p>
     * <p>
     * The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For example,
     * because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom slot type called
     * <code>DATE</code>.
     * </p>
     * <p>
     * For a list of built-in slot types, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * 
     * @return The name of the slot type. The name is <i>not</i> case sensitive. </p>
     *         <p>
     *         The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For
     *         example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom
     *         slot type called <code>DATE</code>.
     *         </p>
     *         <p>
     *         For a list of built-in slot types, see <a href=
     *         "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     *         >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the slot type.
     * </p>
     * 
     * @return A description of the slot type.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
     * </p>
     * 
     * @return A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
     */
    public List<EnumerationValue> enumerationValues() {
        return enumerationValues;
    }

    /**
     * <p>
     * Identifies a specific revision of the <code>$LATEST</code> version.
     * </p>
     * <p>
     * When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you get a
     * <code>BadRequestException</code> exception.
     * </p>
     * <p>
     * When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent
     * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if the
     * checksum does not match the <code>$LATEST</code> version, you get a <code>PreconditionFailedException</code>
     * exception.
     * </p>
     * 
     * @return Identifies a specific revision of the <code>$LATEST</code> version.</p>
     *         <p>
     *         When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum
     *         you get a <code>BadRequestException</code> exception.
     *         </p>
     *         <p>
     *         When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most
     *         recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
     *         field, or if the checksum does not match the <code>$LATEST</code> version, you get a
     *         <code>PreconditionFailedException</code> exception.
     */
    public String checksum() {
        return checksum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((enumerationValues() == null) ? 0 : enumerationValues().hashCode());
        hashCode = 31 * hashCode + ((checksum() == null) ? 0 : checksum().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSlotTypeRequest)) {
            return false;
        }
        PutSlotTypeRequest other = (PutSlotTypeRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.enumerationValues() == null ^ this.enumerationValues() == null) {
            return false;
        }
        if (other.enumerationValues() != null && !other.enumerationValues().equals(this.enumerationValues())) {
            return false;
        }
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (enumerationValues() != null) {
            sb.append("EnumerationValues: ").append(enumerationValues()).append(",");
        }
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutSlotTypeRequest> {
        /**
         * <p>
         * The name of the slot type. The name is <i>not</i> case sensitive.
         * </p>
         * <p>
         * The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed. For
         * example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a custom
         * slot type called <code>DATE</code>.
         * </p>
         * <p>
         * For a list of built-in slot types, see <a href=
         * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * </p>
         * 
         * @param name
         *        The name of the slot type. The name is <i>not</i> case sensitive. </p>
         *        <p>
         *        The name can't match a built-in slot type name, or a built-in slot type name with "AMAZON." removed.
         *        For example, because there is a built-in slot type called <code>AMAZON.DATE</code>, you can't create a
         *        custom slot type called <code>DATE</code>.
         *        </p>
         *        <p>
         *        For a list of built-in slot types, see <a href=
         *        "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
         *        >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the slot type.
         * </p>
         * 
         * @param description
         *        A description of the slot type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(Collection<EnumerationValue> enumerationValues);

        /**
         * <p>
         * A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEnumerationValues(java.util.Collection)} or {@link #withEnumerationValues(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param enumerationValues
         *        A list of <code>EnumerationValue</code> objects that defines the values that the slot type can take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enumerationValues(EnumerationValue... enumerationValues);

        /**
         * <p>
         * Identifies a specific revision of the <code>$LATEST</code> version.
         * </p>
         * <p>
         * When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a checksum you
         * get a <code>BadRequestException</code> exception.
         * </p>
         * <p>
         * When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most recent
         * revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code> field, or if
         * the checksum does not match the <code>$LATEST</code> version, you get a
         * <code>PreconditionFailedException</code> exception.
         * </p>
         * 
         * @param checksum
         *        Identifies a specific revision of the <code>$LATEST</code> version.</p>
         *        <p>
         *        When you create a new slot type, leave the <code>checksum</code> field blank. If you specify a
         *        checksum you get a <code>BadRequestException</code> exception.
         *        </p>
         *        <p>
         *        When you want to update a slot type, set the <code>checksum</code> field to the checksum of the most
         *        recent revision of the <code>$LATEST</code> version. If you don't specify the <code> checksum</code>
         *        field, or if the checksum does not match the <code>$LATEST</code> version, you get a
         *        <code>PreconditionFailedException</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private List<EnumerationValue> enumerationValues;

        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSlotTypeRequest model) {
            setName(model.name);
            setDescription(model.description);
            setEnumerationValues(model.enumerationValues);
            setChecksum(model.checksum);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EnumerationValue> getEnumerationValues() {
            return enumerationValues;
        }

        @Override
        public final Builder enumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enumerationValues(EnumerationValue... enumerationValues) {
            if (this.enumerationValues == null) {
                this.enumerationValues = new ArrayList<>(enumerationValues.length);
            }
            for (EnumerationValue e : enumerationValues) {
                this.enumerationValues.add(e);
            }
            return this;
        }

        public final void setEnumerationValues(Collection<EnumerationValue> enumerationValues) {
            this.enumerationValues = EnumerationValuesCopier.copy(enumerationValues);
        }

        @SafeVarargs
        public final void setEnumerationValues(EnumerationValue... enumerationValues) {
            if (this.enumerationValues == null) {
                this.enumerationValues = new ArrayList<>(enumerationValues.length);
            }
            for (EnumerationValue e : enumerationValues) {
                this.enumerationValues.add(e);
            }
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public PutSlotTypeRequest build() {
            return new PutSlotTypeRequest(this);
        }
    }
}
