/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lexmodelbuilding.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetBotResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetBotResponseUnmarshaller implements Unmarshaller<GetBotResponse, JsonUnmarshallerContext> {

    public GetBotResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetBotResponse.Builder getBotResponseBuilder = GetBotResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getBotResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("intents", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.intents(new ListUnmarshaller<Intent>(IntentUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("clarificationPrompt", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.clarificationPrompt(PromptUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("abortStatement", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.abortStatement(StatementUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("failureReason", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.failureReason(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lastUpdatedDate", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.lastUpdatedDate(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("createdDate", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.createdDate(context.getUnmarshaller(java.util.Date.class).unmarshall(context));
                }
                if (context.testExpression("idleSessionTTLInSeconds", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.idleSessionTTLInSeconds(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("voiceId", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.voiceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("checksum", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.checksum(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("version", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.version(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("locale", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.locale(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("childDirected", targetDepth)) {
                    context.nextToken();
                    getBotResponseBuilder.childDirected(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getBotResponseBuilder.build();
    }

    private static GetBotResponseUnmarshaller INSTANCE;

    public static GetBotResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new GetBotResponseUnmarshaller();
        return INSTANCE;
    }
}