/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lexmodelbuilding.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Slot JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SlotUnmarshaller implements Unmarshaller<Slot, JsonUnmarshallerContext> {

    public Slot unmarshall(JsonUnmarshallerContext context) throws Exception {
        Slot.Builder slotBuilder = Slot.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    slotBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    slotBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("slotConstraint", targetDepth)) {
                    context.nextToken();
                    slotBuilder.slotConstraint(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("slotType", targetDepth)) {
                    context.nextToken();
                    slotBuilder.slotType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("slotTypeVersion", targetDepth)) {
                    context.nextToken();
                    slotBuilder.slotTypeVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("valueElicitationPrompt", targetDepth)) {
                    context.nextToken();
                    slotBuilder.valueElicitationPrompt(PromptUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("priority", targetDepth)) {
                    context.nextToken();
                    slotBuilder.priority(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("sampleUtterances", targetDepth)) {
                    context.nextToken();
                    slotBuilder.sampleUtterances(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("responseCard", targetDepth)) {
                    context.nextToken();
                    slotBuilder.responseCard(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return slotBuilder.build();
    }

    private static SlotUnmarshaller INSTANCE;

    public static SlotUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new SlotUnmarshaller();
        return INSTANCE;
    }
}