/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.lexmodelbuilding.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * UtteranceDataMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class UtteranceDataMarshaller {

    private static final MarshallingInfo<String> UTTERANCESTRING_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utteranceString").build();
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final MarshallingInfo<Integer> DISTINCTUSERS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distinctUsers").build();
    private static final MarshallingInfo<java.util.Date> FIRSTUTTEREDDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstUtteredDate").build();
    private static final MarshallingInfo<java.util.Date> LASTUTTEREDDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUtteredDate").build();

    private static final UtteranceDataMarshaller instance = new UtteranceDataMarshaller();

    public static UtteranceDataMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UtteranceData utteranceData, ProtocolMarshaller protocolMarshaller) {

        if (utteranceData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(utteranceData.utteranceString(), UTTERANCESTRING_BINDING);
            protocolMarshaller.marshall(utteranceData.count(), COUNT_BINDING);
            protocolMarshaller.marshall(utteranceData.distinctUsers(), DISTINCTUSERS_BINDING);
            protocolMarshaller.marshall(utteranceData.firstUtteredDate(), FIRSTUTTEREDDATE_BINDING);
            protocolMarshaller.marshall(utteranceData.lastUtteredDate(), LASTUTTEREDDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
