/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.LocaleListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.transform.BuiltinIntentMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BuiltinIntentMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, BuiltinIntentMetadata> {
    private final String signature;
    private final List<String> supportedLocales;

    private BuiltinIntentMetadata(BuilderImpl builder) {
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
    }

    public String signature() {
        return this.signature;
    }

    public List<String> supportedLocales() {
        return this.supportedLocales;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.signature() == null ? 0 : this.signature().hashCode());
        hashCode = 31 * hashCode + (this.supportedLocales() == null ? 0 : this.supportedLocales().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltinIntentMetadata)) {
            return false;
        }
        BuiltinIntentMetadata other = (BuiltinIntentMetadata)obj;
        if (other.signature() == null ^ this.signature() == null) {
            return false;
        }
        if (other.signature() != null && !other.signature().equals(this.signature())) {
            return false;
        }
        if (other.supportedLocales() == null ^ this.supportedLocales() == null) {
            return false;
        }
        return other.supportedLocales() == null || other.supportedLocales().equals(this.supportedLocales());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.signature() != null) {
            sb.append("Signature: ").append(this.signature()).append(",");
        }
        if (this.supportedLocales() != null) {
            sb.append("SupportedLocales: ").append(this.supportedLocales()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuiltinIntentMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String signature;
        private List<String> supportedLocales;

        private BuilderImpl() {
        }

        private BuilderImpl(BuiltinIntentMetadata model) {
            this.setSignature(model.signature);
            this.setSupportedLocales(model.supportedLocales);
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocales() {
            return this.supportedLocales;
        }

        @Override
        public final Builder supportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(String ... supportedLocales) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new ArrayList<String>(supportedLocales.length);
            }
            for (String e : supportedLocales) {
                this.supportedLocales.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(Locale ... supportedLocales) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new ArrayList<String>(supportedLocales.length);
            }
            for (Locale ele : supportedLocales) {
                this.supportedLocales.add(ele.toString());
            }
            return this;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        @SafeVarargs
        public final void setSupportedLocales(String ... supportedLocales) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new ArrayList<String>(supportedLocales.length);
            }
            for (String e : supportedLocales) {
                this.supportedLocales.add(e);
            }
        }

        @SafeVarargs
        public final void setSupportedLocales(Locale ... supportedLocales) {
            if (this.supportedLocales == null) {
                this.supportedLocales = new ArrayList<String>(supportedLocales.length);
            }
            for (Locale ele : supportedLocales) {
                this.supportedLocales.add(ele.toString());
            }
        }

        public BuiltinIntentMetadata build() {
            return new BuiltinIntentMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BuiltinIntentMetadata> {
        public Builder signature(String var1);

        public Builder supportedLocales(Collection<String> var1);

        public Builder supportedLocales(String ... var1);

        public Builder supportedLocales(Locale ... var1);
    }
}

