/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CodeHookMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CodeHook
implements StructuredPojo,
ToCopyableBuilder<Builder, CodeHook> {
    private final String uri;
    private final String messageVersion;

    private CodeHook(BuilderImpl builder) {
        this.uri = builder.uri;
        this.messageVersion = builder.messageVersion;
    }

    public String uri() {
        return this.uri;
    }

    public String messageVersion() {
        return this.messageVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.uri() == null ? 0 : this.uri().hashCode());
        hashCode = 31 * hashCode + (this.messageVersion() == null ? 0 : this.messageVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeHook)) {
            return false;
        }
        CodeHook other = (CodeHook)obj;
        if (other.uri() == null ^ this.uri() == null) {
            return false;
        }
        if (other.uri() != null && !other.uri().equals(this.uri())) {
            return false;
        }
        if (other.messageVersion() == null ^ this.messageVersion() == null) {
            return false;
        }
        return other.messageVersion() == null || other.messageVersion().equals(this.messageVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.uri() != null) {
            sb.append("Uri: ").append(this.uri()).append(",");
        }
        if (this.messageVersion() != null) {
            sb.append("MessageVersion: ").append(this.messageVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeHookMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String uri;
        private String messageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeHook model) {
            this.setUri(model.uri);
            this.setMessageVersion(model.messageVersion);
        }

        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getMessageVersion() {
            return this.messageVersion;
        }

        @Override
        public final Builder messageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
            return this;
        }

        public final void setMessageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
        }

        public CodeHook build() {
            return new CodeHook(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CodeHook> {
        public Builder uri(String var1);

        public Builder messageVersion(String var1);
    }
}

