/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.Prompt;
import software.amazon.awssdk.services.lexmodelbuilding.model.Statement;
import software.amazon.awssdk.services.lexmodelbuilding.transform.FollowUpPromptMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FollowUpPrompt
implements StructuredPojo,
ToCopyableBuilder<Builder, FollowUpPrompt> {
    private final Prompt prompt;
    private final Statement rejectionStatement;

    private FollowUpPrompt(BuilderImpl builder) {
        this.prompt = builder.prompt;
        this.rejectionStatement = builder.rejectionStatement;
    }

    public Prompt prompt() {
        return this.prompt;
    }

    public Statement rejectionStatement() {
        return this.rejectionStatement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.prompt() == null ? 0 : this.prompt().hashCode());
        hashCode = 31 * hashCode + (this.rejectionStatement() == null ? 0 : this.rejectionStatement().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FollowUpPrompt)) {
            return false;
        }
        FollowUpPrompt other = (FollowUpPrompt)obj;
        if (other.prompt() == null ^ this.prompt() == null) {
            return false;
        }
        if (other.prompt() != null && !other.prompt().equals(this.prompt())) {
            return false;
        }
        if (other.rejectionStatement() == null ^ this.rejectionStatement() == null) {
            return false;
        }
        return other.rejectionStatement() == null || other.rejectionStatement().equals(this.rejectionStatement());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.prompt() != null) {
            sb.append("Prompt: ").append(this.prompt()).append(",");
        }
        if (this.rejectionStatement() != null) {
            sb.append("RejectionStatement: ").append(this.rejectionStatement()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FollowUpPromptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Prompt prompt;
        private Statement rejectionStatement;

        private BuilderImpl() {
        }

        private BuilderImpl(FollowUpPrompt model) {
            this.setPrompt(model.prompt);
            this.setRejectionStatement(model.rejectionStatement);
        }

        public final Prompt getPrompt() {
            return this.prompt;
        }

        @Override
        public final Builder prompt(Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        public final void setPrompt(Prompt prompt) {
            this.prompt = prompt;
        }

        public final Statement getRejectionStatement() {
            return this.rejectionStatement;
        }

        @Override
        public final Builder rejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
            return this;
        }

        public final void setRejectionStatement(Statement rejectionStatement) {
            this.rejectionStatement = rejectionStatement;
        }

        public FollowUpPrompt build() {
            return new FollowUpPrompt(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FollowUpPrompt> {
        public Builder prompt(Prompt var1);

        public Builder rejectionStatement(Statement var1);
    }
}

