/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.ListsOfUtterancesCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetUtterancesViewResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetUtterancesViewResponse> {
    private final String botName;
    private final List<UtteranceList> utterances;

    private GetUtterancesViewResponse(BuilderImpl builder) {
        this.botName = builder.botName;
        this.utterances = builder.utterances;
    }

    public String botName() {
        return this.botName;
    }

    public List<UtteranceList> utterances() {
        return this.utterances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.botName() == null ? 0 : this.botName().hashCode());
        hashCode = 31 * hashCode + (this.utterances() == null ? 0 : this.utterances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewResponse)) {
            return false;
        }
        GetUtterancesViewResponse other = (GetUtterancesViewResponse)((Object)obj);
        if (other.botName() == null ^ this.botName() == null) {
            return false;
        }
        if (other.botName() != null && !other.botName().equals(this.botName())) {
            return false;
        }
        if (other.utterances() == null ^ this.utterances() == null) {
            return false;
        }
        return other.utterances() == null || other.utterances().equals(this.utterances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.botName() != null) {
            sb.append("BotName: ").append(this.botName()).append(",");
        }
        if (this.utterances() != null) {
            sb.append("Utterances: ").append(this.utterances()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String botName;
        private List<UtteranceList> utterances;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewResponse model) {
            this.setBotName(model.botName);
            this.setUtterances(model.utterances);
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Collection<UtteranceList> getUtterances() {
            return this.utterances;
        }

        @Override
        public final Builder utterances(Collection<UtteranceList> utterances) {
            this.utterances = ListsOfUtterancesCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceList ... utterances) {
            if (this.utterances == null) {
                this.utterances = new ArrayList<UtteranceList>(utterances.length);
            }
            for (UtteranceList e : utterances) {
                this.utterances.add(e);
            }
            return this;
        }

        public final void setUtterances(Collection<UtteranceList> utterances) {
            this.utterances = ListsOfUtterancesCopier.copy(utterances);
        }

        @SafeVarargs
        public final void setUtterances(UtteranceList ... utterances) {
            if (this.utterances == null) {
                this.utterances = new ArrayList<UtteranceList>(utterances.length);
            }
            for (UtteranceList e : utterances) {
                this.utterances.add(e);
            }
        }

        public GetUtterancesViewResponse build() {
            return new GetUtterancesViewResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetUtterancesViewResponse> {
        public Builder botName(String var1);

        public Builder utterances(Collection<UtteranceList> var1);

        public Builder utterances(UtteranceList ... var1);
    }
}

