/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.IntentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Intent
implements StructuredPojo,
ToCopyableBuilder<Builder, Intent> {
    private final String intentName;
    private final String intentVersion;

    private Intent(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.intentVersion = builder.intentVersion;
    }

    public String intentName() {
        return this.intentName;
    }

    public String intentVersion() {
        return this.intentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.intentName() == null ? 0 : this.intentName().hashCode());
        hashCode = 31 * hashCode + (this.intentVersion() == null ? 0 : this.intentVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Intent)) {
            return false;
        }
        Intent other = (Intent)obj;
        if (other.intentName() == null ^ this.intentName() == null) {
            return false;
        }
        if (other.intentName() != null && !other.intentName().equals(this.intentName())) {
            return false;
        }
        if (other.intentVersion() == null ^ this.intentVersion() == null) {
            return false;
        }
        return other.intentVersion() == null || other.intentVersion().equals(this.intentVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.intentName() != null) {
            sb.append("IntentName: ").append(this.intentName()).append(",");
        }
        if (this.intentVersion() != null) {
            sb.append("IntentVersion: ").append(this.intentVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IntentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String intentName;
        private String intentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Intent model) {
            this.setIntentName(model.intentName);
            this.setIntentVersion(model.intentVersion);
        }

        public final String getIntentName() {
            return this.intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        public final String getIntentVersion() {
            return this.intentVersion;
        }

        @Override
        public final Builder intentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
            return this;
        }

        public final void setIntentVersion(String intentVersion) {
            this.intentVersion = intentVersion;
        }

        public Intent build() {
            return new Intent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Intent> {
        public Builder intentName(String var1);

        public Builder intentVersion(String var1);
    }
}

