/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceData;

@SdkInternalApi
public class UtteranceDataMarshaller {
    private static final MarshallingInfo<String> UTTERANCESTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utteranceString").build();
    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final MarshallingInfo<Integer> DISTINCTUSERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distinctUsers").build();
    private static final MarshallingInfo<Date> FIRSTUTTEREDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstUtteredDate").build();
    private static final MarshallingInfo<Date> LASTUTTEREDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUtteredDate").build();
    private static final UtteranceDataMarshaller instance = new UtteranceDataMarshaller();

    public static UtteranceDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(UtteranceData utteranceData, ProtocolMarshaller protocolMarshaller) {
        if (utteranceData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)utteranceData.utteranceString(), UTTERANCESTRING_BINDING);
            protocolMarshaller.marshall((Object)utteranceData.count(), COUNT_BINDING);
            protocolMarshaller.marshall((Object)utteranceData.distinctUsers(), DISTINCTUSERS_BINDING);
            protocolMarshaller.marshall((Object)utteranceData.firstUtteredDate(), FIRSTUTTEREDDATE_BINDING);
            protocolMarshaller.marshall((Object)utteranceData.lastUtteredDate(), LASTUTTEREDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

