/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.config.AwsSyncClientConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.BadRequestException;
import software.amazon.awssdk.services.lexmodelbuilding.model.ConflictException;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateBotVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateBotVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateIntentVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateIntentVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateSlotTypeVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.CreateSlotTypeVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotAliasRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotAliasResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotChannelAssociationRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotChannelAssociationResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteBotVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteIntentVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeVersionRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteSlotTypeVersionResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteUtterancesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.DeleteUtterancesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetExportRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetExportResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetUtterancesViewRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetUtterancesViewResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.InternalFailureException;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingException;
import software.amazon.awssdk.services.lexmodelbuilding.model.LimitExceededException;
import software.amazon.awssdk.services.lexmodelbuilding.model.NotFoundException;
import software.amazon.awssdk.services.lexmodelbuilding.model.PreconditionFailedException;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotAliasRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotAliasResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutBotResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutIntentRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutIntentResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutSlotTypeRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.PutSlotTypeResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.ResourceInUseException;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotAliasesIterable;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotChannelAssociationsIterable;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotVersionsIterable;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotsIterable;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBuiltinIntentsIterable;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBuiltinSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetIntentVersionsIterable;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetIntentsIterable;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetSlotTypeVersionsIterable;
import software.amazon.awssdk.services.lexmodelbuilding.paginators.GetSlotTypesIterable;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateBotVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateIntentVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateIntentVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateSlotTypeVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CreateSlotTypeVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotChannelAssociationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotChannelAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteBotVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteIntentVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeVersionRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteSlotTypeVersionResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteUtterancesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.DeleteUtterancesResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotAliasesResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotChannelAssociationsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBotsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinIntentsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetBuiltinSlotTypesResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetExportRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetExportResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetIntentsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeVersionsRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypeVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypesRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetSlotTypesResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetUtterancesViewRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.GetUtterancesViewResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotAliasRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotAliasResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutBotResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutIntentRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutIntentResponseUnmarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutSlotTypeRequestMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.transform.PutSlotTypeResponseUnmarshaller;

/**
 * Internal implementation of {@link LexModelBuildingClient}.
 *
 * @see LexModelBuildingClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLexModelBuildingClient implements LexModelBuildingClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final AwsSyncClientConfiguration clientConfiguration;

    protected DefaultLexModelBuildingClient(AwsSyncClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration, null);
        this.protocolFactory = init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates a new version of the bot based on the <code>&#36LATEST</code> version. If the <code>&#36LATEST</code>
     * version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new
     * version. It returns the last created version.
     * </p>
     * <note>
     * <p>
     * You can update only the <code>&#36LATEST</code> version of the bot. You can't update the numbered versions that
     * you create with the <code>CreateBotVersion</code> operation.
     * </p>
     * </note>
     * <p>
     * When you create the first version of a bot, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * For more information, see <a>versioning-intro</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:CreateBotVersion</code> action.
     * </p>
     *
     * @param createBotVersionRequest
     * @return Result of the CreateBotVersion operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws PreconditionFailedException
     *         The checksum of the resource that you are trying to change does not match the checksum in the request.
     *         Check the resource's checksum and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.CreateBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateBotVersionResponse createBotVersion(CreateBotVersionRequest createBotVersionRequest) throws NotFoundException,
            ConflictException, LimitExceededException, InternalFailureException, BadRequestException,
            PreconditionFailedException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<CreateBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateBotVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateBotVersionRequest, CreateBotVersionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createBotVersionRequest).withMarshaller(new CreateBotVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new version of an intent based on the <code>&#36LATEST</code> version of the intent. If the
     * <code>&#36LATEST</code> version of this intent hasn't changed since you last updated it, Amazon Lex doesn't
     * create a new version. It returns the last version you created.
     * </p>
     * <note>
     * <p>
     * You can update only the <code>&#36LATEST</code> version of the intent. You can't update the numbered versions
     * that you create with the <code>CreateIntentVersion</code> operation.
     * </p>
     * </note>
     * <p>
     * When you create a version of an intent, Amazon Lex sets the version to 1. Subsequent versions increment by 1. For
     * more information, see <a>versioning-intro</a>.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lex:CreateIntentVersion</code> action.
     * </p>
     *
     * @param createIntentVersionRequest
     * @return Result of the CreateIntentVersion operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws PreconditionFailedException
     *         The checksum of the resource that you are trying to change does not match the checksum in the request.
     *         Check the resource's checksum and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.CreateIntentVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateIntentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateIntentVersionResponse createIntentVersion(CreateIntentVersionRequest createIntentVersionRequest)
            throws NotFoundException, ConflictException, LimitExceededException, InternalFailureException, BadRequestException,
            PreconditionFailedException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<CreateIntentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateIntentVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateIntentVersionRequest, CreateIntentVersionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createIntentVersionRequest).withMarshaller(new CreateIntentVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new version of a slot type based on the <code>&#36LATEST</code> version of the specified slot type. If
     * the <code>&#36LATEST</code> version of this resource has not changed since the last version that you created,
     * Amazon Lex doesn't create a new version. It returns the last version that you created.
     * </p>
     * <note>
     * <p>
     * You can update only the <code>&#36LATEST</code> version of a slot type. You can't update the numbered versions
     * that you create with the <code>CreateSlotTypeVersion</code> operation.
     * </p>
     * </note>
     * <p>
     * When you create a version of a slot type, Amazon Lex sets the version to 1. Subsequent versions increment by 1.
     * For more information, see <a>versioning-intro</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:CreateSlotTypeVersion</code> action.
     * </p>
     *
     * @param createSlotTypeVersionRequest
     * @return Result of the CreateSlotTypeVersion operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws PreconditionFailedException
     *         The checksum of the resource that you are trying to change does not match the checksum in the request.
     *         Check the resource's checksum and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.CreateSlotTypeVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/CreateSlotTypeVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSlotTypeVersionResponse createSlotTypeVersion(CreateSlotTypeVersionRequest createSlotTypeVersionRequest)
            throws NotFoundException, ConflictException, LimitExceededException, InternalFailureException, BadRequestException,
            PreconditionFailedException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<CreateSlotTypeVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateSlotTypeVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateSlotTypeVersionRequest, CreateSlotTypeVersionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createSlotTypeVersionRequest)
                .withMarshaller(new CreateSlotTypeVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes all versions of the bot, including the <code>&#36LATEST</code> version. To delete a specific version of
     * the bot, use the <a>DeleteBotVersion</a> operation.
     * </p>
     * <p>
     * If a bot has an alias, you can't delete it. Instead, the <code>DeleteBot</code> operation returns a
     * <code>ResourceInUseException</code> exception that includes a reference to the alias that refers to the bot. To
     * remove the reference to the bot, delete the alias. If you get the same exception again, delete the referring
     * alias until the <code>DeleteBot</code> operation is successful.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteBot</code> action.
     * </p>
     *
     * @param deleteBotRequest
     * @return Result of the DeleteBot operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws ResourceInUseException
     *         The resource that you are attempting to delete is referred to by another resource. Use this information
     *         to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.DeleteBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBotResponse deleteBot(DeleteBotRequest deleteBotRequest) throws NotFoundException, ConflictException,
            LimitExceededException, InternalFailureException, BadRequestException, ResourceInUseException, AwsServiceException,
            SdkClientException, LexModelBuildingException {

        HttpResponseHandler<DeleteBotResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBotResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteBotRequest, DeleteBotResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(deleteBotRequest)
                .withMarshaller(new DeleteBotRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an alias for the specified bot.
     * </p>
     * <p>
     * You can't delete an alias that is used in the association between a bot and a messaging channel. If an alias is
     * used in a channel association, the <code>DeleteBot</code> operation returns a <code>ResourceInUseException</code>
     * exception that includes a reference to the channel association that refers to the bot. You can remove the
     * reference to the alias by deleting the channel association. If you get the same exception again, delete the
     * referring association until the <code>DeleteBotAlias</code> operation is successful.
     * </p>
     *
     * @param deleteBotAliasRequest
     * @return Result of the DeleteBotAlias operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws ResourceInUseException
     *         The resource that you are attempting to delete is referred to by another resource. Use this information
     *         to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.DeleteBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBotAliasResponse deleteBotAlias(DeleteBotAliasRequest deleteBotAliasRequest) throws NotFoundException,
            ConflictException, LimitExceededException, InternalFailureException, BadRequestException, ResourceInUseException,
            AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<DeleteBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBotAliasResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteBotAliasRequest, DeleteBotAliasResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteBotAliasRequest).withMarshaller(new DeleteBotAliasRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the association between an Amazon Lex bot and a messaging platform.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:DeleteBotChannelAssociation</code> action.
     * </p>
     *
     * @param deleteBotChannelAssociationRequest
     * @return Result of the DeleteBotChannelAssociation operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.DeleteBotChannelAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotChannelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBotChannelAssociationResponse deleteBotChannelAssociation(
            DeleteBotChannelAssociationRequest deleteBotChannelAssociationRequest) throws NotFoundException, ConflictException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {

        HttpResponseHandler<DeleteBotChannelAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBotChannelAssociationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeleteBotChannelAssociationRequest, DeleteBotChannelAssociationResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteBotChannelAssociationRequest)
                        .withMarshaller(new DeleteBotChannelAssociationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specific version of a bot. To delete all versions of a bot, use the <a>DeleteBot</a> operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteBotVersion</code> action.
     * </p>
     *
     * @param deleteBotVersionRequest
     * @return Result of the DeleteBotVersion operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws ResourceInUseException
     *         The resource that you are attempting to delete is referred to by another resource. Use this information
     *         to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.DeleteBotVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteBotVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBotVersionResponse deleteBotVersion(DeleteBotVersionRequest deleteBotVersionRequest) throws NotFoundException,
            ConflictException, LimitExceededException, InternalFailureException, BadRequestException, ResourceInUseException,
            AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<DeleteBotVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteBotVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteBotVersionRequest, DeleteBotVersionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteBotVersionRequest).withMarshaller(new DeleteBotVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes all versions of the intent, including the <code>&#36LATEST</code> version. To delete a specific version
     * of the intent, use the <a>DeleteIntentVersion</a> operation.
     * </p>
     * <p>
     * You can delete a version of an intent only if it is not referenced. To delete an intent that is referred to in
     * one or more bots (see <a>how-it-works</a>), you must remove those references first.
     * </p>
     * <note>
     * <p>
     * If you get the <code>ResourceInUseException</code> exception, it provides an example reference that shows where
     * the intent is referenced. To remove the reference to the intent, either update the bot or delete it. If you get
     * the same exception when you attempt to delete the intent again, repeat until the intent has no references and the
     * call to <code>DeleteIntent</code> is successful.
     * </p>
     * </note>
     * <p>
     * This operation requires permission for the <code>lex:DeleteIntent</code> action.
     * </p>
     *
     * @param deleteIntentRequest
     * @return Result of the DeleteIntent operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws ResourceInUseException
     *         The resource that you are attempting to delete is referred to by another resource. Use this information
     *         to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.DeleteIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIntentResponse deleteIntent(DeleteIntentRequest deleteIntentRequest) throws NotFoundException,
            ConflictException, LimitExceededException, InternalFailureException, BadRequestException, ResourceInUseException,
            AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<DeleteIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteIntentResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteIntentRequest, DeleteIntentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteIntentRequest).withMarshaller(new DeleteIntentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specific version of an intent. To delete all versions of a intent, use the <a>DeleteIntent</a>
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteIntentVersion</code> action.
     * </p>
     *
     * @param deleteIntentVersionRequest
     * @return Result of the DeleteIntentVersion operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws ResourceInUseException
     *         The resource that you are attempting to delete is referred to by another resource. Use this information
     *         to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.DeleteIntentVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteIntentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteIntentVersionResponse deleteIntentVersion(DeleteIntentVersionRequest deleteIntentVersionRequest)
            throws NotFoundException, ConflictException, LimitExceededException, InternalFailureException, BadRequestException,
            ResourceInUseException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<DeleteIntentVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteIntentVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteIntentVersionRequest, DeleteIntentVersionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteIntentVersionRequest).withMarshaller(new DeleteIntentVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes all versions of the slot type, including the <code>&#36LATEST</code> version. To delete a specific
     * version of the slot type, use the <a>DeleteSlotTypeVersion</a> operation.
     * </p>
     * <p>
     * You can delete a version of a slot type only if it is not referenced. To delete a slot type that is referred to
     * in one or more intents, you must remove those references first.
     * </p>
     * <note>
     * <p>
     * If you get the <code>ResourceInUseException</code> exception, the exception provides an example reference that
     * shows the intent where the slot type is referenced. To remove the reference to the slot type, either update the
     * intent or delete it. If you get the same exception when you attempt to delete the slot type again, repeat until
     * the slot type has no references and the <code>DeleteSlotType</code> call is successful.
     * </p>
     * </note>
     * <p>
     * This operation requires permission for the <code>lex:DeleteSlotType</code> action.
     * </p>
     *
     * @param deleteSlotTypeRequest
     * @return Result of the DeleteSlotType operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws ResourceInUseException
     *         The resource that you are attempting to delete is referred to by another resource. Use this information
     *         to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.DeleteSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSlotTypeResponse deleteSlotType(DeleteSlotTypeRequest deleteSlotTypeRequest) throws NotFoundException,
            ConflictException, LimitExceededException, InternalFailureException, BadRequestException, ResourceInUseException,
            AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<DeleteSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteSlotTypeResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteSlotTypeRequest, DeleteSlotTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteSlotTypeRequest).withMarshaller(new DeleteSlotTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specific version of a slot type. To delete all versions of a slot type, use the <a>DeleteSlotType</a>
     * operation.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteSlotTypeVersion</code> action.
     * </p>
     *
     * @param deleteSlotTypeVersionRequest
     * @return Result of the DeleteSlotTypeVersion operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws ResourceInUseException
     *         The resource that you are attempting to delete is referred to by another resource. Use this information
     *         to remove references to the resource that you are trying to delete.</p>
     *         <p>
     *         The body of the exception contains a JSON object that describes the resource.
     *         </p>
     *         <p>
     *         <code>{ "resourceType": BOT | BOTALIAS | BOTCHANNEL | INTENT,</code>
     *         </p>
     *         <p>
     *         <code>"resourceReference": {</code>
     *         </p>
     *         <p>
     *         <code>"name": <i>string</i>, "version": <i>string</i> } }</code>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.DeleteSlotTypeVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteSlotTypeVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSlotTypeVersionResponse deleteSlotTypeVersion(DeleteSlotTypeVersionRequest deleteSlotTypeVersionRequest)
            throws NotFoundException, ConflictException, LimitExceededException, InternalFailureException, BadRequestException,
            ResourceInUseException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<DeleteSlotTypeVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteSlotTypeVersionResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteSlotTypeVersionRequest, DeleteSlotTypeVersionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteSlotTypeVersionRequest)
                .withMarshaller(new DeleteSlotTypeVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes stored utterances.
     * </p>
     * <p>
     * Amazon Lex stores the utterances that users send to your bot unless the <code>childDirected</code> field in the
     * bot is set to <code>true</code>. Utterances are stored for 15 days for use with the <a>GetUtterancesView</a>
     * operation, and then stored indefinately for use in improving the ability of your bot to respond to user input.
     * </p>
     * <p>
     * Use the <code>DeleteStoredUtterances</code> operation to manually delete stored utterances for a specific user.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:DeleteUtterances</code> action.
     * </p>
     *
     * @param deleteUtterancesRequest
     * @return Result of the DeleteUtterances operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.DeleteUtterances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/DeleteUtterances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteUtterancesResponse deleteUtterances(DeleteUtterancesRequest deleteUtterancesRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {

        HttpResponseHandler<DeleteUtterancesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteUtterancesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteUtterancesRequest, DeleteUtterancesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteUtterancesRequest).withMarshaller(new DeleteUtterancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns metadata information for a specific bot. You must provide the bot name and the bot version or alias.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBot</code> action.
     * </p>
     *
     * @param getBotRequest
     * @return Result of the GetBot operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBotResponse getBot(GetBotRequest getBotRequest) throws NotFoundException, LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetBotResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBotResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotRequest, GetBotResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getBotRequest)
                .withMarshaller(new GetBotRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about an Amazon Lex bot alias. For more information about aliases, see
     * <a>versioning-aliases</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotAlias</code> action.
     * </p>
     *
     * @param getBotAliasRequest
     * @return Result of the GetBotAlias operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBotAliasResponse getBotAlias(GetBotAliasRequest getBotAliasRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {

        HttpResponseHandler<GetBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotAliasResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotAliasRequest, GetBotAliasResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBotAliasRequest).withMarshaller(new GetBotAliasRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of aliases for a specified Amazon Lex bot.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotAliases</code> action.
     * </p>
     *
     * @param getBotAliasesRequest
     * @return Result of the GetBotAliases operation returned by the service.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBotAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBotAliasesResponse getBotAliases(GetBotAliasesRequest getBotAliasesRequest) throws LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetBotAliasesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotAliasesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotAliasesRequest, GetBotAliasesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBotAliasesRequest).withMarshaller(new GetBotAliasesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of aliases for a specified Amazon Lex bot.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotAliases</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBotAliases(software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotAliasesIterable responses = client.getBotAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotAliasesIterable responses = client
     *             .getBotAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotAliasesIterable responses = client.getBotAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBotAliases(software.amazon.awssdk.services.lexmodelbuilding.model.GetBotAliasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBotAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBotAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBotAliasesIterable getBotAliasesPaginator(GetBotAliasesRequest getBotAliasesRequest) throws LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {
        return new GetBotAliasesIterable(this, getBotAliasesRequest);
    }

    /**
     * <p>
     * Returns information about the association between an Amazon Lex bot and a messaging platform.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotChannelAssociation</code> action.
     * </p>
     *
     * @param getBotChannelAssociationRequest
     * @return Result of the GetBotChannelAssociation operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBotChannelAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBotChannelAssociationResponse getBotChannelAssociation(
            GetBotChannelAssociationRequest getBotChannelAssociationRequest) throws NotFoundException, LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetBotChannelAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotChannelAssociationResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetBotChannelAssociationRequest, GetBotChannelAssociationResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getBotChannelAssociationRequest)
                        .withMarshaller(new GetBotChannelAssociationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of all of the channels associated with the specified bot.
     * </p>
     * <p>
     * The <code>GetBotChannelAssociations</code> operation requires permissions for the
     * <code>lex:GetBotChannelAssociations</code> action.
     * </p>
     *
     * @param getBotChannelAssociationsRequest
     * @return Result of the GetBotChannelAssociations operation returned by the service.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBotChannelAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBotChannelAssociationsResponse getBotChannelAssociations(
            GetBotChannelAssociationsRequest getBotChannelAssociationsRequest) throws LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetBotChannelAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotChannelAssociationsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetBotChannelAssociationsRequest, GetBotChannelAssociationsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getBotChannelAssociationsRequest)
                        .withMarshaller(new GetBotChannelAssociationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of all of the channels associated with the specified bot.
     * </p>
     * <p>
     * The <code>GetBotChannelAssociations</code> operation requires permissions for the
     * <code>lex:GetBotChannelAssociations</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBotChannelAssociations(software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotChannelAssociationsIterable responses = client.getBotChannelAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotChannelAssociationsIterable responses = client
     *             .getBotChannelAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotChannelAssociationsIterable responses = client.getBotChannelAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBotChannelAssociations(software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBotChannelAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBotChannelAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotChannelAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBotChannelAssociationsIterable getBotChannelAssociationsPaginator(
            GetBotChannelAssociationsRequest getBotChannelAssociationsRequest) throws LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {
        return new GetBotChannelAssociationsIterable(this, getBotChannelAssociationsRequest);
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>GetBotVersions</code> operation returns a <code>BotMetadata</code> object for each version of a bot.
     * For example, if a bot has three numbered versions, the <code>GetBotVersions</code> operation returns four
     * <code>BotMetadata</code> objects in the response, one for each numbered version and one for the
     * <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetBotVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotVersions</code> action.
     * </p>
     *
     * @param getBotVersionsRequest
     * @return Result of the GetBotVersions operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBotVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBotVersionsResponse getBotVersions(GetBotVersionsRequest getBotVersionsRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {

        HttpResponseHandler<GetBotVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBotVersionsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotVersionsRequest, GetBotVersionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBotVersionsRequest).withMarshaller(new GetBotVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about all of the versions of a bot.
     * </p>
     * <p>
     * The <code>GetBotVersions</code> operation returns a <code>BotMetadata</code> object for each version of a bot.
     * For example, if a bot has three numbered versions, the <code>GetBotVersions</code> operation returns four
     * <code>BotMetadata</code> objects in the response, one for each numbered version and one for the
     * <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetBotVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetBotVersions</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBotVersions(software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotVersionsIterable responses = client.getBotVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotVersionsIterable responses = client
     *             .getBotVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotVersionsIterable responses = client.getBotVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBotVersions(software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBotVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBotVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBotVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBotVersionsIterable getBotVersionsPaginator(GetBotVersionsRequest getBotVersionsRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {
        return new GetBotVersionsIterable(this, getBotVersionsRequest);
    }

    /**
     * <p>
     * Returns bot information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you provide the <code>nameContains</code> field, the response includes information for the
     * <code>&#36LATEST</code> version of all bots whose name contains the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, the operation returns information about the
     * <code>&#36LATEST</code> version of all of your bots.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation requires permission for the <code>lex:GetBots</code> action.
     * </p>
     *
     * @param getBotsRequest
     * @return Result of the GetBots operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBotsResponse getBots(GetBotsRequest getBotsRequest) throws NotFoundException, LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetBotsResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBotsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBotsRequest, GetBotsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getBotsRequest)
                .withMarshaller(new GetBotsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns bot information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you provide the <code>nameContains</code> field, the response includes information for the
     * <code>&#36LATEST</code> version of all bots whose name contains the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, the operation returns information about the
     * <code>&#36LATEST</code> version of all of your bots.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation requires permission for the <code>lex:GetBots</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getBots(software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotsIterable responses = client.getBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotsIterable responses = client.getBotsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBotsIterable responses = client.getBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBots(software.amazon.awssdk.services.lexmodelbuilding.model.GetBotsRequest)} operation.</b>
     * </p>
     *
     * @param getBotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBotsIterable getBotsPaginator(GetBotsRequest getBotsRequest) throws NotFoundException, LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {
        return new GetBotsIterable(this, getBotsRequest);
    }

    /**
     * <p>
     * Returns information about a built-in intent.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltinIntent</code> action.
     * </p>
     *
     * @param getBuiltinIntentRequest
     * @return Result of the GetBuiltinIntent operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBuiltinIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetBuiltinIntentResponse getBuiltinIntent(GetBuiltinIntentRequest getBuiltinIntentRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {

        HttpResponseHandler<GetBuiltinIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBuiltinIntentResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBuiltinIntentRequest, GetBuiltinIntentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBuiltinIntentRequest).withMarshaller(new GetBuiltinIntentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a list of built-in intents that meet the specified criteria.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltinIntents</code> action.
     * </p>
     *
     * @param getBuiltinIntentsRequest
     * @return Result of the GetBuiltinIntents operation returned by the service.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBuiltinIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetBuiltinIntentsResponse getBuiltinIntents(GetBuiltinIntentsRequest getBuiltinIntentsRequest)
            throws LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetBuiltinIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBuiltinIntentsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBuiltinIntentsRequest, GetBuiltinIntentsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBuiltinIntentsRequest).withMarshaller(new GetBuiltinIntentsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a list of built-in intents that meet the specified criteria.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltinIntents</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBuiltinIntents(software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBuiltinIntentsIterable responses = client.getBuiltinIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBuiltinIntentsIterable responses = client
     *             .getBuiltinIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBuiltinIntentsIterable responses = client.getBuiltinIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBuiltinIntents(software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBuiltinIntentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBuiltinIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinIntents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetBuiltinIntentsIterable getBuiltinIntentsPaginator(GetBuiltinIntentsRequest getBuiltinIntentsRequest)
            throws LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, LexModelBuildingException {
        return new GetBuiltinIntentsIterable(this, getBuiltinIntentsRequest);
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <p>
     * For a list of built-in slot types, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltInSlotTypes</code> action.
     * </p>
     *
     * @param getBuiltinSlotTypesRequest
     * @return Result of the GetBuiltinSlotTypes operation returned by the service.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBuiltinSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetBuiltinSlotTypesResponse getBuiltinSlotTypes(GetBuiltinSlotTypesRequest getBuiltinSlotTypesRequest)
            throws LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetBuiltinSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetBuiltinSlotTypesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetBuiltinSlotTypesRequest, GetBuiltinSlotTypesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getBuiltinSlotTypesRequest).withMarshaller(new GetBuiltinSlotTypesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets a list of built-in slot types that meet the specified criteria.
     * </p>
     * <p>
     * For a list of built-in slot types, see <a href=
     * "https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/slot-type-reference"
     * >Slot Type Reference</a> in the <i>Alexa Skills Kit</i>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lex:GetBuiltInSlotTypes</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBuiltinSlotTypes(software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBuiltinSlotTypesIterable responses = client.getBuiltinSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBuiltinSlotTypesIterable responses = client
     *             .getBuiltinSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetBuiltinSlotTypesIterable responses = client.getBuiltinSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBuiltinSlotTypes(software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinSlotTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBuiltinSlotTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetBuiltinSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetBuiltinSlotTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetBuiltinSlotTypesIterable getBuiltinSlotTypesPaginator(GetBuiltinSlotTypesRequest getBuiltinSlotTypesRequest)
            throws LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, LexModelBuildingException {
        return new GetBuiltinSlotTypesIterable(this, getBuiltinSlotTypesRequest);
    }

    /**
     * <p>
     * Exports the contents of a Amazon Lex resource in a specified format.
     * </p>
     *
     * @param getExportRequest
     * @return Result of the GetExport operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetExport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetExport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetExportResponse getExport(GetExportRequest getExportRequest) throws NotFoundException, LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetExportResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetExportResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetExportRequest, GetExportResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getExportRequest)
                .withMarshaller(new GetExportRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about an intent. In addition to the intent name, you must specify the intent version.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>lex:GetIntent</code> action.
     * </p>
     *
     * @param getIntentRequest
     * @return Result of the GetIntent operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetIntentResponse getIntent(GetIntentRequest getIntentRequest) throws NotFoundException, LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetIntentResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetIntentRequest, GetIntentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getIntentRequest)
                .withMarshaller(new GetIntentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about all of the versions of an intent.
     * </p>
     * <p>
     * The <code>GetIntentVersions</code> operation returns an <code>IntentMetadata</code> object for each version of an
     * intent. For example, if an intent has three numbered versions, the <code>GetIntentVersions</code> operation
     * returns four <code>IntentMetadata</code> objects in the response, one for each numbered version and one for the
     * <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetIntentVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetIntentVersions</code> action.
     * </p>
     *
     * @param getIntentVersionsRequest
     * @return Result of the GetIntentVersions operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetIntentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetIntentVersionsResponse getIntentVersions(GetIntentVersionsRequest getIntentVersionsRequest)
            throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetIntentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetIntentVersionsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetIntentVersionsRequest, GetIntentVersionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getIntentVersionsRequest).withMarshaller(new GetIntentVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about all of the versions of an intent.
     * </p>
     * <p>
     * The <code>GetIntentVersions</code> operation returns an <code>IntentMetadata</code> object for each version of an
     * intent. For example, if an intent has three numbered versions, the <code>GetIntentVersions</code> operation
     * returns four <code>IntentMetadata</code> objects in the response, one for each numbered version and one for the
     * <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetIntentVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetIntentVersions</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getIntentVersions(software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetIntentVersionsIterable responses = client.getIntentVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetIntentVersionsIterable responses = client
     *             .getIntentVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetIntentVersionsIterable responses = client.getIntentVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getIntentVersions(software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getIntentVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetIntentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetIntentVersionsIterable getIntentVersionsPaginator(GetIntentVersionsRequest getIntentVersionsRequest)
            throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, LexModelBuildingException {
        return new GetIntentVersionsIterable(this, getIntentVersionsRequest);
    }

    /**
     * <p>
     * Returns intent information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify the <code>nameContains</code> field, returns the <code>&#36LATEST</code> version of all intents
     * that contain the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, returns information about the <code>&#36LATEST</code>
     * version of all intents.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The operation requires permission for the <code>lex:GetIntents</code> action.
     * </p>
     *
     * @param getIntentsRequest
     * @return Result of the GetIntents operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetIntentsResponse getIntents(GetIntentsRequest getIntentsRequest) throws NotFoundException, LimitExceededException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetIntentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetIntentsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetIntentsRequest, GetIntentsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getIntentsRequest)
                .withMarshaller(new GetIntentsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns intent information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify the <code>nameContains</code> field, returns the <code>&#36LATEST</code> version of all intents
     * that contain the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, returns information about the <code>&#36LATEST</code>
     * version of all intents.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The operation requires permission for the <code>lex:GetIntents</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getIntents(software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetIntentsIterable responses = client.getIntentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetIntentsIterable responses = client
     *             .getIntentsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetIntentsIterable responses = client.getIntentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getIntents(software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsRequest)} operation.</b>
     * </p>
     *
     * @param getIntentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetIntents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetIntents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetIntentsIterable getIntentsPaginator(GetIntentsRequest getIntentsRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {
        return new GetIntentsIterable(this, getIntentsRequest);
    }

    /**
     * <p>
     * Returns information about a specific version of a slot type. In addition to specifying the slot type name, you
     * must specify the slot type version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetSlotType</code> action.
     * </p>
     *
     * @param getSlotTypeRequest
     * @return Result of the GetSlotType operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSlotTypeResponse getSlotType(GetSlotTypeRequest getSlotTypeRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {

        HttpResponseHandler<GetSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetSlotTypeResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetSlotTypeRequest, GetSlotTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getSlotTypeRequest).withMarshaller(new GetSlotTypeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about all versions of a slot type.
     * </p>
     * <p>
     * The <code>GetSlotTypeVersions</code> operation returns a <code>SlotTypeMetadata</code> object for each version of
     * a slot type. For example, if a slot type has three numbered versions, the <code>GetSlotTypeVersions</code>
     * operation returns four <code>SlotTypeMetadata</code> objects in the response, one for each numbered version and
     * one for the <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetSlotTypeVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetSlotTypeVersions</code> action.
     * </p>
     *
     * @param getSlotTypeVersionsRequest
     * @return Result of the GetSlotTypeVersions operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetSlotTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSlotTypeVersionsResponse getSlotTypeVersions(GetSlotTypeVersionsRequest getSlotTypeVersionsRequest)
            throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetSlotTypeVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetSlotTypeVersionsResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetSlotTypeVersionsRequest, GetSlotTypeVersionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getSlotTypeVersionsRequest).withMarshaller(new GetSlotTypeVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets information about all versions of a slot type.
     * </p>
     * <p>
     * The <code>GetSlotTypeVersions</code> operation returns a <code>SlotTypeMetadata</code> object for each version of
     * a slot type. For example, if a slot type has three numbered versions, the <code>GetSlotTypeVersions</code>
     * operation returns four <code>SlotTypeMetadata</code> objects in the response, one for each numbered version and
     * one for the <code>&#36LATEST</code> version.
     * </p>
     * <p>
     * The <code>GetSlotTypeVersions</code> operation always returns at least one version, the <code>&#36LATEST</code>
     * version.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetSlotTypeVersions</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSlotTypeVersions(software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetSlotTypeVersionsIterable responses = client.getSlotTypeVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetSlotTypeVersionsIterable responses = client
     *             .getSlotTypeVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetSlotTypeVersionsIterable responses = client.getSlotTypeVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSlotTypeVersions(software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSlotTypeVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetSlotTypeVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSlotTypeVersionsIterable getSlotTypeVersionsPaginator(GetSlotTypeVersionsRequest getSlotTypeVersionsRequest)
            throws NotFoundException, LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, LexModelBuildingException {
        return new GetSlotTypeVersionsIterable(this, getSlotTypeVersionsRequest);
    }

    /**
     * <p>
     * Returns slot type information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify the <code>nameContains</code> field, returns the <code>&#36LATEST</code> version of all slot types
     * that contain the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, returns information about the <code>&#36LATEST</code>
     * version of all slot types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The operation requires permission for the <code>lex:GetSlotTypes</code> action.
     * </p>
     *
     * @param getSlotTypesRequest
     * @return Result of the GetSlotTypes operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSlotTypesResponse getSlotTypes(GetSlotTypesRequest getSlotTypesRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {

        HttpResponseHandler<GetSlotTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetSlotTypesResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetSlotTypesRequest, GetSlotTypesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getSlotTypesRequest).withMarshaller(new GetSlotTypesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns slot type information as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify the <code>nameContains</code> field, returns the <code>&#36LATEST</code> version of all slot types
     * that contain the specified string.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify the <code>nameContains</code> field, returns information about the <code>&#36LATEST</code>
     * version of all slot types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The operation requires permission for the <code>lex:GetSlotTypes</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSlotTypes(software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetSlotTypesIterable responses = client.getSlotTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lexmodelbuilding.paginators.GetSlotTypesIterable responses = client
     *             .getSlotTypesPaginator(request);
     *     for (software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lexmodelbuilding.paginators.GetSlotTypesIterable responses = client.getSlotTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSlotTypes(software.amazon.awssdk.services.lexmodelbuilding.model.GetSlotTypesRequest)} operation.</b>
     * </p>
     *
     * @param getSlotTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource and try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetSlotTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetSlotTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSlotTypesIterable getSlotTypesPaginator(GetSlotTypesRequest getSlotTypesRequest) throws NotFoundException,
            LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            LexModelBuildingException {
        return new GetSlotTypesIterable(this, getSlotTypesRequest);
    }

    /**
     * <p>
     * Use the <code>GetUtterancesView</code> operation to get information about the utterances that your users have
     * made to your bot. You can use this list to tune the utterances that your bot responds to.
     * </p>
     * <p>
     * For example, say that you have created a bot to order flowers. After your users have used your bot for a while,
     * use the <code>GetUtterancesView</code> operation to see the requests that they have made and whether they have
     * been successful. You might find that the utterance "I want flowers" is not being recognized. You could add this
     * utterance to the <code>OrderFlowers</code> intent so that your bot recognizes that utterance.
     * </p>
     * <p>
     * After you publish a new version of a bot, you can get information about the old version and the new so that you
     * can compare the performance across the two versions.
     * </p>
     * <p>
     * Data is available for the last 15 days. You can request information for up to 5 versions in each request. The
     * response contains information about a maximum of 100 utterances for each version.
     * </p>
     * <p>
     * If the bot's <code>childDirected</code> field is set to <code>true</code>, utterances for the bot are not stored
     * and cannot be retrieved with the <code>GetUtterancesView</code> operation. For more information, see
     * <a>PutBot</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:GetUtterancesView</code> action.
     * </p>
     *
     * @param getUtterancesViewRequest
     * @return Result of the GetUtterancesView operation returned by the service.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.GetUtterancesView
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/GetUtterancesView" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetUtterancesViewResponse getUtterancesView(GetUtterancesViewRequest getUtterancesViewRequest)
            throws LimitExceededException, InternalFailureException, BadRequestException, AwsServiceException,
            SdkClientException, LexModelBuildingException {

        HttpResponseHandler<GetUtterancesViewResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetUtterancesViewResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetUtterancesViewRequest, GetUtterancesViewResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getUtterancesViewRequest).withMarshaller(new GetUtterancesViewRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an Amazon Lex conversational bot or replaces an existing bot. When you create or update a bot you are
     * only required to specify a name. You can use this to add intents later, or to remove intents from an existing
     * bot. When you create a bot with a name only, the bot is created or updated but Amazon Lex returns the
     * <code/> response <code>FAILED</code>. You can build the bot after you add one or more intents. For more
     * information about Amazon Lex bots, see <a>how-it-works</a>.
     * </p>
     * <p>
     * If you specify the name of an existing bot, the fields in the request replace the existing values in the
     * <code>&#36LATEST</code> version of the bot. Amazon Lex removes any fields that you don't provide values for in
     * the request, except for the <code>idleTTLInSeconds</code> and <code>privacySettings</code> fields, which are set
     * to their default values. If you don't specify values for required fields, Amazon Lex throws an exception.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutBot</code> action. For more information, see
     * <a>auth-and-access-control</a>.
     * </p>
     *
     * @param putBotRequest
     * @return Result of the PutBot operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws PreconditionFailedException
     *         The checksum of the resource that you are trying to change does not match the checksum in the request.
     *         Check the resource's checksum and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.PutBot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutBotResponse putBot(PutBotRequest putBotRequest) throws ConflictException, LimitExceededException,
            InternalFailureException, BadRequestException, PreconditionFailedException, AwsServiceException, SdkClientException,
            LexModelBuildingException {

        HttpResponseHandler<PutBotResponse> responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata()
                .withPayloadJson(true).withHasStreamingSuccessResponse(false), new PutBotResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutBotRequest, PutBotResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putBotRequest)
                .withMarshaller(new PutBotRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an alias for the specified version of the bot or replaces an alias for the specified bot. To change the
     * version of the bot that the alias points to, replace the alias. For more information about aliases, see
     * <a>versioning-aliases</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutBotAlias</code> action.
     * </p>
     *
     * @param putBotAliasRequest
     * @return Result of the PutBotAlias operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws PreconditionFailedException
     *         The checksum of the resource that you are trying to change does not match the checksum in the request.
     *         Check the resource's checksum and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.PutBotAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutBotAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutBotAliasResponse putBotAlias(PutBotAliasRequest putBotAliasRequest) throws ConflictException,
            LimitExceededException, InternalFailureException, BadRequestException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<PutBotAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutBotAliasResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutBotAliasRequest, PutBotAliasResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putBotAliasRequest).withMarshaller(new PutBotAliasRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an intent or replaces an existing intent.
     * </p>
     * <p>
     * To define the interaction between the user and your bot, you use one or more intents. For a pizza ordering bot,
     * for example, you would create an <code>OrderPizza</code> intent.
     * </p>
     * <p>
     * To create an intent or replace an existing intent, you must provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Intent name. For example, <code>OrderPizza</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sample utterances. For example, "Can I order a pizza, please." and "I want to order a pizza."
     * </p>
     * </li>
     * <li>
     * <p>
     * Information to be gathered. You specify slot types for the information that your bot will request from the user.
     * You can specify standard slot types, such as a date or a time, or custom slot types such as the size and crust of
     * a pizza.
     * </p>
     * </li>
     * <li>
     * <p>
     * How the intent will be fulfilled. You can provide a Lambda function or configure the intent to return the intent
     * information to the client application. If you use a Lambda function, when all of the intent information is
     * available, Amazon Lex invokes your Lambda function. If you configure your intent to return the intent information
     * to the client application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify other optional information in the request, such as:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A confirmation prompt to ask the user to confirm an intent. For example, "Shall I order your pizza?"
     * </p>
     * </li>
     * <li>
     * <p>
     * A conclusion statement to send to the user after the intent has been fulfilled. For example,
     * "I placed your pizza order."
     * </p>
     * </li>
     * <li>
     * <p>
     * A follow-up prompt that asks the user for additional activity. For example, asking
     * "Do you want to order a drink with your pizza?"
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify an existing intent name to update the intent, Amazon Lex replaces the values in the
     * <code>&#36LATEST</code> version of the slot type with the values in the request. Amazon Lex removes fields that
     * you don't provide in the request. If you don't specify the required fields, Amazon Lex throws an exception.
     * </p>
     * <p>
     * For more information, see <a>how-it-works</a>.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutIntent</code> action.
     * </p>
     *
     * @param putIntentRequest
     * @return Result of the PutIntent operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws PreconditionFailedException
     *         The checksum of the resource that you are trying to change does not match the checksum in the request.
     *         Check the resource's checksum and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.PutIntent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutIntent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutIntentResponse putIntent(PutIntentRequest putIntentRequest) throws ConflictException, LimitExceededException,
            InternalFailureException, BadRequestException, PreconditionFailedException, AwsServiceException, SdkClientException,
            LexModelBuildingException {

        HttpResponseHandler<PutIntentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutIntentResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutIntentRequest, PutIntentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(putIntentRequest)
                .withMarshaller(new PutIntentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a custom slot type or replaces an existing custom slot type.
     * </p>
     * <p>
     * To create a custom slot type, specify a name for the slot type and a set of enumeration values, which are the
     * values that a slot of this type can assume. For more information, see <a>how-it-works</a>.
     * </p>
     * <p>
     * If you specify the name of an existing slot type, the fields in the request replace the existing values in the
     * <code>&#36LATEST</code> version of the slot type. Amazon Lex removes the fields that you don't provide in the
     * request. If you don't specify required fields, Amazon Lex throws an exception.
     * </p>
     * <p>
     * This operation requires permissions for the <code>lex:PutSlotType</code> action.
     * </p>
     *
     * @param putSlotTypeRequest
     * @return Result of the PutSlotType operation returned by the service.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal Amazon Lex error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and try again.
     * @throws PreconditionFailedException
     *         The checksum of the resource that you are trying to change does not match the checksum in the request.
     *         Check the resource's checksum and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LexModelBuildingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LexModelBuildingClient.PutSlotType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lex-models-2017-04-19/PutSlotType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutSlotTypeResponse putSlotType(PutSlotTypeRequest putSlotTypeRequest) throws ConflictException,
            LimitExceededException, InternalFailureException, BadRequestException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LexModelBuildingException {

        HttpResponseHandler<PutSlotTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutSlotTypeResponseUnmarshaller());

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutSlotTypeRequest, PutSlotTypeResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putSlotTypeRequest).withMarshaller(new PutSlotTypeRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory init() {
        return new AwsJsonProtocolFactory(
                new JsonClientMetadata()
                        .withSupportsCbor(false)
                        .withSupportsIon(false)
                        .withBaseServiceExceptionClass(
                                software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingException.class)
                        .withContentTypeOverride("")
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("InternalFailureException").withModeledClass(
                                        InternalFailureException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(
                                        ResourceInUseException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(
                                        NotFoundException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(
                                        LimitExceededException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("ConflictException").withModeledClass(
                                        ConflictException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("PreconditionFailedException").withModeledClass(
                                        PreconditionFailedException.class))
                        .addErrorMetadata(
                                new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(
                                        BadRequestException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1")
                        .protocol(AwsJsonProtocol.REST_JSON).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
