/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.CodeHookMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a Lambda function that verifies requests to a bot or fulfills the user's request to a bot..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CodeHook implements StructuredPojo, ToCopyableBuilder<CodeHook.Builder, CodeHook> {
    private final String uri;

    private final String messageVersion;

    private CodeHook(BuilderImpl builder) {
        this.uri = builder.uri;
        this.messageVersion = builder.messageVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function.
     */
    public String uri() {
        return uri;
    }

    /**
     * <p>
     * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For more
     * information, see <a>using-lambda</a>.
     * </p>
     * 
     * @return The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For
     *         more information, see <a>using-lambda</a>.
     */
    public String messageVersion() {
        return messageVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(messageVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeHook)) {
            return false;
        }
        CodeHook other = (CodeHook) obj;
        return Objects.equals(uri(), other.uri()) && Objects.equals(messageVersion(), other.messageVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("CodeHook").add("Uri", uri()).add("MessageVersion", messageVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uri":
            return Optional.of(clazz.cast(uri()));
        case "messageVersion":
            return Optional.of(clazz.cast(messageVersion()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CodeHookMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CodeHook> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function.
         * </p>
         * 
         * @param uri
         *        The Amazon Resource Name (ARN) of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The version of the request-response that you want Amazon Lex to use to invoke your Lambda function. For more
         * information, see <a>using-lambda</a>.
         * </p>
         * 
         * @param messageVersion
         *        The version of the request-response that you want Amazon Lex to use to invoke your Lambda function.
         *        For more information, see <a>using-lambda</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageVersion(String messageVersion);
    }

    static final class BuilderImpl implements Builder {
        private String uri;

        private String messageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeHook model) {
            uri(model.uri);
            messageVersion(model.messageVersion);
        }

        public final String getUri() {
            return uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getMessageVersion() {
            return messageVersion;
        }

        @Override
        public final Builder messageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
            return this;
        }

        public final void setMessageVersion(String messageVersion) {
            this.messageVersion = messageVersion;
        }

        @Override
        public CodeHook build() {
            return new CodeHook(this);
        }
    }
}
