/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBuiltinIntentsResponse extends LexModelBuildingResponse implements
        ToCopyableBuilder<GetBuiltinIntentsResponse.Builder, GetBuiltinIntentsResponse> {
    private final List<BuiltinIntentMetadata> intents;

    private final String nextToken;

    private GetBuiltinIntentsResponse(BuilderImpl builder) {
        super(builder);
        this.intents = builder.intents;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.
     */
    public List<BuiltinIntentMetadata> intents() {
        return intents;
    }

    /**
     * <p>
     * A pagination token that fetches the next page of intents. If the response to this API call is truncated, Amazon
     * Lex returns a pagination token in the response. To fetch the next page of intents, specify the pagination token
     * in the next request.
     * </p>
     * 
     * @return A pagination token that fetches the next page of intents. If the response to this API call is truncated,
     *         Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the
     *         pagination token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intents());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentsResponse)) {
            return false;
        }
        GetBuiltinIntentsResponse other = (GetBuiltinIntentsResponse) obj;
        return Objects.equals(intents(), other.intents()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBuiltinIntentsResponse").add("Intents", intents()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intents":
            return Optional.of(clazz.cast(intents()));
        case "nextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingResponse.Builder, CopyableBuilder<Builder, GetBuiltinIntentsResponse> {
        /**
         * <p>
         * An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.
         * </p>
         * 
         * @param intents
         *        An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(Collection<BuiltinIntentMetadata> intents);

        /**
         * <p>
         * An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.
         * </p>
         * 
         * @param intents
         *        An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intents(BuiltinIntentMetadata... intents);

        /**
         * <p>
         * An array of <code>builtinIntentMetadata</code> objects, one for each intent in the response.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BuiltinIntentMetadata>.Builder} avoiding
         * the need to create one manually via {@link List<BuiltinIntentMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BuiltinIntentMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #intents(List<BuiltinIntentMetadata>)}.
         * 
         * @param intents
         *        a consumer that will call methods on {@link List<BuiltinIntentMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intents(List<BuiltinIntentMetadata>)
         */
        Builder intents(Consumer<BuiltinIntentMetadata.Builder>... intents);

        /**
         * <p>
         * A pagination token that fetches the next page of intents. If the response to this API call is truncated,
         * Amazon Lex returns a pagination token in the response. To fetch the next page of intents, specify the
         * pagination token in the next request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that fetches the next page of intents. If the response to this API call is
         *        truncated, Amazon Lex returns a pagination token in the response. To fetch the next page of intents,
         *        specify the pagination token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelBuildingResponse.BuilderImpl implements Builder {
        private List<BuiltinIntentMetadata> intents;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBuiltinIntentsResponse model) {
            super(model);
            intents(model.intents);
            nextToken(model.nextToken);
        }

        public final Collection<BuiltinIntentMetadata.Builder> getIntents() {
            return intents != null ? intents.stream().map(BuiltinIntentMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder intents(Collection<BuiltinIntentMetadata> intents) {
            this.intents = BuiltinIntentMetadataListCopier.copy(intents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(BuiltinIntentMetadata... intents) {
            intents(Arrays.asList(intents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intents(Consumer<BuiltinIntentMetadata.Builder>... intents) {
            intents(Stream.of(intents).map(c -> BuiltinIntentMetadata.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntents(Collection<BuiltinIntentMetadata.BuilderImpl> intents) {
            this.intents = BuiltinIntentMetadataListCopier.copyFromBuilder(intents);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBuiltinIntentsResponse build() {
            return new GetBuiltinIntentsResponse(this);
        }
    }
}
