/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetUtterancesViewRequest extends LexModelBuildingRequest implements
        ToCopyableBuilder<GetUtterancesViewRequest.Builder, GetUtterancesViewRequest> {
    private final String botName;

    private final List<String> botVersions;

    private final String statusType;

    private GetUtterancesViewRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botVersions = builder.botVersions;
        this.statusType = builder.statusType;
    }

    /**
     * <p>
     * The name of the bot for which utterance information should be returned.
     * </p>
     * 
     * @return The name of the bot for which utterance information should be returned.
     */
    public String botName() {
        return botName;
    }

    /**
     * <p>
     * An array of bot versions for which utterance information should be returned. The limit is 5 versions per request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of bot versions for which utterance information should be returned. The limit is 5 versions per
     *         request.
     */
    public List<String> botVersions() {
        return botVersions;
    }

    /**
     * <p>
     * To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances that were
     * not recognized, use <code>Missed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusType} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusTypeAsString}.
     * </p>
     * 
     * @return To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances
     *         that were not recognized, use <code>Missed</code>.
     * @see StatusType
     */
    public StatusType statusType() {
        return StatusType.fromValue(statusType);
    }

    /**
     * <p>
     * To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances that were
     * not recognized, use <code>Missed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusType} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusTypeAsString}.
     * </p>
     * 
     * @return To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances
     *         that were not recognized, use <code>Missed</code>.
     * @see StatusType
     */
    public String statusTypeAsString() {
        return statusType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(botVersions());
        hashCode = 31 * hashCode + Objects.hashCode(statusTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewRequest)) {
            return false;
        }
        GetUtterancesViewRequest other = (GetUtterancesViewRequest) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(botVersions(), other.botVersions())
                && Objects.equals(statusTypeAsString(), other.statusTypeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetUtterancesViewRequest").add("BotName", botName()).add("BotVersions", botVersions())
                .add("StatusType", statusTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.of(clazz.cast(botName()));
        case "botVersions":
            return Optional.of(clazz.cast(botVersions()));
        case "statusType":
            return Optional.of(clazz.cast(statusTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LexModelBuildingRequest.Builder, CopyableBuilder<Builder, GetUtterancesViewRequest> {
        /**
         * <p>
         * The name of the bot for which utterance information should be returned.
         * </p>
         * 
         * @param botName
         *        The name of the bot for which utterance information should be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * An array of bot versions for which utterance information should be returned. The limit is 5 versions per
         * request.
         * </p>
         * 
         * @param botVersions
         *        An array of bot versions for which utterance information should be returned. The limit is 5 versions
         *        per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersions(Collection<String> botVersions);

        /**
         * <p>
         * An array of bot versions for which utterance information should be returned. The limit is 5 versions per
         * request.
         * </p>
         * 
         * @param botVersions
         *        An array of bot versions for which utterance information should be returned. The limit is 5 versions
         *        per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersions(String... botVersions);

        /**
         * <p>
         * To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances that
         * were not recognized, use <code>Missed</code>.
         * </p>
         * 
         * @param statusType
         *        To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances
         *        that were not recognized, use <code>Missed</code>.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder statusType(String statusType);

        /**
         * <p>
         * To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances that
         * were not recognized, use <code>Missed</code>.
         * </p>
         * 
         * @param statusType
         *        To return utterances that were recognized and handled, use<code>Detected</code>. To return utterances
         *        that were not recognized, use <code>Missed</code>.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder statusType(StatusType statusType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelBuildingRequest.BuilderImpl implements Builder {
        private String botName;

        private List<String> botVersions;

        private String statusType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewRequest model) {
            super(model);
            botName(model.botName);
            botVersions(model.botVersions);
            statusType(model.statusType);
        }

        public final String getBotName() {
            return botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Collection<String> getBotVersions() {
            return botVersions;
        }

        @Override
        public final Builder botVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersions(String... botVersions) {
            botVersions(Arrays.asList(botVersions));
            return this;
        }

        public final void setBotVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
        }

        public final String getStatusType() {
            return statusType;
        }

        @Override
        public final Builder statusType(String statusType) {
            this.statusType = statusType;
            return this;
        }

        @Override
        public final Builder statusType(StatusType statusType) {
            this.statusType(statusType.toString());
            return this;
        }

        public final void setStatusType(String statusType) {
            this.statusType = statusType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetUtterancesViewRequest build() {
            return new GetUtterancesViewRequest(this);
        }
    }
}
