/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetUtterancesViewRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetUtterancesViewRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetUtterancesViewRequestModelMarshaller {
    private static final MarshallingInfo<String> BOTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("botname").isBinary(false).build();

    private static final MarshallingInfo<List> BOTVERSIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("bot_versions").isBinary(false).build();

    private static final MarshallingInfo<String> STATUSTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("status_type").isBinary(false).build();

    private static final GetUtterancesViewRequestModelMarshaller INSTANCE = new GetUtterancesViewRequestModelMarshaller();

    private GetUtterancesViewRequestModelMarshaller() {
    }

    public static GetUtterancesViewRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetUtterancesViewRequest getUtterancesViewRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getUtterancesViewRequest, "getUtterancesViewRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getUtterancesViewRequest.botName(), BOTNAME_BINDING);
            protocolMarshaller.marshall(getUtterancesViewRequest.botVersions(), BOTVERSIONS_BINDING);
            protocolMarshaller.marshall(getUtterancesViewRequest.statusTypeAsString(), STATUSTYPE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
