/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelbuilding.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceData;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UtteranceData} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UtteranceDataMarshaller {
    private static final MarshallingInfo<String> UTTERANCESTRING_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utteranceString").isBinary(false).build();

    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").isBinary(false).build();

    private static final MarshallingInfo<Integer> DISTINCTUSERS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distinctUsers").isBinary(false).build();

    private static final MarshallingInfo<Instant> FIRSTUTTEREDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstUtteredDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUTTEREDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUtteredDate").isBinary(false).build();

    private static final UtteranceDataMarshaller INSTANCE = new UtteranceDataMarshaller();

    private UtteranceDataMarshaller() {
    }

    public static UtteranceDataMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UtteranceData utteranceData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(utteranceData, "utteranceData");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(utteranceData.utteranceString(), UTTERANCESTRING_BINDING);
            protocolMarshaller.marshall(utteranceData.count(), COUNT_BINDING);
            protocolMarshaller.marshall(utteranceData.distinctUsers(), DISTINCTUSERS_BINDING);
            protocolMarshaller.marshall(utteranceData.firstUtteredDate(), FIRSTUTTEREDDATE_BINDING);
            protocolMarshaller.marshall(utteranceData.lastUtteredDate(), LASTUTTEREDDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
