/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.lexmodelbuilding.model.Locale;
import software.amazon.awssdk.services.lexmodelbuilding.model.LocaleListCopier;
import software.amazon.awssdk.services.lexmodelbuilding.transform.BuiltinSlotTypeMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BuiltinSlotTypeMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, BuiltinSlotTypeMetadata> {
    private final String signature;
    private final List<String> supportedLocales;

    private BuiltinSlotTypeMetadata(BuilderImpl builder) {
        this.signature = builder.signature;
        this.supportedLocales = builder.supportedLocales;
    }

    public String signature() {
        return this.signature;
    }

    public List<Locale> supportedLocales() {
        return TypeConverter.convert(this.supportedLocales, Locale::fromValue);
    }

    public List<String> supportedLocalesAsStrings() {
        return this.supportedLocales;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedLocalesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuiltinSlotTypeMetadata)) {
            return false;
        }
        BuiltinSlotTypeMetadata other = (BuiltinSlotTypeMetadata)obj;
        return Objects.equals(this.signature(), other.signature()) && Objects.equals(this.supportedLocalesAsStrings(), other.supportedLocalesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"BuiltinSlotTypeMetadata").add("Signature", (Object)this.signature()).add("SupportedLocales", this.supportedLocalesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signature": {
                return Optional.of(clazz.cast(this.signature()));
            }
            case "supportedLocales": {
                return Optional.of(clazz.cast(this.supportedLocalesAsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuiltinSlotTypeMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String signature;
        private List<String> supportedLocales;

        private BuilderImpl() {
        }

        private BuilderImpl(BuiltinSlotTypeMetadata model) {
            this.signature(model.signature);
            this.supportedLocales(model.supportedLocales);
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public final Collection<String> getSupportedLocales() {
            return this.supportedLocales;
        }

        @Override
        public final Builder supportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedLocales(String ... supportedLocales) {
            this.supportedLocales(Arrays.asList(supportedLocales));
            return this;
        }

        public final void setSupportedLocales(Collection<String> supportedLocales) {
            this.supportedLocales = LocaleListCopier.copy(supportedLocales);
        }

        public BuiltinSlotTypeMetadata build() {
            return new BuiltinSlotTypeMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BuiltinSlotTypeMetadata> {
        public Builder signature(String var1);

        public Builder supportedLocales(Collection<String> var1);

        public Builder supportedLocales(String ... var1);
    }
}

