/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ContentType {
    PLAIN_TEXT("PlainText"),
    SSML("SSML"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ContentType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContentType> knownValues() {
        return Stream.of(ContentType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

