/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.CodeHook;
import software.amazon.awssdk.services.lexmodelbuilding.model.FulfillmentActivityType;
import software.amazon.awssdk.services.lexmodelbuilding.transform.FulfillmentActivityMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FulfillmentActivity
implements StructuredPojo,
ToCopyableBuilder<Builder, FulfillmentActivity> {
    private final String type;
    private final CodeHook codeHook;

    private FulfillmentActivity(BuilderImpl builder) {
        this.type = builder.type;
        this.codeHook = builder.codeHook;
    }

    public FulfillmentActivityType type() {
        return FulfillmentActivityType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public CodeHook codeHook() {
        return this.codeHook;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeHook());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FulfillmentActivity)) {
            return false;
        }
        FulfillmentActivity other = (FulfillmentActivity)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.codeHook(), other.codeHook());
    }

    public String toString() {
        return ToString.builder((String)"FulfillmentActivity").add("Type", (Object)this.typeAsString()).add("CodeHook", (Object)this.codeHook()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "codeHook": {
                return Optional.of(clazz.cast(this.codeHook()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FulfillmentActivityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private CodeHook codeHook;

        private BuilderImpl() {
        }

        private BuilderImpl(FulfillmentActivity model) {
            this.type(model.type);
            this.codeHook(model.codeHook);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FulfillmentActivityType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final CodeHook.Builder getCodeHook() {
            return this.codeHook != null ? this.codeHook.toBuilder() : null;
        }

        @Override
        public final Builder codeHook(CodeHook codeHook) {
            this.codeHook = codeHook;
            return this;
        }

        public final void setCodeHook(CodeHook.BuilderImpl codeHook) {
            this.codeHook = codeHook != null ? codeHook.build() : null;
        }

        public FulfillmentActivity build() {
            return new FulfillmentActivity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FulfillmentActivity> {
        public Builder type(String var1);

        public Builder type(FulfillmentActivityType var1);

        public Builder codeHook(CodeHook var1);

        default public Builder codeHook(Consumer<CodeHook.Builder> codeHook) {
            return this.codeHook((CodeHook)((CodeHook.Builder)CodeHook.builder().apply(codeHook)).build());
        }
    }
}

