/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingResponse;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeMetadata;
import software.amazon.awssdk.services.lexmodelbuilding.model.SlotTypeMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSlotTypeVersionsResponse
extends LexModelBuildingResponse
implements ToCopyableBuilder<Builder, GetSlotTypeVersionsResponse> {
    private final List<SlotTypeMetadata> slotTypes;
    private final String nextToken;

    private GetSlotTypeVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.slotTypes = builder.slotTypes;
        this.nextToken = builder.nextToken;
    }

    public List<SlotTypeMetadata> slotTypes() {
        return this.slotTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.slotTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSlotTypeVersionsResponse)) {
            return false;
        }
        GetSlotTypeVersionsResponse other = (GetSlotTypeVersionsResponse)((Object)obj);
        return Objects.equals(this.slotTypes(), other.slotTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetSlotTypeVersionsResponse").add("SlotTypes", this.slotTypes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "slotTypes": {
                return Optional.of(clazz.cast(this.slotTypes()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingResponse.BuilderImpl
    implements Builder {
        private List<SlotTypeMetadata> slotTypes;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSlotTypeVersionsResponse model) {
            super(model);
            this.slotTypes(model.slotTypes);
            this.nextToken(model.nextToken);
        }

        public final Collection<SlotTypeMetadata.Builder> getSlotTypes() {
            return this.slotTypes != null ? (Collection)this.slotTypes.stream().map(SlotTypeMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder slotTypes(Collection<SlotTypeMetadata> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copy(slotTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(SlotTypeMetadata ... slotTypes) {
            this.slotTypes(Arrays.asList(slotTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slotTypes(Consumer<SlotTypeMetadata.Builder> ... slotTypes) {
            this.slotTypes(Stream.of(slotTypes).map(c -> (SlotTypeMetadata)((SlotTypeMetadata.Builder)SlotTypeMetadata.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSlotTypes(Collection<SlotTypeMetadata.BuilderImpl> slotTypes) {
            this.slotTypes = SlotTypeMetadataListCopier.copyFromBuilder(slotTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSlotTypeVersionsResponse build() {
            return new GetSlotTypeVersionsResponse(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingResponse.Builder,
    CopyableBuilder<Builder, GetSlotTypeVersionsResponse> {
        public Builder slotTypes(Collection<SlotTypeMetadata> var1);

        public Builder slotTypes(SlotTypeMetadata ... var1);

        public Builder slotTypes(Consumer<SlotTypeMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

