/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lexmodelbuilding.model.BotVersionsCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.LexModelBuildingRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetUtterancesViewRequest
extends LexModelBuildingRequest
implements ToCopyableBuilder<Builder, GetUtterancesViewRequest> {
    private final String botName;
    private final List<String> botVersions;
    private final String statusType;

    private GetUtterancesViewRequest(BuilderImpl builder) {
        super(builder);
        this.botName = builder.botName;
        this.botVersions = builder.botVersions;
        this.statusType = builder.statusType;
    }

    public String botName() {
        return this.botName;
    }

    public List<String> botVersions() {
        return this.botVersions;
    }

    public StatusType statusType() {
        return StatusType.fromValue(this.statusType);
    }

    public String statusTypeAsString() {
        return this.statusType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botName());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUtterancesViewRequest)) {
            return false;
        }
        GetUtterancesViewRequest other = (GetUtterancesViewRequest)((Object)obj);
        return Objects.equals(this.botName(), other.botName()) && Objects.equals(this.botVersions(), other.botVersions()) && Objects.equals(this.statusTypeAsString(), other.statusTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetUtterancesViewRequest").add("BotName", (Object)this.botName()).add("BotVersions", this.botVersions()).add("StatusType", (Object)this.statusTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botName": {
                return Optional.of(clazz.cast(this.botName()));
            }
            case "botVersions": {
                return Optional.of(clazz.cast(this.botVersions()));
            }
            case "statusType": {
                return Optional.of(clazz.cast(this.statusTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LexModelBuildingRequest.BuilderImpl
    implements Builder {
        private String botName;
        private List<String> botVersions;
        private String statusType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUtterancesViewRequest model) {
            super(model);
            this.botName(model.botName);
            this.botVersions(model.botVersions);
            this.statusType(model.statusType);
        }

        public final String getBotName() {
            return this.botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        public final Collection<String> getBotVersions() {
            return this.botVersions;
        }

        @Override
        public final Builder botVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botVersions(String ... botVersions) {
            this.botVersions(Arrays.asList(botVersions));
            return this;
        }

        public final void setBotVersions(Collection<String> botVersions) {
            this.botVersions = BotVersionsCopier.copy(botVersions);
        }

        public final String getStatusType() {
            return this.statusType;
        }

        @Override
        public final Builder statusType(String statusType) {
            this.statusType = statusType;
            return this;
        }

        @Override
        public final Builder statusType(StatusType statusType) {
            this.statusType(statusType.toString());
            return this;
        }

        public final void setStatusType(String statusType) {
            this.statusType = statusType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetUtterancesViewRequest build() {
            return new GetUtterancesViewRequest(this);
        }
    }

    public static interface Builder
    extends LexModelBuildingRequest.Builder,
    CopyableBuilder<Builder, GetUtterancesViewRequest> {
        public Builder botName(String var1);

        public Builder botVersions(Collection<String> var1);

        public Builder botVersions(String ... var1);

        public Builder statusType(String var1);

        public Builder statusType(StatusType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

