/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.model.ContentType;
import software.amazon.awssdk.services.lexmodelbuilding.transform.MessageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Message
implements StructuredPojo,
ToCopyableBuilder<Builder, Message> {
    private final String contentType;
    private final String content;

    private Message(BuilderImpl builder) {
        this.contentType = builder.contentType;
        this.content = builder.content;
    }

    public ContentType contentType() {
        return ContentType.fromValue(this.contentType);
    }

    public String contentTypeAsString() {
        return this.contentType;
    }

    public String content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.content(), other.content());
    }

    public String toString() {
        return ToString.builder((String)"Message").add("ContentType", (Object)this.contentTypeAsString()).add("Content", (Object)this.content()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.of(clazz.cast(this.contentTypeAsString()));
            }
            case "content": {
                return Optional.of(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentType;
        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.contentType(model.contentType);
            this.content(model.content);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType.toString());
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Message> {
        public Builder contentType(String var1);

        public Builder contentType(ContentType var1);

        public Builder content(String var1);
    }
}

