/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lexmodelbuilding.transform.UtteranceDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UtteranceData
implements StructuredPojo,
ToCopyableBuilder<Builder, UtteranceData> {
    private final String utteranceString;
    private final Integer count;
    private final Integer distinctUsers;
    private final Instant firstUtteredDate;
    private final Instant lastUtteredDate;

    private UtteranceData(BuilderImpl builder) {
        this.utteranceString = builder.utteranceString;
        this.count = builder.count;
        this.distinctUsers = builder.distinctUsers;
        this.firstUtteredDate = builder.firstUtteredDate;
        this.lastUtteredDate = builder.lastUtteredDate;
    }

    public String utteranceString() {
        return this.utteranceString;
    }

    public Integer count() {
        return this.count;
    }

    public Integer distinctUsers() {
        return this.distinctUsers;
    }

    public Instant firstUtteredDate() {
        return this.firstUtteredDate;
    }

    public Instant lastUtteredDate() {
        return this.lastUtteredDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.utteranceString());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.distinctUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstUtteredDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUtteredDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceData)) {
            return false;
        }
        UtteranceData other = (UtteranceData)obj;
        return Objects.equals(this.utteranceString(), other.utteranceString()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.distinctUsers(), other.distinctUsers()) && Objects.equals(this.firstUtteredDate(), other.firstUtteredDate()) && Objects.equals(this.lastUtteredDate(), other.lastUtteredDate());
    }

    public String toString() {
        return ToString.builder((String)"UtteranceData").add("UtteranceString", (Object)this.utteranceString()).add("Count", (Object)this.count()).add("DistinctUsers", (Object)this.distinctUsers()).add("FirstUtteredDate", (Object)this.firstUtteredDate()).add("LastUtteredDate", (Object)this.lastUtteredDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "utteranceString": {
                return Optional.of(clazz.cast(this.utteranceString()));
            }
            case "count": {
                return Optional.of(clazz.cast(this.count()));
            }
            case "distinctUsers": {
                return Optional.of(clazz.cast(this.distinctUsers()));
            }
            case "firstUtteredDate": {
                return Optional.of(clazz.cast(this.firstUtteredDate()));
            }
            case "lastUtteredDate": {
                return Optional.of(clazz.cast(this.lastUtteredDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UtteranceDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String utteranceString;
        private Integer count;
        private Integer distinctUsers;
        private Instant firstUtteredDate;
        private Instant lastUtteredDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceData model) {
            this.utteranceString(model.utteranceString);
            this.count(model.count);
            this.distinctUsers(model.distinctUsers);
            this.firstUtteredDate(model.firstUtteredDate);
            this.lastUtteredDate(model.lastUtteredDate);
        }

        public final String getUtteranceString() {
            return this.utteranceString;
        }

        @Override
        public final Builder utteranceString(String utteranceString) {
            this.utteranceString = utteranceString;
            return this;
        }

        public final void setUtteranceString(String utteranceString) {
            this.utteranceString = utteranceString;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Integer getDistinctUsers() {
            return this.distinctUsers;
        }

        @Override
        public final Builder distinctUsers(Integer distinctUsers) {
            this.distinctUsers = distinctUsers;
            return this;
        }

        public final void setDistinctUsers(Integer distinctUsers) {
            this.distinctUsers = distinctUsers;
        }

        public final Instant getFirstUtteredDate() {
            return this.firstUtteredDate;
        }

        @Override
        public final Builder firstUtteredDate(Instant firstUtteredDate) {
            this.firstUtteredDate = firstUtteredDate;
            return this;
        }

        public final void setFirstUtteredDate(Instant firstUtteredDate) {
            this.firstUtteredDate = firstUtteredDate;
        }

        public final Instant getLastUtteredDate() {
            return this.lastUtteredDate;
        }

        @Override
        public final Builder lastUtteredDate(Instant lastUtteredDate) {
            this.lastUtteredDate = lastUtteredDate;
            return this;
        }

        public final void setLastUtteredDate(Instant lastUtteredDate) {
            this.lastUtteredDate = lastUtteredDate;
        }

        public UtteranceData build() {
            return new UtteranceData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UtteranceData> {
        public Builder utteranceString(String var1);

        public Builder count(Integer var1);

        public Builder distinctUsers(Integer var1);

        public Builder firstUtteredDate(Instant var1);

        public Builder lastUtteredDate(Instant var1);
    }
}

