/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsResponse;

public class GetBotChannelAssociationsIterable
implements SdkIterable<GetBotChannelAssociationsResponse> {
    private final LexModelBuildingClient client;
    private final GetBotChannelAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBotChannelAssociationsIterable(LexModelBuildingClient client, GetBotChannelAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBotChannelAssociationsResponseFetcher();
    }

    public Iterator<GetBotChannelAssociationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetBotChannelAssociationsIterable resume(GetBotChannelAssociationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBotChannelAssociationsIterable(this.client, (GetBotChannelAssociationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBotChannelAssociationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetBotChannelAssociationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetBotChannelAssociationsResponseFetcher
    implements SyncPageFetcher<GetBotChannelAssociationsResponse> {
        private GetBotChannelAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotChannelAssociationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBotChannelAssociationsResponse nextPage(GetBotChannelAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetBotChannelAssociationsIterable.this.client.getBotChannelAssociations(GetBotChannelAssociationsIterable.this.firstRequest);
            }
            return GetBotChannelAssociationsIterable.this.client.getBotChannelAssociations((GetBotChannelAssociationsRequest)((Object)GetBotChannelAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

