/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingAsyncClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotChannelAssociationsResponse;

public class GetBotChannelAssociationsPublisher
implements SdkPublisher<GetBotChannelAssociationsResponse> {
    private final LexModelBuildingAsyncClient client;
    private final GetBotChannelAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBotChannelAssociationsPublisher(LexModelBuildingAsyncClient client, GetBotChannelAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBotChannelAssociationsPublisher(LexModelBuildingAsyncClient client, GetBotChannelAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBotChannelAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBotChannelAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetBotChannelAssociationsPublisher resume(GetBotChannelAssociationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBotChannelAssociationsPublisher(this.client, (GetBotChannelAssociationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBotChannelAssociationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetBotChannelAssociationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetBotChannelAssociationsResponseFetcher
    implements AsyncPageFetcher<GetBotChannelAssociationsResponse> {
        private GetBotChannelAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotChannelAssociationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetBotChannelAssociationsResponse> nextPage(GetBotChannelAssociationsResponse previousPage) {
            if (previousPage == null) {
                return GetBotChannelAssociationsPublisher.this.client.getBotChannelAssociations(GetBotChannelAssociationsPublisher.this.firstRequest);
            }
            return GetBotChannelAssociationsPublisher.this.client.getBotChannelAssociations((GetBotChannelAssociationsRequest)((Object)GetBotChannelAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

