/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBotVersionsResponse;

public class GetBotVersionsIterable
implements SdkIterable<GetBotVersionsResponse> {
    private final LexModelBuildingClient client;
    private final GetBotVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBotVersionsIterable(LexModelBuildingClient client, GetBotVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetBotVersionsResponseFetcher();
    }

    public Iterator<GetBotVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetBotVersionsIterable resume(GetBotVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetBotVersionsIterable(this.client, (GetBotVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetBotVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetBotVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetBotVersionsResponseFetcher
    implements SyncPageFetcher<GetBotVersionsResponse> {
        private GetBotVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetBotVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetBotVersionsResponse nextPage(GetBotVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetBotVersionsIterable.this.client.getBotVersions(GetBotVersionsIterable.this.firstRequest);
            }
            return GetBotVersionsIterable.this.client.getBotVersions((GetBotVersionsRequest)((Object)GetBotVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

